# Tutorials

Explore the growing collection of ready-to-use configurations for state-of-the-art models and training workflows:

| Tutorial | Description | Links |
|----------|-------------|--------|
| {gh}`🎯 Getting Started: A Tour <notebooks/Oumi - A Tour.ipynb>` | Comprehensive overview of Oumi's architecture and core capabilities | {download}`Download </../notebooks/Oumi - A Tour.ipynb>` <br> <a target="_blank" href="https://colab.research.google.com/github/oumi-ai/oumi/blob/main/notebooks/Oumi - A Tour.ipynb"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"/></a> |
| **Model Training & Finetuning** |||
| {gh}`🔧 Model Finetuning Guide <notebooks/Oumi - Finetuning Tutorial.ipynb>` | Step-by-step guide to efficient model finetuning techniques | {download}`Download </../notebooks/Oumi - Finetuning Tutorial.ipynb>` <br> <a target="_blank" href="https://colab.research.google.com/github/oumi-ai/oumi/blob/main/notebooks/Oumi - Finetuning Tutorial.ipynb"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"/></a> |
| {gh}`🖼️ Oumi Multimodal <notebooks/Oumi - Vision Language Models.ipynb>` | Step-by-step guide to finetuning vision-language models | {download}`Download </../notebooks/Oumi - Vision Language Models.ipynb>` <br> <a target="_blank" href="https://colab.research.google.com/github/oumi-ai/oumi/blob/main/notebooks/Oumi - Vision Language Models.ipynb"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"/></a>  |
| {gh}`📚 Model Distillation <notebooks/Oumi - Distill a Large Model.ipynb>` | Guide to distilling large models into smaller, efficient ones | {download}`Download </../notebooks/Oumi - Distill a Large Model.ipynb>` <br> <a target="_blank" href="https://colab.research.google.com/github/oumi-ai/oumi/blob/main/notebooks/Oumi - Distill a Large Model.ipynb"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"/></a> |
| **Deployment & Infrastructure** |||
| {gh}`🔄 vLLM Inference Engine <notebooks/Oumi - Using vLLM Engine for Inference.ipynb>` | High-performance inference using vLLM | {download}`Download </../notebooks/Oumi - Using vLLM Engine for Inference.ipynb>` <br> <a target="_blank" href="https://colab.research.google.com/github/oumi-ai/oumi/blob/main/notebooks/Oumi - Using vLLM Engine for Inference.ipynb"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"/></a> |
| {gh}`☁️ Remote Training <notebooks/Oumi - Running Jobs Remotely.ipynb>` | Guide to running jobs on cloud platforms | {download}`Download </../notebooks/Oumi - Running Jobs Remotely.ipynb>` <br> <a target="_blank" href="https://colab.research.google.com/github/oumi-ai/oumi/blob/main/notebooks/Oumi - Running Jobs Remotely.ipynb"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"/></a> |
| {gh}`🖥️ Custom Clusters <notebooks/Oumi - Launching Jobs on Custom Clusters.ipynb>` | Integrating your custom compute clusters | {download}`Download </../notebooks/Oumi - Launching Jobs on Custom Clusters.ipynb>` <br> <a target="_blank" href="https://colab.research.google.com/github/oumi-ai/oumi/blob/main/notebooks/Oumi - Launching Jobs on Custom Clusters.ipynb"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"/></a> |
| {gh}`🚀 Model Deployment <notebooks/Oumi - Deploying a Job.ipynb>` | Guide to deploying models in production | {download}`Download </../notebooks/Oumi - Deploying a Job.ipynb>` <br> <a target="_blank" href="https://colab.research.google.com/github/oumi-ai/oumi/blob/main/notebooks/Oumi - Deploying a Job.ipynb"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"/></a> |
| **Datasets & Evaluation** |||
| {gh}`⚖️ Simple Judge <notebooks/Oumi - Simple Judge.ipynb>` | Creating custom evaluation metrics and judges | {download}`Download </../notebooks/Oumi - Simple Judge.ipynb>` <br> <a target="_blank" href="https://colab.research.google.com/github/oumi-ai/oumi/blob/main/notebooks/Oumi - Simple Judge.ipynb"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"/></a> |
| {gh}`📊 AlpacaEval Evaluation <notebooks/Oumi - Evaluation with AlpacaEval 2.0.ipynb>` | Model evaluation using AlpacaEval 2.0 | {download}`Download </../notebooks/Oumi - Evaluation with AlpacaEval 2.0.ipynb>` <br> <a target="_blank" href="https://colab.research.google.com/github/oumi-ai/oumi/blob/main/notebooks/Oumi - Evaluation with AlpacaEval 2.0.ipynb"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"/></a> |
| {gh}`📋 Oumi Evaluation <notebooks/Oumi - Evaluation with Oumi.ipynb>` | Comprehensive model evaluation using Oumi's evaluation framework | {download}`Download </../notebooks/Oumi - Evaluation with Oumi.ipynb>` <br> <a target="_blank" href="https://colab.research.google.com/github/oumi-ai/oumi/blob/main/notebooks/Oumi - Evaluation with Oumi.ipynb"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"/></a> |
| **Custom Models** |||
| {gh}`🧠 NanoGPT Integration <notebooks/Oumi - Using NanoGPT.ipynb>` | Training and using NanoGPT models with Oumi | {download}`Download </../notebooks/Oumi - Using NanoGPT.ipynb>` <br> <a target="_blank" href="https://colab.research.google.com/github/oumi-ai/oumi/blob/main/notebooks/Oumi - Using NanoGPT.ipynb"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"/></a> |
| {gh}`🔄 CNN Training <notebooks/Oumi - Training CNN on Custom Dataset.ipynb>` | Training CNNs on custom datasets | {download}`Download </../notebooks/Oumi - Training CNN on Custom Dataset.ipynb>` <br> <a target="_blank" href="https://colab.research.google.com/github/oumi-ai/oumi/blob/main/notebooks/Oumi - Training CNN on Custom Dataset.ipynb"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"/></a> |
