from typing import List, Optional

class ReactionSystem:
    def __init__(self, bg_size: int) -> None:
        ...

    def push(self, reactants: List[int], inhibitors: List[int], products: List[int]) -> bool:
        ...

    def remove(self, reactants: List[int], inhibitors: List[int], products: List[int]) -> None:
        ...

    def result(self, state: List[int]) -> List[int]:
        ...

    def enabled(self, state: List[int]) -> bool:
        ...

    def degree(self) -> int:
        ...

    def rank(self) -> int:
        ...

    def minimize_rank(self) -> 'ReactionSystem':
        ...

    def minimize_rank_exact(self) -> 'ReactionSystem':
        ...

    def minimize_degree(self) -> 'ReactionSystem':
        ...

    def complement(self) -> 'ReactionSystem':
        ...

    def primes(self) -> 'ReactionSystem':
        ...

    def essential_primes(self) -> 'ReactionSystem':
        ...

    def __str__(self) -> str:
        ...


class RsFunction:
    def __init__(self, bg_size: int) -> None:
        ...

    def add(self, input: List[int], output: List[int]) -> Optional[List[int]]:
        ...

    def remove(self, input: List[int]) -> Optional[List[int]]:
        ...

    def minimize_rank(self) -> ReactionSystem:
        ...

    def minimize_rank_exact(self) -> ReactionSystem:
        ...

    def minimize_degree(self) -> ReactionSystem:
        ...

    def complement(self) -> ReactionSystem:
        ...

    def primes(self) -> ReactionSystem:
        ...

    def essential_primes(self) -> ReactionSystem:
        ...

    def __str__(self) -> str:
        ...

