"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GlobalAuroraRDSSlaveInfra = exports.GlobalAuroraRDSMaster = exports.InstanceTypeEnum = exports.MySQLtimeZone = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const cdk = require("aws-cdk-lib");
const ec2 = require("aws-cdk-lib/aws-ec2");
const iam = require("aws-cdk-lib/aws-iam");
const lambda = require("aws-cdk-lib/aws-lambda");
const logs = require("aws-cdk-lib/aws-logs");
const rds = require("aws-cdk-lib/aws-rds");
const cr = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
var MySQLtimeZone;
(function (MySQLtimeZone) {
    /**
     * TIME ZONE UTC
     */
    MySQLtimeZone["UTC"] = "UTC";
    /**
     * TIME ZONE Asia/Taipei
     */
    MySQLtimeZone["ASIA_TAIPEI"] = "Asia/Taipei";
    /**
     * TIME ZONE Africa/Cairo
     */
    MySQLtimeZone["AFRICA_CAIRO"] = "Africa/Cairo";
    /**
     * TIME ZONE Asia/Bangkok
     */
    MySQLtimeZone["ASIA_BANGKOK"] = "Asia/Bangkok";
    /**
     * TIME ZONE Australia/Darwin
     */
    MySQLtimeZone["AUSTRALIA_DARWIN"] = "Australia/Darwin";
    /**
     * TIME ZONE Africa/Casablanca
     */
    MySQLtimeZone["AFRICA_CASABLANCA"] = "Africa/Casablanca";
    /**
     * TIME ZONE Asia/Beirut
     */
    MySQLtimeZone["ASIA_BEIRUT"] = "Asia/Beirut";
    /**
     * TIME ZONE Australia/Hobart
     */
    MySQLtimeZone["AUSTRALIA_HOBART"] = "Australia/Hobart";
    /**
     * TIME ZONE Africa/Harare
     */
    MySQLtimeZone["AFRICA_HARARE"] = "Africa/Harare";
    /**
     * TIME ZONE Asia/Calcutta
     */
    MySQLtimeZone["ASIA_CALCUTTA"] = "Asia/Calcutta";
    /**
     * TIME ZONE Australia/Perth
     */
    MySQLtimeZone["AUSTRALIA_PERTH"] = "Australia/Perth";
    /**
     * TIME ZONE Africa/Monrovia
     */
    MySQLtimeZone["AFRICA_MONROVIA"] = "Africa/Monrovia";
    /**
     * TIME ZONE Asia/Damascus
     */
    MySQLtimeZone["ASIA_DAMASCUS"] = "Asia/Damascus";
    /**
     * TIME ZONE Australia/Sydney
     */
    MySQLtimeZone["AUSTRALIA_SYDNEY"] = "Australia/Sydney";
    /**
     * TIME ZONE Africa/Nairobi
     */
    MySQLtimeZone["AFRICA_NAIROBI"] = "Africa/Nairobi";
    /**
     * TIME ZONE Asia/Dhaka
     */
    MySQLtimeZone["ASIA_DHAKA"] = "Asia/Dhaka";
    /**
     * TIME ZONE Brazil/East
     */
    MySQLtimeZone["BRAZIL_EAST"] = "Brazil/East";
    /**
     * TIME ZONE Africa/Tripoli
     */
    MySQLtimeZone["AFRICA_TRIPOLI"] = "Africa/Tripoli";
    /**
     * TIME ZONE Asia/Irkutsk
     */
    MySQLtimeZone["ASIA_IRKUTSK"] = "Asia/Irkutsk";
    /**
     * TIME ZONE Canada/Newfoundland
     */
    MySQLtimeZone["CANADA_NEWFOUNDLAND"] = "Canada/Newfoundland";
    /**
     * TIME ZONE Africa/Windhoek
     */
    MySQLtimeZone["AFRICA_WINDHOEK"] = "Africa/Windhoek";
    /**
     * TIME ZONE Asia/Jerusalem
     */
    MySQLtimeZone["ASIA_JERUSALEM"] = "Asia/Jerusalem";
    /**
     * TIME ZONE Canada/Saskatchewan
     */
    MySQLtimeZone["CANADA_SASKATCHEWAN"] = "Canada/Saskatchewan";
    /**
     * TIME ZONE America/Araguaina
     */
    MySQLtimeZone["AMERICA_ARAGUAINA"] = "America/Araguaina";
    /**
     * TIME ZONE Asia/Kabul
     */
    MySQLtimeZone["ASIA_KABUL"] = "Asia/Kabul";
    /**
     * TIME ZONE Europe/Amsterdam
     */
    MySQLtimeZone["EUROPE_AMSTERDAM"] = "Europe/Amsterdam";
    /**
     * TIME ZONE America/Asuncion
     */
    MySQLtimeZone["AMERICA_ASUNCION"] = "America/Asuncion";
    /**
     * TIME ZONE Asia/Karachi
     */
    MySQLtimeZone["ASIA_KARACHI"] = "Asia/Karachi";
    /**
     * TIME ZONE Europe/Athens
     */
    MySQLtimeZone["EUROPE_ATHENS"] = "Europe/Athens";
    /**
     * TIME ZONE America/Bogota
     */
    MySQLtimeZone["AMERICA_BOGOTA"] = "America/Bogota";
    /**
     * TIME ZONE Asia/Kathmandu
     */
    MySQLtimeZone["ASIA_KATHMANDU"] = "Asia/Kathmandu";
    /**
     * TIME ZONE Europe/Dublin
     */
    MySQLtimeZone["EUROPE_DUBLIN"] = "Europe/Dublin";
    /**
     * TIME ZONE America/Caracas
     */
    MySQLtimeZone["AMERICA_CARACAS"] = "America/Caracas";
    /**
    * TIME ZONE Asia/Krasnoyarsk
    */
    MySQLtimeZone["ASIA_KRASNOYARSK"] = "Asia/Krasnoyarsk";
    /**
     * TIME ZONE Europe/Helsinki
     */
    MySQLtimeZone["EUROPE_HELSINKI"] = "Europe/Helsinki";
    /**
     * TIME ZONE America/Chihuahua
     */
    MySQLtimeZone["AMERICA_CHIHUAHUA"] = "America/Chihuahua";
    /**
     * TIME ZONE Asia/Magadan
     */
    MySQLtimeZone["ASIA_MAGADAN"] = "Asia/Magadan";
    /**
     * TIME ZONE Europe/Istanbul
     */
    MySQLtimeZone["EUROPE_ISTANBUL"] = "Europe/Istanbul";
    /**
     * TIME ZONE America/Cuiaba
     */
    MySQLtimeZone["AMERICA_CUIABA"] = "America/Cuiaba";
    /**
     * TIME ZONE Asia/Muscat
     */
    MySQLtimeZone["ASIA_MUSCAT"] = "Asia/Muscat";
    /**
     * TIME ZONE Europe/Kaliningrad
     */
    MySQLtimeZone["EUROPE_KALININGRAD"] = "Europe/Kaliningrad";
    /**
     * TIME ZONE America/Denver
     */
    MySQLtimeZone["AMERICA_DENVER"] = "America/Denver";
    /**
     * TIME ZONE Asia/Novosibirsk
     */
    MySQLtimeZone["ASIA_NOVOSIBIRSK"] = "Asia/Novosibirsk";
    /**
     * TIME ZONE Europe/Moscow'
     */
    MySQLtimeZone["EUROPE_MOSCOW"] = "Europe/Moscow";
    /**
     * TIME ZONE America/Fortaleza
     */
    MySQLtimeZone["AMERICA_FORTALEZA"] = "America/Fortaleza";
    /**
     * TIME ZONE Asia/Riyadh
     */
    MySQLtimeZone["ASIA_RIYADH"] = "Asia/Riyadh";
    /**
     * TIME ZONE Europe/Paris
     */
    MySQLtimeZone["EUROPE_PARIS"] = "Europe/Paris";
    /**
     * TIME ZONE America/Guatemala
     */
    MySQLtimeZone["AMERICA_GUATEMALA"] = "America/Guatemala";
    /**
     * TIME ZONE Asia/Seoul
     */
    MySQLtimeZone["ASIA_SEOUL"] = "Asia/Seoul";
    /**
     * TIME ZONE Europe/Prague
     */
    MySQLtimeZone["EUROPE_PRAGUE"] = "Europe/Prague";
    /**
     * TIME ZONE America/Halifax
     */
    MySQLtimeZone["AMERICA_HALIFAX"] = "America/Halifax";
    /**
     * TIME ZONE Asia/Shanghai
     */
    MySQLtimeZone["ASIA_SHANGHAI"] = "Asia/Shanghai";
    /**
     * TIME ZONE Europe/Sarajevo
     */
    MySQLtimeZone["EUROPE_SARAJEVO"] = "Europe/Sarajevo";
    /**
     * TIME ZONE America/Manaus
     */
    MySQLtimeZone["AMERICA_MANAUS"] = "America/Manaus";
    /**
     * TIME ZONE Asia/Singapore
     */
    MySQLtimeZone["ASIA_SINGAPORE"] = "Asia/Singapore";
    /**
     * TIME ZONE Pacific/Auckland
     */
    MySQLtimeZone["PACIFIC_AUCKLAND"] = "Pacific/Auckland";
    /**
     * TIME ZONE America/Matamoros
     */
    MySQLtimeZone["AMERICA_MATAMOROS"] = "America/Matamoros";
    /**
     * TIME ZONE Pacific/Fiji
     */
    MySQLtimeZone["PACIFIC_FIJI"] = "Pacific/Fiji";
    /**
     * TIME ZONE America/Monterrey
     */
    MySQLtimeZone["AMERICA_MONTERREY"] = "America/Monterrey";
    /**
     * TIME ZONE Asia/Tehran
     */
    MySQLtimeZone["ASIA_TEHRAN"] = "Asia/Tehran";
    /**
     * TIME ZONE Pacific/Guam
     */
    MySQLtimeZone["PACIFIC_GUAM"] = "Pacific/Guam";
    /**
     * TIME ZONE America/Montevideo
     */
    MySQLtimeZone["AMERICA_MONTEVIDEO"] = "America/Montevideo";
    /**
     * TIME ZONE Asia/Tokyo
     */
    MySQLtimeZone["ASIA_TOKYO"] = "Asia/Tokyo";
    /**
     * TIME ZONE Pacific/Honolulu
     */
    MySQLtimeZone["PACIFIC_HONOLULU"] = "Pacific/Honolulu";
    /**
     * TIME ZONE America/Phoenix
     */
    MySQLtimeZone["AMERICA_PHOENIX"] = "America/Phoenix";
    /**
     * TIME ZONE Asia/Ulaanbaatar
     */
    MySQLtimeZone["ASIA_ULAANBAATAR"] = "Asia/Ulaanbaatar";
    /**
     * TIME ZONE Pacific/Samoa
     */
    MySQLtimeZone["PACIFIC_SAMOA"] = "Pacific/Samoa";
    /**
     * TIME ZONE America/Santiago
     */
    MySQLtimeZone["AMERICA_SANTIAGO"] = "America/Santiago";
    /**
     * TIME ZONE Asia/Vladivostok
     */
    MySQLtimeZone["ASIA_VLADIVOSTOK"] = "Asia/Vladivostok";
    /**
     * TIME ZONE US/Alaska
     */
    MySQLtimeZone["US_ALASKA"] = "US/Alaska";
    /**
     * TIME ZONE America/Tijuana
     */
    MySQLtimeZone["AMERICA_TIJUANA"] = "America/Tijuana";
    /**
     * TIME ZONE Asia/Yakutsk
     */
    MySQLtimeZone["ASIA_YAKUTSK"] = "Asia/Yakutsk";
    /**
     * TIME ZONE US/Central
     */
    MySQLtimeZone["US_CENTRAL"] = "US/Central";
    /**
     * TIME ZONE Asia/Amman
     */
    MySQLtimeZone["ASIA_AMMAN"] = "Asia/Amman";
    /**
     * TIME ZONE Asia/Yerevan
     */
    MySQLtimeZone["ASIA_YEREVAN"] = "Asia/Yerevan";
    /**
    * TIME ZONE US/Eastern
    */
    MySQLtimeZone["US_EASTERN"] = "US/Eastern";
    /**
     * TIME ZONE Asia/Ashgabat
     */
    MySQLtimeZone["ASIA_ASHGABAT"] = "Asia/Ashgabat";
    /**
     * TIME ZONE Atlantic/Azores
     */
    MySQLtimeZone["ATLANTIC_AZORES"] = "Atlantic/Azores";
    /**
     * TIME ZONE US/East-Indiana
     */
    MySQLtimeZone["US_EAST_INDIANA"] = "US/East-Indiana";
    /**
     * TIME ZONE Asia/Baghdad
     */
    MySQLtimeZone["ASIA_BAGHDAD"] = "Asia/Baghdad";
    /**
     * TIME ZONE Australia/Adelaide
     */
    MySQLtimeZone["AUSTRALIA_ADELAIDE"] = "Australia/Adelaide";
    /**
     * TIME ZONE US/Pacific
     */
    MySQLtimeZone["US_PACIFIC"] = "US/Pacific";
    /**
     * TIME ZONE Asia/Baku
     */
    MySQLtimeZone["ASIA_BAKU"] = "Asia/Baku";
    /**
     * TIME ZONE Australia/Brisbane
     */
    MySQLtimeZone["AUSTRALIA_BRISBANE"] = "Australia/Brisbane";
})(MySQLtimeZone = exports.MySQLtimeZone || (exports.MySQLtimeZone = {}));
var InstanceTypeEnum;
(function (InstanceTypeEnum) {
    /**
     * db Instance Type r4.large
     */
    InstanceTypeEnum["R4_LARGE"] = "r4.large";
    /**
     * db Instance Type r4.xlarge
     */
    InstanceTypeEnum["R4_XLARGE"] = "r4.xlarge";
    /**
     * db Instance Type r4.2xlarge
     */
    InstanceTypeEnum["R4_2XLARGE"] = "r4.2xlarge";
    /**
     * db Instance Type r4.4xlarge
     */
    InstanceTypeEnum["R4_4XLARGE"] = "r4.4xlarge";
    /**
     * db Instance Type r4.8xlarge
     */
    InstanceTypeEnum["R4_8XLARGE"] = "r4.8xlarge";
    /**
     * db Instance Type r4.16xlarge
     */
    InstanceTypeEnum["R4_16XLARGE"] = "r4.16xlarge";
    /**
     * db Instance Type r5.large
     */
    InstanceTypeEnum["R5_LARGE"] = "r5.large";
    /**
     * db Instance Type r5.xlarge
     */
    InstanceTypeEnum["R5_XLARGE"] = "r5.xlarge";
    /**
     * db Instance Type r5.2xlarge
     */
    InstanceTypeEnum["R5_2XLARGE"] = "r5.2xlarge";
    /**
     * db Instance Type r5.4xlarge
     */
    InstanceTypeEnum["R5_4XLARGE"] = "r5.4xlarge";
    /**
     * db Instance Type r5.8xlarge
     */
    InstanceTypeEnum["R5_8XLARGE"] = "r5.8xlarge";
    /**
     * db Instance Type r5.12xlarge
     */
    InstanceTypeEnum["R5_12XLARGE"] = "r5.12xlarge";
    /**
     * db Instance Type r5.16xlarge
     */
    InstanceTypeEnum["R5_16XLARGE"] = "r5.16xlarge";
    /**
     * db Instance Type r5.24xlarge
     */
    InstanceTypeEnum["R5_24XLARGE"] = "r5.24xlarge";
    /**
     * db Instance Type r6g.large
     */
    InstanceTypeEnum["R6G_LARGE"] = "r6g.large";
    /**
     * db Instance Type r6g.xlarge
     */
    InstanceTypeEnum["R6G_XLARGE"] = "r6g.xlarge";
    /**
     * db Instance Type r6g.2xlarge
     */
    InstanceTypeEnum["R6G_2XLARGE"] = "r6g.2xlarge";
    /**
     * db Instance Type r6g.4xlarge
     */
    InstanceTypeEnum["R6G_4XLARGE"] = "r6g.4xlarge";
    /**
     * db Instance Type r6g.8xlarge
     */
    InstanceTypeEnum["R6G_8XLARGE"] = "r6g.8xlarge";
    /**
     * db Instance Type r6g.12xlarge
     */
    InstanceTypeEnum["R6G_12XLARGE"] = "r6g.12xlarge";
    /**
     * db Instance Type r6g.16xlarge
     */
    InstanceTypeEnum["R6G_16XLARGE"] = "r6g.16xlarge";
})(InstanceTypeEnum = exports.InstanceTypeEnum || (exports.InstanceTypeEnum = {}));
const GlobalAuroraRDSSupportRegion = ['us-east-1', 'us-east-2', 'us-west-1', 'us-west-2', 'eu-west-1', 'eu-west-2', 'eu-west-3', 'eu-central-1',
    'ap-south-1', 'ap-southeast-1', 'ap-southeast-2', 'ap-northeast-1', 'ap-northeast-2', 'ca-central-1'];
class GlobalAuroraRDSMaster extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const stack = cdk.Stack.of(this);
        if (GlobalAuroraRDSSupportRegion.indexOf(stack.region) == -1) {
            throw new Error(`This region ${stack.region} not Support Global RDS !!!`);
        }
        let rdsCredentials;
        if (props?.rdsPassword) {
            rdsCredentials = {
                username: props?.dbUserName ?? 'sysadmin',
                password: cdk.SecretValue.plainText(props?.rdsPassword),
            };
        }
        else {
            rdsCredentials = {
                username: props?.dbUserName ?? 'sysadmin',
            };
        }
        ;
        // Mysql need (MySQL 5.6 / version > 5.6.10a) , Postgres need (version 10.11 , 10.12 , 11.7 or later)
        this.engineVersion = props?.engineVersion ?? rds.DatabaseClusterEngine.auroraMysql({
            version: rds.AuroraMysqlEngineVersion.VER_2_07_1,
        });
        this.rdsInstanceType = props?.instanceType ?? InstanceTypeEnum.R5_LARGE;
        // Master region Vpc
        const rdsVpc = props?.vpc ?? new ec2.Vpc(this, 'RDSVpcRegionMaster', {
            cidr: '10.108.0.0/16',
            enableDnsHostnames: true,
            enableDnsSupport: true,
            natGateways: 1,
        });
        this.dbClusterpPG = props?.dbClusterpPG ?? new rds.ParameterGroup(this, 'dbClusterparametergroup', {
            engine: this.engineVersion,
            parameters: props?.parameters ?? {
                time_zone: props?.timeZone ?? MySQLtimeZone.UTC,
            },
        });
        let rdsVpcSubnetSelect = ec2.SubnetType.PRIVATE;
        if (this.azOfSubnets(rdsVpc.privateSubnets) === 0) {
            rdsVpcSubnetSelect = ec2.SubnetType.PUBLIC;
        }
        this.rdsCluster = new rds.DatabaseCluster(this, 'RDSCluster', {
            engine: this.engineVersion,
            parameterGroup: this.dbClusterpPG,
            clusterIdentifier: `${stack.stackName.toLowerCase()}-primary`,
            credentials: rdsCredentials,
            instances: 1,
            instanceProps: {
                // if want publicAccess , need to define vpcSubnets: { subnetType: ec2.SubnetType.PUBLIC } ,
                vpc: rdsVpc,
                vpcSubnets: { subnetType: rdsVpcSubnetSelect },
                instanceType: new ec2.InstanceType(this.rdsInstanceType),
            },
            removalPolicy: cdk.RemovalPolicy.DESTROY,
            defaultDatabaseName: props?.defaultDatabaseName ?? 'globaldatabase',
        });
        this.rdsPassword = `Please use this command get password back , aws secretsmanager get-secret-value --secret-id ${this.rdsCluster.secret?.secretName}` ?? props?.rdsPassword;
        ;
        this.rdsCluster.node.addDependency(rdsVpc);
        this.rdsCluster.connections.allowDefaultPortFrom(ec2.Peer.ipv4(rdsVpc.vpcCidrBlock));
        // custom resource policy
        const CustomResourcePolicy = new iam.PolicyStatement({
            resources: ['*'],
            actions: ['rds:CreateGlobalCluster', 'rds:DeleteGlobalCluster', 'rds:RemoveFromGlobalCluster', 'rds:ModifyGlobalCluster'],
        });
        // Upgrade database to Global.
        const onEvent = new lambda.Function(this, 'onEventHandler', {
            runtime: lambda.Runtime.PYTHON_3_8,
            code: lambda.Code.fromAsset(path.join(__dirname, '../custom-resource-handler')),
            handler: 'global_index.on_event',
            timeout: cdk.Duration.minutes(5),
        });
        const UpgradeglobaldbProvider = new cr.Provider(this, 'UpgradeglobaldbProvider', {
            onEventHandler: onEvent,
            logRetention: logs.RetentionDays.ONE_DAY,
        });
        this.crGlobalRDSProvider = new cdk.CustomResource(this, 'CRUpgradeglobaldbProvider', {
            resourceType: 'Custom::UpgradeGlobalClusterProvider',
            serviceToken: UpgradeglobaldbProvider.serviceToken,
            properties: {
                SourceDBClusterIdentifier: `arn:aws:rds:${stack.region}:${stack.account}:cluster:${this.rdsCluster.clusterIdentifier}`,
                GlobalClusterIdentifier: `global-${stack.stackName.toLowerCase()}`,
            },
        });
        this.crGlobalRDSProvider.node.addDependency(this.rdsCluster);
        onEvent.role?.addToPrincipalPolicy(CustomResourcePolicy);
        this.rdsIsPublic = rdsVpcSubnetSelect;
        new cdk.CfnOutput(this, 'RDSisPublic', {
            value: this.rdsIsPublic,
        });
        this.rdsClusterarn = `arn:aws:rds:${stack.region}:${stack.account}:cluster:${this.rdsCluster.clusterIdentifier}`;
        new cdk.CfnOutput(this, 'RDSClusterarn', {
            value: this.rdsClusterarn,
        });
        this.globalClusterIdentifier = `global-${stack.stackName.toLowerCase()}`;
        new cdk.CfnOutput(this, 'GlobalClusterIdentifier', {
            value: this.globalClusterIdentifier,
        });
        this.engine = cdk.Token.asString(this.crGlobalRDSProvider.getAtt('Engine'));
        new cdk.CfnOutput(this, 'Engine', {
            value: this.engine,
        });
        this.clusterEngineVersion = cdk.Token.asString(this.crGlobalRDSProvider.getAtt('EngineVersion'));
        new cdk.CfnOutput(this, 'clusterEngineVersion', {
            value: this.clusterEngineVersion,
        });
        this.globalClusterArn = cdk.Token.asString(this.crGlobalRDSProvider.getAtt('GlobalClusterArn'));
        new cdk.CfnOutput(this, 'GlobalClusterArn', {
            value: this.globalClusterArn,
        });
        new cdk.CfnOutput(this, 'GlobalClusterPrimaryEndpoint', {
            value: this.rdsCluster.clusterEndpoint.hostname,
        });
    }
    azOfSubnets(subnets) {
        return new Set(subnets.map(subnet => subnet.availabilityZone)).size;
    }
    addRegionalCluster(scope, id, options) {
        const stack = cdk.Stack.of(scope);
        // custom resource policy
        const CustomResourcePolicy = new iam.PolicyStatement({
            resources: ['*'],
            actions: [
                'rds:CreateGlobalCluster', 'rds:DeleteGlobalCluster', 'rds:RemoveFromGlobalCluster', 'rds:ModifyGlobalCluster',
                'rds:CreateDBCluster', 'rds:CreateDBInstance', 'rds:DeleteDBCluster', 'rds:DeleteDBInstance', 'rds:DescribeDBInstances',
                'rds:DescribeGlobalClusters',
            ],
        });
        // Upgrade database to Global.
        const onEvent = new lambda.Function(scope, `${id}-addRegionalonEvent`, {
            runtime: lambda.Runtime.PYTHON_3_8,
            code: lambda.Code.fromAsset(path.join(__dirname, '../custom-resource-handler')),
            handler: 'add_region_index.on_event',
            timeout: cdk.Duration.minutes(10),
        });
        const isComplete = new lambda.Function(scope, `${id}-IsComplete`, {
            code: lambda.Code.fromAsset(path.join(__dirname, '../custom-resource-handler')),
            handler: 'add_region_index.is_complete',
            runtime: lambda.Runtime.PYTHON_3_8,
            timeout: cdk.Duration.minutes(10),
            role: onEvent.role,
        });
        const addRegionalProvider = new cr.Provider(scope, `${id}-addRegionalProvider`, {
            onEventHandler: onEvent,
            isCompleteHandler: isComplete,
            logRetention: logs.RetentionDays.ONE_DAY,
        });
        const CRSecondRDSProvider = new cdk.CustomResource(scope, `${id}-addRegionalCustomResource`, {
            resourceType: 'Custom::addRegionalClusterProvider',
            serviceToken: addRegionalProvider.serviceToken,
            properties: {
                SourceDBClusterIdentifier: this.rdsClusterarn,
                GlobalClusterIdentifier: this.globalClusterIdentifier,
                REGION: options.region,
                DBSubnetGroupName: options.dbSubnetGroupName,
                Engine: this.engine,
                EngineVersion: this.clusterEngineVersion,
                ClusterIdentifier: `${stack.stackName.toLowerCase()}-${options.region}`,
                InstanceType: this.rdsInstanceType,
                rdsIsPublic: this.rdsIsPublic,
                secondRDSClusterArn: `arn:aws:rds:${options.region}:${stack.account}:cluster:${stack.stackName.toLowerCase()}-${options.region}`,
                seconddbInstanceIdentifier: `${stack.stackName.toLowerCase()}-${options.region}-1`,
            },
        });
        CRSecondRDSProvider.node.addDependency(this.crGlobalRDSProvider);
        onEvent.role?.addToPrincipalPolicy(CustomResourcePolicy);
        new cdk.CfnOutput(scope, 'secondRDSClusterArn', {
            value: cdk.Token.asString(CRSecondRDSProvider.getAtt('secondRDSClusterArn')),
        });
        new cdk.CfnOutput(scope, 'seconddbInstanceIdentifier', {
            value: cdk.Token.asString(CRSecondRDSProvider.getAtt('seconddbInstanceIdentifier')),
        });
    }
}
exports.GlobalAuroraRDSMaster = GlobalAuroraRDSMaster;
_a = JSII_RTTI_SYMBOL_1;
GlobalAuroraRDSMaster[_a] = { fqn: "cdk-aurora-globaldatabase.GlobalAuroraRDSMaster", version: "2.0.178" };
class GlobalAuroraRDSSlaveInfra extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const stack = cdk.Stack.of(this);
        if (GlobalAuroraRDSSupportRegion.indexOf(stack.region) == -1) {
            throw new Error(`This region ${stack.region} not Support Global RDS !!!`);
        }
        // Slave region Vpc
        const rdsVpcSecond = props?.vpc ?? new ec2.Vpc(this, 'RDSVpcRegionSlave', {
            cidr: '10.109.0.0/16',
            enableDnsHostnames: true,
            enableDnsSupport: true,
            natGateways: 1,
        });
        const DBsubnetType = props?.subnetType ?? ec2.SubnetType.PRIVATE;
        if (DBsubnetType === ec2.SubnetType.PRIVATE) {
            const PrivateSubnet = rdsVpcSecond.selectSubnets({ subnetType: ec2.SubnetType.PRIVATE });
            this.dbSubnetGroup = new rds.CfnDBSubnetGroup(this, 'Subnets', {
                dbSubnetGroupName: `${stack.stackName.toLowerCase()}-privatesubnetgroup`,
                dbSubnetGroupDescription: 'Private Subnets for database',
                subnetIds: PrivateSubnet.subnetIds,
            });
            cdk.Tags.of(this.dbSubnetGroup).add('Name', 'PrivateDBSubnetGroup');
            this.dbSubnetGroup.node.addDependency(rdsVpcSecond);
        }
        else {
            const PublicSubnet = rdsVpcSecond.selectSubnets({ subnetType: ec2.SubnetType.PUBLIC });
            this.dbSubnetGroup = new rds.CfnDBSubnetGroup(this, 'Subnets', {
                dbSubnetGroupName: `${stack.stackName.toLowerCase()}-publicsubnetgroup`,
                dbSubnetGroupDescription: 'Public Subnets for database',
                subnetIds: PublicSubnet.subnetIds,
            });
            cdk.Tags.of(this.dbSubnetGroup).add('Name', 'PublicDBSubnetGroup');
            this.dbSubnetGroup.node.addDependency(rdsVpcSecond);
        }
        new cdk.CfnOutput(this, 'newDBSubnetGroup', {
            value: `${this.dbSubnetGroup.dbSubnetGroupName}`,
        });
        new cdk.CfnOutput(this, 'stackRegion', {
            value: `${stack.region}`,
        });
    }
}
exports.GlobalAuroraRDSSlaveInfra = GlobalAuroraRDSSlaveInfra;
_b = JSII_RTTI_SYMBOL_1;
GlobalAuroraRDSSlaveInfra[_b] = { fqn: "cdk-aurora-globaldatabase.GlobalAuroraRDSSlaveInfra", version: "2.0.178" };
//# sourceMappingURL=data:application/json;base64,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