"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_cdk_lib_1 = require("aws-cdk-lib");
const ec2 = require("aws-cdk-lib/aws-ec2");
const _rds = require("aws-cdk-lib/aws-rds");
const index_1 = require("./index");
const mockApp = new aws_cdk_lib_1.App();
const envSingapro = { account: process.env.CDK_DEFAULT_ACCOUNT, region: 'ap-southeast-1' };
const envTokyo = { account: process.env.CDK_DEFAULT_ACCOUNT, region: 'ap-northeast-1' };
const stackM = new aws_cdk_lib_1.Stack(mockApp, 'testing-stackM', { env: envTokyo });
const vpcPublic = new ec2.Vpc(stackM, 'defaultVpc', {
    natGateways: 0,
    maxAzs: 3,
    subnetConfiguration: [{
            cidrMask: 26,
            name: 'masterVPC2',
            subnetType: ec2.SubnetType.PUBLIC,
        }],
});
const globaldbM = new index_1.GlobalAuroraRDSMaster(stackM, 'globalAuroraRDSMaster', {
    instanceType: index_1.InstanceTypeEnum.R5_LARGE,
    vpc: vpcPublic,
    //rdsPassword: '1qaz2wsx',
    engineVersion: _rds.DatabaseClusterEngine.auroraPostgres({ version: _rds.AuroraPostgresEngineVersion.VER_11_7 }),
    dbClusterpPG: new _rds.ParameterGroup(stackM, 'dbClusterparametergroup', {
        engine: _rds.DatabaseClusterEngine.auroraPostgres({
            version: _rds.AuroraPostgresEngineVersion.VER_11_7,
        }),
        parameters: {
            'rds.force_ssl': '1',
            'rds.log_retention_period': '10080',
            'auto_explain.log_min_duration': '5000',
            'auto_explain.log_verbose': '1',
            'timezone': 'UTC+8',
            'shared_preload_libraries': 'auto_explain,pg_stat_statements,pg_hint_plan,pgaudit',
            'log_connections': '1',
            'log_statement': 'ddl',
            'log_disconnections': '1',
            'log_lock_waits': '1',
            'log_min_duration_statement': '5000',
            'log_rotation_age': '1440',
            'log_rotation_size': '102400',
            'random_page_cost': '1',
            'track_activity_query_size': '16384',
            'idle_in_transaction_session_timeout': '7200000',
        },
    }),
});
globaldbM.rdsCluster.connections.allowDefaultPortFrom(ec2.Peer.ipv4(`${process.env.MYIP}/32`));
const stackS = new aws_cdk_lib_1.Stack(mockApp, 'testing-stackS', { env: envSingapro });
const vpcPublic2 = new ec2.Vpc(stackS, 'defaultVpc2', {
    natGateways: 0,
    maxAzs: 3,
    subnetConfiguration: [{
            cidrMask: 26,
            name: 'secondVPC2',
            subnetType: ec2.SubnetType.PUBLIC,
        }],
});
const globaldbS = new index_1.GlobalAuroraRDSSlaveInfra(stackS, 'slaveregion', {
    vpc: vpcPublic2,
    subnetType: ec2.SubnetType.PUBLIC,
});
stackM.addDependency(stackS);
new aws_cdk_lib_1.CfnOutput(stackM, 'password', { value: `${globaldbM.rdsPassword}` });
// add second region cluster
globaldbM.addRegionalCluster(stackM, 'addregionalrds', {
    region: 'ap-southeast-1',
    dbSubnetGroupName: globaldbS.dbSubnetGroup.dbSubnetGroupName,
});
//# sourceMappingURL=data:application/json;base64,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