<a id="mypy-boto3-gamelift"></a>

# mypy-boto3-gamelift

[![PyPI - mypy-boto3-gamelift](https://img.shields.io/pypi/v/mypy-boto3-gamelift.svg?color=blue)](https://pypi.org/project/mypy-boto3-gamelift)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-gamelift.svg?color=blue)](https://pypi.org/project/mypy-boto3-gamelift)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-gamelift?color=blue)](https://pypistats.org/packages/mypy-boto3-gamelift)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.GameLift 1.18.46](https://boto3.amazonaws.com/v1/documentation/api/1.18.46/reference/services/gamelift.html#GameLift)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 5.3.1](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-gamelift docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_gamelift/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-gamelift](#mypy-boto3-gamelift)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `GameLift` service.

```bash
python -m pip install boto3-stubs[gamelift]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[gamelift]` in your environment:
  `python -m pip install 'boto3-stubs[gamelift]'`

Both type checking and auto-complete should work for `GameLift` service. No
explicit type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[gamelift]` in your environment:
  `python -m pip install 'boto3-stubs[gamelift]'`

Both type checking and auto-complete should work for `GameLift` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE supports `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[gamelift]` in your environment:
  `python -m pip install 'boto3-stubs[gamelift]'`
- Run `mypy` as usual

Type checking should work for `GameLift` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[gamelift]` in your environment:
  `python -m pip install 'boto3-stubs[gamelift]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `GameLift` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`GameLiftClient` provides annotations for `boto3.client("gamelift")`.

```python
import boto3

from mypy_boto3_gamelift import GameLiftClient

client: GameLiftClient = boto3.client("gamelift")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: GameLiftClient = session.client("gamelift")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_gamelift.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_gamelift import GameLiftClient
from mypy_boto3_gamelift.paginator import (
    DescribeFleetAttributesPaginator,
    DescribeFleetCapacityPaginator,
    DescribeFleetEventsPaginator,
    DescribeFleetUtilizationPaginator,
    DescribeGameServerInstancesPaginator,
    DescribeGameSessionDetailsPaginator,
    DescribeGameSessionQueuesPaginator,
    DescribeGameSessionsPaginator,
    DescribeInstancesPaginator,
    DescribeMatchmakingConfigurationsPaginator,
    DescribeMatchmakingRuleSetsPaginator,
    DescribePlayerSessionsPaginator,
    DescribeScalingPoliciesPaginator,
    ListAliasesPaginator,
    ListBuildsPaginator,
    ListFleetsPaginator,
    ListGameServerGroupsPaginator,
    ListGameServersPaginator,
    ListScriptsPaginator,
    SearchGameSessionsPaginator,
)

client: GameLiftClient = boto3.client("gamelift")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_fleet_attributes_paginator: DescribeFleetAttributesPaginator = client.get_paginator("describe_fleet_attributes")
describe_fleet_capacity_paginator: DescribeFleetCapacityPaginator = client.get_paginator("describe_fleet_capacity")
describe_fleet_events_paginator: DescribeFleetEventsPaginator = client.get_paginator("describe_fleet_events")
describe_fleet_utilization_paginator: DescribeFleetUtilizationPaginator = client.get_paginator("describe_fleet_utilization")
describe_game_server_instances_paginator: DescribeGameServerInstancesPaginator = client.get_paginator("describe_game_server_instances")
describe_game_session_details_paginator: DescribeGameSessionDetailsPaginator = client.get_paginator("describe_game_session_details")
describe_game_session_queues_paginator: DescribeGameSessionQueuesPaginator = client.get_paginator("describe_game_session_queues")
describe_game_sessions_paginator: DescribeGameSessionsPaginator = client.get_paginator("describe_game_sessions")
describe_instances_paginator: DescribeInstancesPaginator = client.get_paginator("describe_instances")
describe_matchmaking_configurations_paginator: DescribeMatchmakingConfigurationsPaginator = client.get_paginator("describe_matchmaking_configurations")
describe_matchmaking_rule_sets_paginator: DescribeMatchmakingRuleSetsPaginator = client.get_paginator("describe_matchmaking_rule_sets")
describe_player_sessions_paginator: DescribePlayerSessionsPaginator = client.get_paginator("describe_player_sessions")
describe_scaling_policies_paginator: DescribeScalingPoliciesPaginator = client.get_paginator("describe_scaling_policies")
list_aliases_paginator: ListAliasesPaginator = client.get_paginator("list_aliases")
list_builds_paginator: ListBuildsPaginator = client.get_paginator("list_builds")
list_fleets_paginator: ListFleetsPaginator = client.get_paginator("list_fleets")
list_game_server_groups_paginator: ListGameServerGroupsPaginator = client.get_paginator("list_game_server_groups")
list_game_servers_paginator: ListGameServersPaginator = client.get_paginator("list_game_servers")
list_scripts_paginator: ListScriptsPaginator = client.get_paginator("list_scripts")
search_game_sessions_paginator: SearchGameSessionsPaginator = client.get_paginator("search_game_sessions")
```

<a id="literals"></a>

### Literals

`mypy_boto3_gamelift.literals` module contains literals extracted from shapes
that can be used in user code for type checking.

```python
from mypy_boto3_gamelift.literals import (
    AcceptanceTypeType,
    BackfillModeType,
    BalancingStrategyType,
    BuildStatusType,
    CertificateTypeType,
    ComparisonOperatorTypeType,
    DescribeFleetAttributesPaginatorName,
    DescribeFleetCapacityPaginatorName,
    DescribeFleetEventsPaginatorName,
    DescribeFleetUtilizationPaginatorName,
    DescribeGameServerInstancesPaginatorName,
    DescribeGameSessionDetailsPaginatorName,
    DescribeGameSessionQueuesPaginatorName,
    DescribeGameSessionsPaginatorName,
    DescribeInstancesPaginatorName,
    DescribeMatchmakingConfigurationsPaginatorName,
    DescribeMatchmakingRuleSetsPaginatorName,
    DescribePlayerSessionsPaginatorName,
    DescribeScalingPoliciesPaginatorName,
    EC2InstanceTypeType,
    EventCodeType,
    FleetActionType,
    FleetStatusType,
    FleetTypeType,
    FlexMatchModeType,
    GameServerClaimStatusType,
    GameServerGroupActionType,
    GameServerGroupDeleteOptionType,
    GameServerGroupInstanceTypeType,
    GameServerGroupStatusType,
    GameServerHealthCheckType,
    GameServerInstanceStatusType,
    GameServerProtectionPolicyType,
    GameServerUtilizationStatusType,
    GameSessionPlacementStateType,
    GameSessionStatusReasonType,
    GameSessionStatusType,
    InstanceStatusType,
    IpProtocolType,
    ListAliasesPaginatorName,
    ListBuildsPaginatorName,
    ListFleetsPaginatorName,
    ListGameServerGroupsPaginatorName,
    ListGameServersPaginatorName,
    ListScriptsPaginatorName,
    LocationUpdateStatusType,
    MatchmakingConfigurationStatusType,
    MetricNameType,
    OperatingSystemType,
    PlayerSessionCreationPolicyType,
    PlayerSessionStatusType,
    PolicyTypeType,
    PriorityTypeType,
    ProtectionPolicyType,
    RoutingStrategyTypeType,
    ScalingAdjustmentTypeType,
    ScalingStatusTypeType,
    SearchGameSessionsPaginatorName,
    SortOrderType,
    ServiceName,
)

def check_value(value: AcceptanceTypeType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_gamelift.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_gamelift.type_defs import (
    AcceptMatchInputRequestTypeDef,
    AliasTypeDef,
    AttributeValueTypeDef,
    AwsCredentialsTypeDef,
    BuildTypeDef,
    CertificateConfigurationTypeDef,
    ClaimGameServerInputRequestTypeDef,
    ClaimGameServerOutputTypeDef,
    CreateAliasInputRequestTypeDef,
    CreateAliasOutputTypeDef,
    CreateBuildInputRequestTypeDef,
    CreateBuildOutputTypeDef,
    CreateFleetInputRequestTypeDef,
    CreateFleetLocationsInputRequestTypeDef,
    CreateFleetLocationsOutputTypeDef,
    CreateFleetOutputTypeDef,
    CreateGameServerGroupInputRequestTypeDef,
    CreateGameServerGroupOutputTypeDef,
    CreateGameSessionInputRequestTypeDef,
    CreateGameSessionOutputTypeDef,
    CreateGameSessionQueueInputRequestTypeDef,
    CreateGameSessionQueueOutputTypeDef,
    CreateMatchmakingConfigurationInputRequestTypeDef,
    CreateMatchmakingConfigurationOutputTypeDef,
    CreateMatchmakingRuleSetInputRequestTypeDef,
    CreateMatchmakingRuleSetOutputTypeDef,
    CreatePlayerSessionInputRequestTypeDef,
    CreatePlayerSessionOutputTypeDef,
    CreatePlayerSessionsInputRequestTypeDef,
    CreatePlayerSessionsOutputTypeDef,
    CreateScriptInputRequestTypeDef,
    CreateScriptOutputTypeDef,
    CreateVpcPeeringAuthorizationInputRequestTypeDef,
    CreateVpcPeeringAuthorizationOutputTypeDef,
    CreateVpcPeeringConnectionInputRequestTypeDef,
    DeleteAliasInputRequestTypeDef,
    DeleteBuildInputRequestTypeDef,
    DeleteFleetInputRequestTypeDef,
    DeleteFleetLocationsInputRequestTypeDef,
    DeleteFleetLocationsOutputTypeDef,
    DeleteGameServerGroupInputRequestTypeDef,
    DeleteGameServerGroupOutputTypeDef,
    DeleteGameSessionQueueInputRequestTypeDef,
    DeleteMatchmakingConfigurationInputRequestTypeDef,
    DeleteMatchmakingRuleSetInputRequestTypeDef,
    DeleteScalingPolicyInputRequestTypeDef,
    DeleteScriptInputRequestTypeDef,
    DeleteVpcPeeringAuthorizationInputRequestTypeDef,
    DeleteVpcPeeringConnectionInputRequestTypeDef,
    DeregisterGameServerInputRequestTypeDef,
    DescribeAliasInputRequestTypeDef,
    DescribeAliasOutputTypeDef,
    DescribeBuildInputRequestTypeDef,
    DescribeBuildOutputTypeDef,
    DescribeEC2InstanceLimitsInputRequestTypeDef,
    DescribeEC2InstanceLimitsOutputTypeDef,
    DescribeFleetAttributesInputRequestTypeDef,
    DescribeFleetAttributesOutputTypeDef,
    DescribeFleetCapacityInputRequestTypeDef,
    DescribeFleetCapacityOutputTypeDef,
    DescribeFleetEventsInputRequestTypeDef,
    DescribeFleetEventsOutputTypeDef,
    DescribeFleetLocationAttributesInputRequestTypeDef,
    DescribeFleetLocationAttributesOutputTypeDef,
    DescribeFleetLocationCapacityInputRequestTypeDef,
    DescribeFleetLocationCapacityOutputTypeDef,
    DescribeFleetLocationUtilizationInputRequestTypeDef,
    DescribeFleetLocationUtilizationOutputTypeDef,
    DescribeFleetPortSettingsInputRequestTypeDef,
    DescribeFleetPortSettingsOutputTypeDef,
    DescribeFleetUtilizationInputRequestTypeDef,
    DescribeFleetUtilizationOutputTypeDef,
    DescribeGameServerGroupInputRequestTypeDef,
    DescribeGameServerGroupOutputTypeDef,
    DescribeGameServerInputRequestTypeDef,
    DescribeGameServerInstancesInputRequestTypeDef,
    DescribeGameServerInstancesOutputTypeDef,
    DescribeGameServerOutputTypeDef,
    DescribeGameSessionDetailsInputRequestTypeDef,
    DescribeGameSessionDetailsOutputTypeDef,
    DescribeGameSessionPlacementInputRequestTypeDef,
    DescribeGameSessionPlacementOutputTypeDef,
    DescribeGameSessionQueuesInputRequestTypeDef,
    DescribeGameSessionQueuesOutputTypeDef,
    DescribeGameSessionsInputRequestTypeDef,
    DescribeGameSessionsOutputTypeDef,
    DescribeInstancesInputRequestTypeDef,
    DescribeInstancesOutputTypeDef,
    DescribeMatchmakingConfigurationsInputRequestTypeDef,
    DescribeMatchmakingConfigurationsOutputTypeDef,
    DescribeMatchmakingInputRequestTypeDef,
    DescribeMatchmakingOutputTypeDef,
    DescribeMatchmakingRuleSetsInputRequestTypeDef,
    DescribeMatchmakingRuleSetsOutputTypeDef,
    DescribePlayerSessionsInputRequestTypeDef,
    DescribePlayerSessionsOutputTypeDef,
    DescribeRuntimeConfigurationInputRequestTypeDef,
    DescribeRuntimeConfigurationOutputTypeDef,
    DescribeScalingPoliciesInputRequestTypeDef,
    DescribeScalingPoliciesOutputTypeDef,
    DescribeScriptInputRequestTypeDef,
    DescribeScriptOutputTypeDef,
    DescribeVpcPeeringAuthorizationsOutputTypeDef,
    DescribeVpcPeeringConnectionsInputRequestTypeDef,
    DescribeVpcPeeringConnectionsOutputTypeDef,
    DesiredPlayerSessionTypeDef,
    EC2InstanceCountsTypeDef,
    EC2InstanceLimitTypeDef,
    EventTypeDef,
    FilterConfigurationTypeDef,
    FleetAttributesTypeDef,
    FleetCapacityTypeDef,
    FleetUtilizationTypeDef,
    GamePropertyTypeDef,
    GameServerGroupAutoScalingPolicyTypeDef,
    GameServerGroupTypeDef,
    GameServerInstanceTypeDef,
    GameServerTypeDef,
    GameSessionConnectionInfoTypeDef,
    GameSessionDetailTypeDef,
    GameSessionPlacementTypeDef,
    GameSessionQueueDestinationTypeDef,
    GameSessionQueueTypeDef,
    GameSessionTypeDef,
    GetGameSessionLogUrlInputRequestTypeDef,
    GetGameSessionLogUrlOutputTypeDef,
    GetInstanceAccessInputRequestTypeDef,
    GetInstanceAccessOutputTypeDef,
    InstanceAccessTypeDef,
    InstanceCredentialsTypeDef,
    InstanceDefinitionTypeDef,
    InstanceTypeDef,
    IpPermissionTypeDef,
    LaunchTemplateSpecificationTypeDef,
    ListAliasesInputRequestTypeDef,
    ListAliasesOutputTypeDef,
    ListBuildsInputRequestTypeDef,
    ListBuildsOutputTypeDef,
    ListFleetsInputRequestTypeDef,
    ListFleetsOutputTypeDef,
    ListGameServerGroupsInputRequestTypeDef,
    ListGameServerGroupsOutputTypeDef,
    ListGameServersInputRequestTypeDef,
    ListGameServersOutputTypeDef,
    ListScriptsInputRequestTypeDef,
    ListScriptsOutputTypeDef,
    ListTagsForResourceRequestRequestTypeDef,
    ListTagsForResourceResponseTypeDef,
    LocationAttributesTypeDef,
    LocationConfigurationTypeDef,
    LocationStateTypeDef,
    MatchedPlayerSessionTypeDef,
    MatchmakingConfigurationTypeDef,
    MatchmakingRuleSetTypeDef,
    MatchmakingTicketTypeDef,
    PaginatorConfigTypeDef,
    PlacedPlayerSessionTypeDef,
    PlayerLatencyPolicyTypeDef,
    PlayerLatencyTypeDef,
    PlayerSessionTypeDef,
    PlayerTypeDef,
    PriorityConfigurationTypeDef,
    PutScalingPolicyInputRequestTypeDef,
    PutScalingPolicyOutputTypeDef,
    RegisterGameServerInputRequestTypeDef,
    RegisterGameServerOutputTypeDef,
    RequestUploadCredentialsInputRequestTypeDef,
    RequestUploadCredentialsOutputTypeDef,
    ResolveAliasInputRequestTypeDef,
    ResolveAliasOutputTypeDef,
    ResourceCreationLimitPolicyTypeDef,
    ResponseMetadataTypeDef,
    ResumeGameServerGroupInputRequestTypeDef,
    ResumeGameServerGroupOutputTypeDef,
    RoutingStrategyTypeDef,
    RuntimeConfigurationTypeDef,
    S3LocationTypeDef,
    ScalingPolicyTypeDef,
    ScriptTypeDef,
    SearchGameSessionsInputRequestTypeDef,
    SearchGameSessionsOutputTypeDef,
    ServerProcessTypeDef,
    StartFleetActionsInputRequestTypeDef,
    StartFleetActionsOutputTypeDef,
    StartGameSessionPlacementInputRequestTypeDef,
    StartGameSessionPlacementOutputTypeDef,
    StartMatchBackfillInputRequestTypeDef,
    StartMatchBackfillOutputTypeDef,
    StartMatchmakingInputRequestTypeDef,
    StartMatchmakingOutputTypeDef,
    StopFleetActionsInputRequestTypeDef,
    StopFleetActionsOutputTypeDef,
    StopGameSessionPlacementInputRequestTypeDef,
    StopGameSessionPlacementOutputTypeDef,
    StopMatchmakingInputRequestTypeDef,
    SuspendGameServerGroupInputRequestTypeDef,
    SuspendGameServerGroupOutputTypeDef,
    TagResourceRequestRequestTypeDef,
    TagTypeDef,
    TargetConfigurationTypeDef,
    TargetTrackingConfigurationTypeDef,
    UntagResourceRequestRequestTypeDef,
    UpdateAliasInputRequestTypeDef,
    UpdateAliasOutputTypeDef,
    UpdateBuildInputRequestTypeDef,
    UpdateBuildOutputTypeDef,
    UpdateFleetAttributesInputRequestTypeDef,
    UpdateFleetAttributesOutputTypeDef,
    UpdateFleetCapacityInputRequestTypeDef,
    UpdateFleetCapacityOutputTypeDef,
    UpdateFleetPortSettingsInputRequestTypeDef,
    UpdateFleetPortSettingsOutputTypeDef,
    UpdateGameServerGroupInputRequestTypeDef,
    UpdateGameServerGroupOutputTypeDef,
    UpdateGameServerInputRequestTypeDef,
    UpdateGameServerOutputTypeDef,
    UpdateGameSessionInputRequestTypeDef,
    UpdateGameSessionOutputTypeDef,
    UpdateGameSessionQueueInputRequestTypeDef,
    UpdateGameSessionQueueOutputTypeDef,
    UpdateMatchmakingConfigurationInputRequestTypeDef,
    UpdateMatchmakingConfigurationOutputTypeDef,
    UpdateRuntimeConfigurationInputRequestTypeDef,
    UpdateRuntimeConfigurationOutputTypeDef,
    UpdateScriptInputRequestTypeDef,
    UpdateScriptOutputTypeDef,
    ValidateMatchmakingRuleSetInputRequestTypeDef,
    ValidateMatchmakingRuleSetOutputTypeDef,
    VpcPeeringAuthorizationTypeDef,
    VpcPeeringConnectionStatusTypeDef,
    VpcPeeringConnectionTypeDef,
)

def get_structure() -> AcceptMatchInputRequestTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-gamelift` version is the same as related `boto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-gamelift docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_gamelift/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
