# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

from typing import Optional

import httpx

from ..types import vault_list_params
from .._types import NOT_GIVEN, Body, Query, Headers, NotGiven
from .._utils import maybe_transform
from .._compat import cached_property
from .._resource import SyncAPIResource, AsyncAPIResource
from .._response import (
    to_raw_response_wrapper,
    to_streamed_response_wrapper,
    async_to_raw_response_wrapper,
    async_to_streamed_response_wrapper,
)
from ..pagination import SyncCursorPage, AsyncCursorPage
from .._base_client import AsyncPaginator, make_request_options
from ..types.vault_list_response import VaultListResponse

__all__ = ["VaultsResource", "AsyncVaultsResource"]


class VaultsResource(SyncAPIResource):
    @cached_property
    def with_raw_response(self) -> VaultsResourceWithRawResponse:
        """
        This property can be used as a prefix for any HTTP method call to return
        the raw response object instead of the parsed content.

        For more information, see https://www.github.com/hyperspell/python-sdk#accessing-raw-response-data-eg-headers
        """
        return VaultsResourceWithRawResponse(self)

    @cached_property
    def with_streaming_response(self) -> VaultsResourceWithStreamingResponse:
        """
        An alternative to `.with_raw_response` that doesn't eagerly read the response body.

        For more information, see https://www.github.com/hyperspell/python-sdk#with_streaming_response
        """
        return VaultsResourceWithStreamingResponse(self)

    def list(
        self,
        *,
        cursor: Optional[str] | NotGiven = NOT_GIVEN,
        size: int | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> SyncCursorPage[VaultListResponse]:
        """
        This endpoint lists all collections, and how many documents are in each
        collection. All documents that do not have a collection assigned are in the
        `null` collection.

        Args:
          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        return self._get_api_list(
            "/vault/list",
            page=SyncCursorPage[VaultListResponse],
            options=make_request_options(
                extra_headers=extra_headers,
                extra_query=extra_query,
                extra_body=extra_body,
                timeout=timeout,
                query=maybe_transform(
                    {
                        "cursor": cursor,
                        "size": size,
                    },
                    vault_list_params.VaultListParams,
                ),
            ),
            model=VaultListResponse,
        )


class AsyncVaultsResource(AsyncAPIResource):
    @cached_property
    def with_raw_response(self) -> AsyncVaultsResourceWithRawResponse:
        """
        This property can be used as a prefix for any HTTP method call to return
        the raw response object instead of the parsed content.

        For more information, see https://www.github.com/hyperspell/python-sdk#accessing-raw-response-data-eg-headers
        """
        return AsyncVaultsResourceWithRawResponse(self)

    @cached_property
    def with_streaming_response(self) -> AsyncVaultsResourceWithStreamingResponse:
        """
        An alternative to `.with_raw_response` that doesn't eagerly read the response body.

        For more information, see https://www.github.com/hyperspell/python-sdk#with_streaming_response
        """
        return AsyncVaultsResourceWithStreamingResponse(self)

    def list(
        self,
        *,
        cursor: Optional[str] | NotGiven = NOT_GIVEN,
        size: int | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> AsyncPaginator[VaultListResponse, AsyncCursorPage[VaultListResponse]]:
        """
        This endpoint lists all collections, and how many documents are in each
        collection. All documents that do not have a collection assigned are in the
        `null` collection.

        Args:
          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        return self._get_api_list(
            "/vault/list",
            page=AsyncCursorPage[VaultListResponse],
            options=make_request_options(
                extra_headers=extra_headers,
                extra_query=extra_query,
                extra_body=extra_body,
                timeout=timeout,
                query=maybe_transform(
                    {
                        "cursor": cursor,
                        "size": size,
                    },
                    vault_list_params.VaultListParams,
                ),
            ),
            model=VaultListResponse,
        )


class VaultsResourceWithRawResponse:
    def __init__(self, vaults: VaultsResource) -> None:
        self._vaults = vaults

        self.list = to_raw_response_wrapper(
            vaults.list,
        )


class AsyncVaultsResourceWithRawResponse:
    def __init__(self, vaults: AsyncVaultsResource) -> None:
        self._vaults = vaults

        self.list = async_to_raw_response_wrapper(
            vaults.list,
        )


class VaultsResourceWithStreamingResponse:
    def __init__(self, vaults: VaultsResource) -> None:
        self._vaults = vaults

        self.list = to_streamed_response_wrapper(
            vaults.list,
        )


class AsyncVaultsResourceWithStreamingResponse:
    def __init__(self, vaults: AsyncVaultsResource) -> None:
        self._vaults = vaults

        self.list = async_to_streamed_response_wrapper(
            vaults.list,
        )
