from . import auth_store as auth_store, jwt_wrapper as jwt_wrapper, models as models
from .const import ACCESS_TOKEN_EXPIRATION as ACCESS_TOKEN_EXPIRATION, GROUP_ID_ADMIN as GROUP_ID_ADMIN, REFRESH_TOKEN_EXPIRATION as REFRESH_TOKEN_EXPIRATION
from .mfa_modules import MultiFactorAuthModule as MultiFactorAuthModule, auth_mfa_module_from_config as auth_mfa_module_from_config
from .models import AuthFlowContext as AuthFlowContext, AuthFlowResult as AuthFlowResult
from .providers import AuthProvider as AuthProvider, LoginFlow as LoginFlow, auth_provider_from_config as auth_provider_from_config
from .providers.homeassistant import HassAuthProvider as HassAuthProvider
from _typeshed import Incomplete
from datetime import datetime, timedelta
from homeassistant.core import CALLBACK_TYPE as CALLBACK_TYPE, HassJob as HassJob, HassJobType as HassJobType, HomeAssistant as HomeAssistant, callback as callback
from homeassistant.data_entry_flow import FlowHandler as FlowHandler, FlowManager as FlowManager, FlowResultType as FlowResultType
from homeassistant.helpers.event import async_track_point_in_utc_time as async_track_point_in_utc_time
from typing import Any

EVENT_USER_ADDED: str
EVENT_USER_UPDATED: str
EVENT_USER_REMOVED: str
type _MfaModuleDict = dict[str, MultiFactorAuthModule]
type _ProviderKey = tuple[str, str | None]
type _ProviderDict = dict[_ProviderKey, AuthProvider]

class InvalidAuthError(Exception): ...
class InvalidProvider(Exception): ...

async def auth_manager_from_config(hass: HomeAssistant, provider_configs: list[dict[str, Any]], module_configs: list[dict[str, Any]]) -> AuthManager: ...

class AuthManagerFlowManager(FlowManager[AuthFlowContext, AuthFlowResult, tuple[str, str]]):
    _flow_result = AuthFlowResult
    auth_manager: Incomplete
    def __init__(self, hass: HomeAssistant, auth_manager: AuthManager) -> None: ...
    async def async_create_flow(self, handler_key: tuple[str, str], *, context: AuthFlowContext | None = None, data: dict[str, Any] | None = None) -> LoginFlow[Any]: ...
    async def async_finish_flow(self, flow: FlowHandler[AuthFlowContext, AuthFlowResult, tuple[str, str]], result: AuthFlowResult) -> AuthFlowResult: ...

class AuthManager:
    hass: Incomplete
    _store: Incomplete
    _providers: Incomplete
    _mfa_modules: Incomplete
    login_flow: Incomplete
    _revoke_callbacks: dict[str, set[CALLBACK_TYPE]]
    _expire_callback: CALLBACK_TYPE | None
    _remove_expired_job: Incomplete
    def __init__(self, hass: HomeAssistant, store: auth_store.AuthStore, providers: _ProviderDict, mfa_modules: _MfaModuleDict) -> None: ...
    async def async_setup(self) -> None: ...
    @property
    def auth_providers(self) -> list[AuthProvider]: ...
    @property
    def auth_mfa_modules(self) -> list[MultiFactorAuthModule]: ...
    def get_auth_provider(self, provider_type: str, provider_id: str | None) -> AuthProvider | None: ...
    def get_auth_providers(self, provider_type: str) -> list[AuthProvider]: ...
    def get_auth_mfa_module(self, module_id: str) -> MultiFactorAuthModule | None: ...
    async def async_get_users(self) -> list[models.User]: ...
    async def async_get_user(self, user_id: str) -> models.User | None: ...
    async def async_get_owner(self) -> models.User | None: ...
    async def async_get_group(self, group_id: str) -> models.Group | None: ...
    async def async_get_user_by_credentials(self, credentials: models.Credentials) -> models.User | None: ...
    async def async_create_system_user(self, name: str, *, group_ids: list[str] | None = None, local_only: bool | None = None) -> models.User: ...
    async def async_create_user(self, name: str, *, group_ids: list[str] | None = None, local_only: bool | None = None) -> models.User: ...
    async def async_get_or_create_user(self, credentials: models.Credentials) -> models.User: ...
    async def async_link_user(self, user: models.User, credentials: models.Credentials) -> None: ...
    async def async_remove_user(self, user: models.User) -> None: ...
    async def async_update_user(self, user: models.User, name: str | None = None, is_active: bool | None = None, group_ids: list[str] | None = None, local_only: bool | None = None) -> None: ...
    @callback
    def async_update_user_credentials_data(self, credentials: models.Credentials, data: dict[str, Any]) -> None: ...
    async def async_activate_user(self, user: models.User) -> None: ...
    async def async_deactivate_user(self, user: models.User) -> None: ...
    async def async_remove_credentials(self, credentials: models.Credentials) -> None: ...
    async def async_enable_user_mfa(self, user: models.User, mfa_module_id: str, data: Any) -> None: ...
    async def async_disable_user_mfa(self, user: models.User, mfa_module_id: str) -> None: ...
    async def async_get_enabled_mfa(self, user: models.User) -> dict[str, str]: ...
    async def async_create_refresh_token(self, user: models.User, client_id: str | None = None, client_name: str | None = None, client_icon: str | None = None, token_type: str | None = None, access_token_expiration: timedelta = ..., credential: models.Credentials | None = None) -> models.RefreshToken: ...
    @callback
    def async_get_refresh_token(self, token_id: str) -> models.RefreshToken | None: ...
    @callback
    def async_get_refresh_token_by_token(self, token: str) -> models.RefreshToken | None: ...
    @callback
    def async_remove_refresh_token(self, refresh_token: models.RefreshToken) -> None: ...
    @callback
    def async_set_expiry(self, refresh_token: models.RefreshToken, *, enable_expiry: bool) -> None: ...
    @callback
    def _async_remove_expired_refresh_tokens(self, _: datetime | None = None) -> None: ...
    @callback
    def _async_track_next_refresh_token_expiration(self) -> None: ...
    @callback
    def _async_cancel_expiration_schedule(self) -> None: ...
    @callback
    def _async_unregister(self, callbacks: set[CALLBACK_TYPE], callback_: CALLBACK_TYPE) -> None: ...
    @callback
    def async_register_revoke_token_callback(self, refresh_token_id: str, revoke_callback: CALLBACK_TYPE) -> CALLBACK_TYPE: ...
    @callback
    def async_create_access_token(self, refresh_token: models.RefreshToken, remote_ip: str | None = None) -> str: ...
    @callback
    def _async_resolve_provider(self, refresh_token: models.RefreshToken) -> AuthProvider | None: ...
    @callback
    def async_validate_refresh_token(self, refresh_token: models.RefreshToken, remote_ip: str | None = None) -> None: ...
    @callback
    def async_validate_access_token(self, token: str) -> models.RefreshToken | None: ...
    @callback
    def _async_get_auth_provider(self, credentials: models.Credentials) -> AuthProvider | None: ...
    async def _user_should_be_owner(self) -> bool: ...
