import voluptuous as vol
from . import async_get_geography_id as async_get_geography_id
from .const import CONF_CITY as CONF_CITY, CONF_INTEGRATION_TYPE as CONF_INTEGRATION_TYPE, DOMAIN as DOMAIN, INTEGRATION_TYPE_GEOGRAPHY_COORDS as INTEGRATION_TYPE_GEOGRAPHY_COORDS, INTEGRATION_TYPE_GEOGRAPHY_NAME as INTEGRATION_TYPE_GEOGRAPHY_NAME, LOGGER as LOGGER
from _typeshed import Incomplete
from collections.abc import Mapping
from homeassistant.config_entries import ConfigEntry as ConfigEntry, ConfigFlow as ConfigFlow, ConfigFlowResult as ConfigFlowResult, SOURCE_REAUTH as SOURCE_REAUTH
from homeassistant.const import CONF_API_KEY as CONF_API_KEY, CONF_COUNTRY as CONF_COUNTRY, CONF_LATITUDE as CONF_LATITUDE, CONF_LONGITUDE as CONF_LONGITUDE, CONF_SHOW_ON_MAP as CONF_SHOW_ON_MAP, CONF_STATE as CONF_STATE
from homeassistant.core import callback as callback
from homeassistant.helpers import aiohttp_client as aiohttp_client
from homeassistant.helpers.schema_config_entry_flow import SchemaFlowFormStep as SchemaFlowFormStep, SchemaOptionsFlowHandler as SchemaOptionsFlowHandler
from typing import Any

API_KEY_DATA_SCHEMA: Incomplete
GEOGRAPHY_NAME_SCHEMA: Incomplete
PICK_INTEGRATION_TYPE_SCHEMA: Incomplete
OPTIONS_SCHEMA: Incomplete
OPTIONS_FLOW: Incomplete

class AirVisualFlowHandler(ConfigFlow, domain=DOMAIN):
    VERSION: int
    _entry_data_for_reauth: Mapping[str, Any]
    _geo_id: str | None
    def __init__(self) -> None: ...
    @property
    def geography_coords_schema(self) -> vol.Schema: ...
    async def _async_finish_geography(self, user_input: dict[str, str], integration_type: str) -> ConfigFlowResult: ...
    async def _async_init_geography(self, user_input: dict[str, str], integration_type: str) -> ConfigFlowResult: ...
    async def _async_set_unique_id(self, unique_id: str) -> None: ...
    @staticmethod
    @callback
    def async_get_options_flow(config_entry: ConfigEntry) -> SchemaOptionsFlowHandler: ...
    async def async_step_import(self, import_data: dict[str, str]) -> ConfigFlowResult: ...
    async def async_step_geography_by_coords(self, user_input: dict[str, str] | None = None) -> ConfigFlowResult: ...
    async def async_step_geography_by_name(self, user_input: dict[str, str] | None = None) -> ConfigFlowResult: ...
    async def async_step_reauth(self, entry_data: Mapping[str, Any]) -> ConfigFlowResult: ...
    async def async_step_reauth_confirm(self, user_input: dict[str, str] | None = None) -> ConfigFlowResult: ...
    async def async_step_user(self, user_input: dict[str, str] | None = None) -> ConfigFlowResult: ...
