import abc
from .const import DOMAIN as DOMAIN
from .entities import TRANSLATION_TABLE as TRANSLATION_TABLE
from .state_report import async_enable_proactive_mode as async_enable_proactive_mode
from _typeshed import Incomplete
from abc import ABC, abstractmethod
from homeassistant.core import CALLBACK_TYPE as CALLBACK_TYPE, HomeAssistant as HomeAssistant, callback as callback
from homeassistant.helpers.storage import Store as Store
from typing import Any
from yarl import URL as URL

STORE_AUTHORIZED: str
_LOGGER: Incomplete

class AbstractConfig(ABC, metaclass=abc.ABCMeta):
    _store: AlexaConfigStore
    _unsub_proactive_report: CALLBACK_TYPE | None
    hass: Incomplete
    _enable_proactive_mode_lock: Incomplete
    _on_deinitialize: list[CALLBACK_TYPE]
    def __init__(self, hass: HomeAssistant) -> None: ...
    async def async_initialize(self) -> None: ...
    @callback
    def async_deinitialize(self) -> None: ...
    @property
    def supports_auth(self) -> bool: ...
    @property
    def should_report_state(self) -> bool: ...
    @property
    @abstractmethod
    def endpoint(self) -> str | URL | None: ...
    @property
    @abstractmethod
    def locale(self) -> str | None: ...
    @property
    def entity_config(self) -> dict[str, Any]: ...
    @property
    def is_reporting_states(self) -> bool: ...
    @callback
    @abstractmethod
    def user_identifier(self) -> str: ...
    async def async_enable_proactive_mode(self) -> None: ...
    async def async_disable_proactive_mode(self) -> None: ...
    @callback
    def should_expose(self, entity_id: str) -> bool: ...
    def generate_alexa_id(self, entity_id: str) -> str: ...
    @callback
    def async_invalidate_access_token(self) -> None: ...
    async def async_get_access_token(self) -> str | None: ...
    async def async_accept_grant(self, code: str) -> str | None: ...
    @property
    def authorized(self) -> bool: ...
    async def set_authorized(self, authorized: bool) -> None: ...

class AlexaConfigStore:
    _STORAGE_VERSION: int
    _STORAGE_KEY = DOMAIN
    _data: dict[str, Any] | None
    _hass: Incomplete
    _store: Store
    def __init__(self, hass: HomeAssistant) -> None: ...
    @property
    def authorized(self) -> bool: ...
    @callback
    def set_authorized(self, authorized: bool) -> None: ...
    async def async_load(self) -> None: ...
