import asyncio
from .const import CONF_CREDENTIALS as CONF_CREDENTIALS, CONF_IDENTIFIERS as CONF_IDENTIFIERS, CONF_START_OFF as CONF_START_OFF, DOMAIN as DOMAIN
from _typeshed import Incomplete
from collections import deque
from collections.abc import Awaitable, Callable as Callable, Mapping
from homeassistant.components import zeroconf as zeroconf
from homeassistant.config_entries import ConfigEntry as ConfigEntry, ConfigFlow as ConfigFlow, ConfigFlowResult as ConfigFlowResult, SOURCE_IGNORE as SOURCE_IGNORE, SOURCE_ZEROCONF as SOURCE_ZEROCONF
from homeassistant.const import CONF_ADDRESS as CONF_ADDRESS, CONF_NAME as CONF_NAME, CONF_PIN as CONF_PIN
from homeassistant.core import HomeAssistant as HomeAssistant, callback as callback
from homeassistant.data_entry_flow import AbortFlow as AbortFlow
from homeassistant.exceptions import HomeAssistantError as HomeAssistantError
from homeassistant.helpers.aiohttp_client import async_get_clientsession as async_get_clientsession
from homeassistant.helpers.schema_config_entry_flow import SchemaFlowFormStep as SchemaFlowFormStep, SchemaOptionsFlowHandler as SchemaOptionsFlowHandler
from homeassistant.helpers.service_info.zeroconf import ZeroconfServiceInfo as ZeroconfServiceInfo
from pyatv.const import Protocol
from pyatv.interface import BaseConfig as BaseConfig, PairingHandler as PairingHandler
from typing import Any, Self

_LOGGER: Incomplete
DEVICE_INPUT: str
INPUT_PIN_SCHEMA: Incomplete
DEFAULT_START_OFF: bool
DISCOVERY_AGGREGATION_TIME: int
OPTIONS_SCHEMA: Incomplete
OPTIONS_FLOW: Incomplete

async def device_scan(hass: HomeAssistant, identifier: str | None, loop: asyncio.AbstractEventLoop) -> tuple[BaseConfig | None, list[str] | None]: ...

class AppleTVConfigFlow(ConfigFlow, domain=DOMAIN):
    VERSION: int
    scan_filter: str | None
    atv: BaseConfig | None
    atv_identifiers: list[str] | None
    _host: str
    host: str | None
    protocol: Protocol | None
    pairing: PairingHandler | None
    protocols_to_pair: deque[Protocol] | None
    @staticmethod
    @callback
    def async_get_options_flow(config_entry: ConfigEntry) -> SchemaOptionsFlowHandler: ...
    credentials: dict[int, str | None]
    all_identifiers: set[str]
    def __init__(self) -> None: ...
    @property
    def device_identifier(self) -> str | None: ...
    @callback
    def _entry_unique_id_from_identifers(self, all_identifiers: set[str]) -> str | None: ...
    async def async_step_reauth(self, entry_data: Mapping[str, Any]) -> ConfigFlowResult: ...
    async def async_step_restore_device(self, user_input: dict[str, str] | None = None) -> ConfigFlowResult: ...
    async def async_step_user(self, user_input: dict[str, str] | None = None) -> ConfigFlowResult: ...
    async def async_step_zeroconf(self, discovery_info: ZeroconfServiceInfo) -> ConfigFlowResult: ...
    async def _async_aggregate_discoveries(self, host: str, unique_id: str) -> None: ...
    @callback
    def _async_check_and_update_in_progress(self, host: str, unique_id: str) -> None: ...
    def is_matching(self, other_flow: Self) -> bool: ...
    async def async_found_zeroconf_device(self, user_input: dict[str, str] | None = None) -> ConfigFlowResult: ...
    async def async_find_device_wrapper(self, next_func: Callable[[], Awaitable[ConfigFlowResult]], allow_exist: bool = False) -> ConfigFlowResult: ...
    async def async_find_device(self, allow_exist: bool = False) -> None: ...
    async def async_step_confirm(self, user_input: dict[str, str] | None = None) -> ConfigFlowResult: ...
    async def async_pair_next_protocol(self) -> ConfigFlowResult: ...
    async def async_step_protocol_disabled(self, user_input: dict[str, str] | None = None) -> ConfigFlowResult: ...
    async def async_step_pair_with_pin(self, user_input: dict[str, str] | None = None) -> ConfigFlowResult: ...
    async def async_step_pair_no_pin(self, user_input: dict[str, str] | None = None) -> ConfigFlowResult: ...
    async def async_step_service_problem(self, user_input: dict[str, str] | None = None) -> ConfigFlowResult: ...
    async def async_step_password(self, user_input: dict[str, str] | None = None) -> ConfigFlowResult: ...
    async def _async_cleanup(self) -> None: ...
    async def _async_get_entry(self) -> ConfigFlowResult: ...

class DeviceNotFound(HomeAssistantError): ...
class DeviceAlreadyConfigured(HomeAssistantError): ...
