from . import AppleTVManager as AppleTVManager, AppleTvConfigEntry as AppleTvConfigEntry
from .browse_media import build_app_list as build_app_list
from .entity import AppleTVEntity as AppleTVEntity
from _typeshed import Incomplete
from datetime import datetime
from homeassistant.components import media_source as media_source
from homeassistant.components.media_player import BrowseMedia as BrowseMedia, MediaPlayerEntity as MediaPlayerEntity, MediaPlayerEntityFeature as MediaPlayerEntityFeature, MediaPlayerState as MediaPlayerState, MediaType as MediaType, RepeatMode as RepeatMode, async_process_play_media_url as async_process_play_media_url
from homeassistant.const import CONF_NAME as CONF_NAME
from homeassistant.core import HomeAssistant as HomeAssistant, callback as callback
from homeassistant.helpers.entity_platform import AddEntitiesCallback as AddEntitiesCallback
from pyatv.const import FeatureName, PowerState
from pyatv.interface import AppleTV as AppleTV, AudioListener, OutputDevice as OutputDevice, Playing as Playing, PowerListener, PushListener, PushUpdater as PushUpdater
from typing import Any

_LOGGER: Incomplete
PARALLEL_UPDATES: int
SUPPORT_BASE: Incomplete
SUPPORT_APPLE_TV: Incomplete
SUPPORT_FEATURE_MAPPING: Incomplete

async def async_setup_entry(hass: HomeAssistant, config_entry: AppleTvConfigEntry, async_add_entities: AddEntitiesCallback) -> None: ...

class AppleTvMediaPlayer(AppleTVEntity, MediaPlayerEntity, PowerListener, AudioListener, PushListener):
    _attr_supported_features = SUPPORT_APPLE_TV
    _playing: Playing | None
    _app_list: dict[str, str]
    def __init__(self, name: str, identifier: str, manager: AppleTVManager) -> None: ...
    @callback
    def async_device_connected(self, atv: AppleTV) -> None: ...
    async def _update_app_list(self) -> None: ...
    @callback
    def async_device_disconnected(self) -> None: ...
    @property
    def state(self) -> MediaPlayerState | None: ...
    @callback
    def playstatus_update(self, updater: PushUpdater, playstatus: Playing) -> None: ...
    @callback
    def playstatus_error(self, updater: PushUpdater, exception: Exception) -> None: ...
    @callback
    def powerstate_update(self, old_state: PowerState, new_state: PowerState) -> None: ...
    @callback
    def volume_update(self, old_level: float, new_level: float) -> None: ...
    @callback
    def outputdevices_update(self, old_devices: list[OutputDevice], new_devices: list[OutputDevice]) -> None: ...
    @property
    def app_id(self) -> str | None: ...
    @property
    def app_name(self) -> str | None: ...
    @property
    def source_list(self) -> list[str]: ...
    @property
    def media_content_type(self) -> MediaType | None: ...
    @property
    def media_content_id(self) -> str | None: ...
    @property
    def volume_level(self) -> float | None: ...
    @property
    def media_duration(self) -> int | None: ...
    @property
    def media_position(self) -> int | None: ...
    @property
    def media_position_updated_at(self) -> datetime | None: ...
    async def async_play_media(self, media_type: MediaType | str, media_id: str, **kwargs: Any) -> None: ...
    @property
    def media_image_hash(self) -> str | None: ...
    async def async_get_media_image(self) -> tuple[bytes | None, str | None]: ...
    @property
    def media_title(self) -> str | None: ...
    @property
    def media_artist(self) -> str | None: ...
    @property
    def media_album_name(self) -> str | None: ...
    @property
    def media_series_title(self) -> str | None: ...
    @property
    def media_season(self) -> str | None: ...
    @property
    def media_episode(self) -> str | None: ...
    @property
    def repeat(self) -> RepeatMode | None: ...
    @property
    def shuffle(self) -> bool | None: ...
    def _is_feature_available(self, feature: FeatureName) -> bool: ...
    async def async_browse_media(self, media_content_type: MediaType | str | None = None, media_content_id: str | None = None) -> BrowseMedia: ...
    async def async_turn_on(self) -> None: ...
    async def async_turn_off(self) -> None: ...
    async def async_media_play_pause(self) -> None: ...
    async def async_media_play(self) -> None: ...
    async def async_media_stop(self) -> None: ...
    async def async_media_pause(self) -> None: ...
    async def async_media_next_track(self) -> None: ...
    async def async_media_previous_track(self) -> None: ...
    async def async_media_seek(self, position: float) -> None: ...
    async def async_volume_up(self) -> None: ...
    async def async_volume_down(self) -> None: ...
    async def async_set_volume_level(self, volume: float) -> None: ...
    async def async_set_repeat(self, repeat: RepeatMode) -> None: ...
    async def async_set_shuffle(self, shuffle: bool) -> None: ...
    async def async_select_source(self, source: str) -> None: ...
