from _typeshed import Incomplete
from homeassistant.exceptions import HomeAssistantError as HomeAssistantError

class PipelineError(HomeAssistantError):
    code: Incomplete
    message: Incomplete
    def __init__(self, code: str, message: str) -> None: ...

class PipelineNotFound(PipelineError): ...
class WakeWordDetectionError(PipelineError): ...

class WakeWordDetectionAborted(WakeWordDetectionError):
    def __init__(self) -> None: ...

class WakeWordTimeoutError(WakeWordDetectionError): ...
class SpeechToTextError(PipelineError): ...

class DuplicateWakeUpDetectedError(WakeWordDetectionError):
    def __init__(self, wake_up_phrase: str) -> None: ...

class IntentRecognitionError(PipelineError): ...
class TextToSpeechError(PipelineError): ...
