from . import BraviaTVConfigEntry as BraviaTVConfigEntry
from .const import SourceType as SourceType
from .entity import BraviaTVEntity as BraviaTVEntity
from _typeshed import Incomplete
from datetime import datetime
from homeassistant.components.media_player import BrowseError as BrowseError, BrowseMedia as BrowseMedia, MediaClass as MediaClass, MediaPlayerDeviceClass as MediaPlayerDeviceClass, MediaPlayerEntity as MediaPlayerEntity, MediaPlayerEntityFeature as MediaPlayerEntityFeature, MediaPlayerState as MediaPlayerState, MediaType as MediaType
from homeassistant.core import HomeAssistant as HomeAssistant
from homeassistant.helpers.entity_platform import AddEntitiesCallback as AddEntitiesCallback
from typing import Any

async def async_setup_entry(hass: HomeAssistant, config_entry: BraviaTVConfigEntry, async_add_entities: AddEntitiesCallback) -> None: ...

class BraviaTVMediaPlayer(BraviaTVEntity, MediaPlayerEntity):
    _attr_name: Incomplete
    _attr_assumed_state: bool
    _attr_device_class: Incomplete
    _attr_supported_features: Incomplete
    @property
    def state(self) -> MediaPlayerState: ...
    @property
    def source(self) -> str | None: ...
    @property
    def source_list(self) -> list[str]: ...
    @property
    def volume_level(self) -> float | None: ...
    @property
    def is_volume_muted(self) -> bool: ...
    @property
    def media_title(self) -> str | None: ...
    @property
    def media_channel(self) -> str | None: ...
    @property
    def media_content_id(self) -> str | None: ...
    @property
    def media_content_type(self) -> MediaType | None: ...
    @property
    def media_duration(self) -> int | None: ...
    @property
    def media_position(self) -> int | None: ...
    @property
    def media_position_updated_at(self) -> datetime | None: ...
    async def async_turn_on(self) -> None: ...
    async def async_turn_off(self) -> None: ...
    async def async_set_volume_level(self, volume: float) -> None: ...
    async def async_volume_up(self) -> None: ...
    async def async_volume_down(self) -> None: ...
    async def async_mute_volume(self, mute: bool) -> None: ...
    async def async_browse_media(self, media_content_type: MediaType | str | None = None, media_content_id: str | None = None) -> BrowseMedia: ...
    async def async_browse_media_root(self) -> BrowseMedia: ...
    async def async_browse_media_apps(self, expanded: bool = False) -> BrowseMedia: ...
    async def async_browse_media_channels(self, expanded: bool = False) -> BrowseMedia: ...
    async def async_get_browse_image(self, media_content_type: MediaType | str, media_content_id: str, media_image_id: str | None = None) -> tuple[bytes | None, str | None]: ...
    async def async_play_media(self, media_type: MediaType | str, media_id: str, **kwargs: Any) -> None: ...
    async def async_select_source(self, source: str) -> None: ...
    async def async_media_play(self) -> None: ...
    async def async_media_pause(self) -> None: ...
    async def async_media_play_pause(self) -> None: ...
    async def async_media_stop(self) -> None: ...
    async def async_media_next_track(self) -> None: ...
    async def async_media_previous_track(self) -> None: ...
