import dataclasses
import datetime
from .const import CONF_EVENT as CONF_EVENT, CalendarEntityFeature as CalendarEntityFeature, DATA_COMPONENT as DATA_COMPONENT, DOMAIN as DOMAIN, EVENT_DESCRIPTION as EVENT_DESCRIPTION, EVENT_DURATION as EVENT_DURATION, EVENT_END as EVENT_END, EVENT_END_DATE as EVENT_END_DATE, EVENT_END_DATETIME as EVENT_END_DATETIME, EVENT_IN as EVENT_IN, EVENT_IN_DAYS as EVENT_IN_DAYS, EVENT_IN_WEEKS as EVENT_IN_WEEKS, EVENT_LOCATION as EVENT_LOCATION, EVENT_RECURRENCE_ID as EVENT_RECURRENCE_ID, EVENT_RECURRENCE_RANGE as EVENT_RECURRENCE_RANGE, EVENT_RRULE as EVENT_RRULE, EVENT_START as EVENT_START, EVENT_START_DATE as EVENT_START_DATE, EVENT_START_DATETIME as EVENT_START_DATETIME, EVENT_SUMMARY as EVENT_SUMMARY, EVENT_TIME_FIELDS as EVENT_TIME_FIELDS, EVENT_TYPES as EVENT_TYPES, EVENT_UID as EVENT_UID, LIST_EVENT_FIELDS as LIST_EVENT_FIELDS
from _typeshed import Incomplete
from aiohttp import web
from collections.abc import Callable as Callable, Iterable
from homeassistant.components import frontend as frontend, http as http, websocket_api as websocket_api
from homeassistant.components.websocket_api import ActiveConnection as ActiveConnection, ERR_NOT_FOUND as ERR_NOT_FOUND, ERR_NOT_SUPPORTED as ERR_NOT_SUPPORTED
from homeassistant.config_entries import ConfigEntry as ConfigEntry
from homeassistant.const import STATE_OFF as STATE_OFF, STATE_ON as STATE_ON
from homeassistant.core import CALLBACK_TYPE as CALLBACK_TYPE, HomeAssistant as HomeAssistant, ServiceCall as ServiceCall, ServiceResponse as ServiceResponse, SupportsResponse as SupportsResponse, callback as callback
from homeassistant.exceptions import HomeAssistantError as HomeAssistantError
from homeassistant.helpers.entity import Entity as Entity, EntityDescription as EntityDescription
from homeassistant.helpers.entity_component import EntityComponent as EntityComponent
from homeassistant.helpers.event import async_track_point_in_time as async_track_point_in_time
from homeassistant.helpers.template import DATE_STR_FORMAT as DATE_STR_FORMAT
from homeassistant.helpers.typing import ConfigType as ConfigType
from homeassistant.util.json import JsonValueType as JsonValueType
from typing import Any, Final, final

_LOGGER: Incomplete
ENTITY_ID_FORMAT: Incomplete
PLATFORM_SCHEMA: Incomplete
PLATFORM_SCHEMA_BASE: Incomplete
SCAN_INTERVAL: Incomplete
VALID_FREQS: Incomplete
MIN_NEW_EVENT_DURATION: Incomplete
MIN_EVENT_DURATION: Incomplete

def _has_timezone(*keys: Any) -> Callable[[dict[str, Any]], dict[str, Any]]: ...
def _has_consistent_timezone(*keys: Any) -> Callable[[dict[str, Any]], dict[str, Any]]: ...
def _as_local_timezone(*keys: Any) -> Callable[[dict[str, Any]], dict[str, Any]]: ...
def _has_min_duration(start_key: str, end_key: str, min_duration: datetime.timedelta) -> Callable[[dict[str, Any]], dict[str, Any]]: ...
def _has_same_type(*keys: Any) -> Callable[[dict[str, Any]], dict[str, Any]]: ...
def _validate_rrule(value: Any) -> str: ...
def _empty_as_none(value: str | None) -> str | None: ...

CREATE_EVENT_SERVICE: str
CREATE_EVENT_SCHEMA: Incomplete
WEBSOCKET_EVENT_SCHEMA: Incomplete
CALENDAR_EVENT_SCHEMA: Incomplete
SERVICE_GET_EVENTS: Final[str]
SERVICE_GET_EVENTS_SCHEMA: Final[Incomplete]

async def async_setup(hass: HomeAssistant, config: ConfigType) -> bool: ...
async def async_setup_entry(hass: HomeAssistant, entry: ConfigEntry) -> bool: ...
async def async_unload_entry(hass: HomeAssistant, entry: ConfigEntry) -> bool: ...
def get_date(date: dict[str, Any]) -> datetime.datetime: ...

@dataclasses.dataclass
class CalendarEvent:
    start: datetime.date | datetime.datetime
    end: datetime.date | datetime.datetime
    summary: str
    description: str | None = ...
    location: str | None = ...
    uid: str | None = ...
    recurrence_id: str | None = ...
    rrule: str | None = ...
    @property
    def start_datetime_local(self) -> datetime.datetime: ...
    @property
    def end_datetime_local(self) -> datetime.datetime: ...
    @property
    def all_day(self) -> bool: ...
    def as_dict(self) -> dict[str, Any]: ...
    def __post_init__(self) -> None: ...

def _event_dict_factory(obj: Iterable[tuple[str, Any]]) -> dict[str, str]: ...
def _api_event_dict_factory(obj: Iterable[tuple[str, Any]]) -> dict[str, Any]: ...
def _list_events_dict_factory(obj: Iterable[tuple[str, Any]]) -> dict[str, JsonValueType]: ...
def _get_datetime_local(dt_or_d: datetime.datetime | datetime.date) -> datetime.datetime: ...
def _get_api_date(dt_or_d: datetime.datetime | datetime.date) -> dict[str, str]: ...
def extract_offset(summary: str, offset_prefix: str) -> tuple[str, datetime.timedelta]: ...
def is_offset_reached(start: datetime.datetime, offset_time: datetime.timedelta) -> bool: ...

class CalendarEntityDescription(EntityDescription, frozen_or_thawed=True): ...

class CalendarEntity(Entity):
    entity_description: CalendarEntityDescription
    _entity_component_unrecorded_attributes: Incomplete
    _alarm_unsubs: list[CALLBACK_TYPE] | None
    @property
    def event(self) -> CalendarEvent | None: ...
    @final
    @property
    def state_attributes(self) -> dict[str, Any] | None: ...
    @final
    @property
    def state(self) -> str: ...
    @callback
    def async_write_ha_state(self) -> None: ...
    async def async_will_remove_from_hass(self) -> None: ...
    async def async_get_events(self, hass: HomeAssistant, start_date: datetime.datetime, end_date: datetime.datetime) -> list[CalendarEvent]: ...
    async def async_create_event(self, **kwargs: Any) -> None: ...
    async def async_delete_event(self, uid: str, recurrence_id: str | None = None, recurrence_range: str | None = None) -> None: ...
    async def async_update_event(self, uid: str, event: dict[str, Any], recurrence_id: str | None = None, recurrence_range: str | None = None) -> None: ...

class CalendarEventView(http.HomeAssistantView):
    url: str
    name: str
    component: Incomplete
    def __init__(self, component: EntityComponent[CalendarEntity]) -> None: ...
    async def get(self, request: web.Request, entity_id: str) -> web.Response: ...

class CalendarListView(http.HomeAssistantView):
    url: str
    name: str
    component: Incomplete
    def __init__(self, component: EntityComponent[CalendarEntity]) -> None: ...
    async def get(self, request: web.Request) -> web.Response: ...

@websocket_api.async_response
async def handle_calendar_event_create(hass: HomeAssistant, connection: ActiveConnection, msg: dict[str, Any]) -> None: ...
@websocket_api.async_response
async def handle_calendar_event_delete(hass: HomeAssistant, connection: ActiveConnection, msg: dict[str, Any]) -> None: ...
@websocket_api.async_response
async def handle_calendar_event_update(hass: HomeAssistant, connection: ActiveConnection, msg: dict[str, Any]) -> None: ...
def _validate_timespan(values: dict[str, Any]) -> tuple[datetime.datetime | datetime.date, datetime.datetime | datetime.date]: ...
async def async_create_event(entity: CalendarEntity, call: ServiceCall) -> None: ...
async def async_get_events_service(calendar: CalendarEntity, service_call: ServiceCall) -> ServiceResponse: ...
