import aiohttp
import asyncio
from . import alexa_config as alexa_config, google_config as google_config
from .const import DISPATCHER_REMOTE_UPDATE as DISPATCHER_REMOTE_UPDATE, DOMAIN as DOMAIN, PREF_ENABLE_CLOUD_ICE_SERVERS as PREF_ENABLE_CLOUD_ICE_SERVERS
from .prefs import CloudPreferences as CloudPreferences
from _typeshed import Incomplete
from collections.abc import Callable as Callable
from hass_nabucasa.client import CloudClient as Interface
from homeassistant.components import google_assistant as google_assistant, persistent_notification as persistent_notification, webhook as webhook
from homeassistant.components.camera.webrtc import async_register_ice_servers as async_register_ice_servers
from homeassistant.core import Context as Context, HassJob as HassJob, HomeAssistant as HomeAssistant, callback as callback
from homeassistant.helpers.aiohttp_client import SERVER_SOFTWARE as SERVER_SOFTWARE
from homeassistant.helpers.dispatcher import async_dispatcher_send as async_dispatcher_send
from homeassistant.helpers.event import async_call_later as async_call_later
from homeassistant.helpers.issue_registry import IssueSeverity as IssueSeverity, async_create_issue as async_create_issue
from homeassistant.util.aiohttp import MockRequest as MockRequest, serialize_response as serialize_response
from pathlib import Path
from typing import Any, Literal
from webrtc_models import RTCIceServer as RTCIceServer

_LOGGER: Incomplete
VALID_REPAIR_TRANSLATION_KEYS: Incomplete

class CloudClient(Interface):
    _hass: Incomplete
    _prefs: Incomplete
    _websession: Incomplete
    google_user_config: Incomplete
    alexa_user_config: Incomplete
    _alexa_config: alexa_config.CloudAlexaConfig | None
    _google_config: google_config.CloudGoogleConfig | None
    _alexa_config_init_lock: Incomplete
    _google_config_init_lock: Incomplete
    _relayer_region: str | None
    _cloud_ice_servers_listener: Callable[[], None] | None
    def __init__(self, hass: HomeAssistant, prefs: CloudPreferences, websession: aiohttp.ClientSession, alexa_user_config: dict[str, Any], google_user_config: dict[str, Any]) -> None: ...
    @property
    def base_path(self) -> Path: ...
    @property
    def prefs(self) -> CloudPreferences: ...
    @property
    def loop(self) -> asyncio.AbstractEventLoop: ...
    @property
    def websession(self) -> aiohttp.ClientSession: ...
    @property
    def aiohttp_runner(self) -> aiohttp.web.AppRunner | None: ...
    @property
    def cloudhooks(self) -> dict[str, dict[str, str | bool]]: ...
    @property
    def remote_autostart(self) -> bool: ...
    @property
    def client_name(self) -> str: ...
    @property
    def relayer_region(self) -> str | None: ...
    async def get_alexa_config(self) -> alexa_config.CloudAlexaConfig: ...
    async def get_google_config(self) -> google_config.CloudGoogleConfig: ...
    async def cloud_connected(self) -> None: ...
    async def cloud_disconnected(self) -> None: ...
    async def cloud_started(self) -> None: ...
    async def cloud_stopped(self) -> None: ...
    async def logout_cleanups(self) -> None: ...
    @callback
    def user_message(self, identifier: str, title: str, message: str) -> None: ...
    @callback
    def dispatcher_message(self, identifier: str, data: Any = None) -> None: ...
    async def async_cloud_connect_update(self, connect: bool) -> None: ...
    async def async_cloud_connection_info(self, payload: dict[str, Any]) -> dict[str, Any]: ...
    async def async_alexa_message(self, payload: dict[Any, Any]) -> dict[Any, Any]: ...
    async def async_google_message(self, payload: dict[Any, Any]) -> dict[Any, Any]: ...
    async def async_webhook_message(self, payload: dict[Any, Any]) -> dict[Any, Any]: ...
    async def async_system_message(self, payload: dict[Any, Any] | None) -> None: ...
    async def async_cloudhooks_update(self, data: dict[str, dict[str, str | bool]]) -> None: ...
    async def async_create_repair_issue(self, identifier: str, translation_key: str, *, placeholders: dict[str, str] | None = None, severity: Literal['error', 'warning'] = 'warning') -> None: ...
