from _typeshed import Incomplete
from datetime import datetime
from homeassistant.components.media_player import MediaPlayerDeviceClass as MediaPlayerDeviceClass, MediaPlayerEntity as MediaPlayerEntity, MediaPlayerEntityFeature as MediaPlayerEntityFeature, MediaPlayerState as MediaPlayerState, MediaType as MediaType, RepeatMode as RepeatMode
from homeassistant.config_entries import ConfigEntry as ConfigEntry
from homeassistant.core import HomeAssistant as HomeAssistant
from homeassistant.helpers.entity_platform import AddEntitiesCallback as AddEntitiesCallback
from typing import Any

async def async_setup_entry(hass: HomeAssistant, config_entry: ConfigEntry, async_add_entities: AddEntitiesCallback) -> None: ...

SOUND_MODE_LIST: Incomplete
DEFAULT_SOUND_MODE: str
YOUTUBE_PLAYER_SUPPORT: Incomplete
MUSIC_PLAYER_SUPPORT: Incomplete
NETFLIX_PLAYER_SUPPORT: Incomplete
BROWSE_PLAYER_SUPPORT: Incomplete

class AbstractDemoPlayer(MediaPlayerEntity):
    _attr_should_poll: bool
    _attr_sound_mode_list = SOUND_MODE_LIST
    _attr_name: Incomplete
    _attr_state: Incomplete
    _attr_volume_level: float
    _attr_is_volume_muted: bool
    _attr_shuffle: bool
    _attr_sound_mode: Incomplete
    _attr_device_class: Incomplete
    def __init__(self, name: str, device_class: MediaPlayerDeviceClass | None = None) -> None: ...
    def turn_on(self) -> None: ...
    def turn_off(self) -> None: ...
    def mute_volume(self, mute: bool) -> None: ...
    def volume_up(self) -> None: ...
    def volume_down(self) -> None: ...
    def set_volume_level(self, volume: float) -> None: ...
    def media_play(self) -> None: ...
    def media_pause(self) -> None: ...
    def media_stop(self) -> None: ...
    def set_shuffle(self, shuffle: bool) -> None: ...
    def select_sound_mode(self, sound_mode: str) -> None: ...

class DemoYoutubePlayer(AbstractDemoPlayer):
    _attr_app_name: str
    _attr_media_content_type: Incomplete
    _attr_supported_features = YOUTUBE_PLAYER_SUPPORT
    _attr_media_content_id: Incomplete
    _attr_media_title: Incomplete
    _attr_media_duration: Incomplete
    _progress: int | None
    _progress_updated_at: Incomplete
    def __init__(self, name: str, youtube_id: str, media_title: str, duration: int) -> None: ...
    @property
    def media_image_url(self) -> str: ...
    @property
    def media_position(self) -> int | None: ...
    @property
    def media_position_updated_at(self) -> datetime | None: ...
    def play_media(self, media_type: MediaType | str, media_id: str, **kwargs: Any) -> None: ...
    def media_pause(self) -> None: ...

class DemoMusicPlayer(AbstractDemoPlayer):
    _attr_media_album_name: str
    _attr_media_content_id: str
    _attr_media_content_type: Incomplete
    _attr_media_duration: int
    _attr_media_image_url: str
    _attr_supported_features = MUSIC_PLAYER_SUPPORT
    tracks: Incomplete
    _cur_track: int
    _attr_group_members: list[str]
    _attr_repeat: Incomplete
    def __init__(self, name: str = 'Walkman') -> None: ...
    @property
    def media_title(self) -> str: ...
    @property
    def media_artist(self) -> str: ...
    @property
    def media_track(self) -> int: ...
    def media_previous_track(self) -> None: ...
    def media_next_track(self) -> None: ...
    _attr_state: Incomplete
    def clear_playlist(self) -> None: ...
    def set_repeat(self, repeat: RepeatMode) -> None: ...
    def join_players(self, group_members: list[str]) -> None: ...
    def unjoin_player(self) -> None: ...

class DemoTVShowPlayer(AbstractDemoPlayer):
    _attr_app_name: str
    _attr_media_content_id: str
    _attr_media_content_type: Incomplete
    _attr_media_duration: int
    _attr_media_image_url: str
    _attr_media_season: str
    _attr_media_series_title: str
    _attr_source_list: Incomplete
    _attr_supported_features = NETFLIX_PLAYER_SUPPORT
    _cur_episode: int
    _episode_count: int
    _attr_source: str
    def __init__(self) -> None: ...
    @property
    def media_title(self) -> str: ...
    @property
    def media_episode(self) -> str: ...
    def media_previous_track(self) -> None: ...
    def media_next_track(self) -> None: ...
    def select_source(self, source: str) -> None: ...

class DemoBrowsePlayer(AbstractDemoPlayer):
    _attr_supported_features = BROWSE_PLAYER_SUPPORT

class DemoGroupPlayer(AbstractDemoPlayer):
    _attr_supported_features: Incomplete
