import voluptuous as vol
from . import DeviceAutomationType as DeviceAutomationType, async_get_device_automation_platform as async_get_device_automation_platform
from .helpers import async_validate_device_automation_config as async_validate_device_automation_config
from homeassistant.const import CONF_DOMAIN as CONF_DOMAIN
from homeassistant.core import Context as Context, HomeAssistant as HomeAssistant
from homeassistant.helpers.typing import ConfigType as ConfigType
from typing import Any, Protocol

class DeviceAutomationActionProtocol(Protocol):
    ACTION_SCHEMA: vol.Schema
    async def async_validate_action_config(self, hass: HomeAssistant, config: ConfigType) -> ConfigType: ...
    async def async_call_action_from_config(self, hass: HomeAssistant, config: ConfigType, variables: dict[str, Any], context: Context | None) -> None: ...
    async def async_get_action_capabilities(self, hass: HomeAssistant, config: ConfigType) -> dict[str, vol.Schema]: ...
    async def async_get_actions(self, hass: HomeAssistant, device_id: str) -> list[dict[str, Any]]: ...

async def async_validate_action_config(hass: HomeAssistant, config: ConfigType) -> ConfigType: ...
async def async_call_action_from_config(hass: HomeAssistant, config: ConfigType, variables: dict[str, Any], context: Context | None) -> None: ...
