import asyncio
from .const import CONF_BROWSE_UNFILTERED as CONF_BROWSE_UNFILTERED, CONF_CALLBACK_URL_OVERRIDE as CONF_CALLBACK_URL_OVERRIDE, CONF_LISTEN_PORT as CONF_LISTEN_PORT, CONF_POLL_AVAILABILITY as CONF_POLL_AVAILABILITY, DOMAIN as DOMAIN, MEDIA_METADATA_DIDL as MEDIA_METADATA_DIDL, MEDIA_TYPE_MAP as MEDIA_TYPE_MAP, MEDIA_UPNP_CLASS_MAP as MEDIA_UPNP_CLASS_MAP, REPEAT_PLAY_MODES as REPEAT_PLAY_MODES, SHUFFLE_PLAY_MODES as SHUFFLE_PLAY_MODES, STREAMABLE_PROTOCOLS as STREAMABLE_PROTOCOLS
from .data import EventListenAddr as EventListenAddr, get_domain_data as get_domain_data
from _typeshed import Incomplete
from async_upnp_client.client import UpnpService as UpnpService, UpnpStateVariable as UpnpStateVariable
from async_upnp_client.profiles.dlna import DmrDevice
from collections.abc import Awaitable, Callable as Callable, Coroutine, Sequence
from datetime import datetime
from homeassistant import config_entries as config_entries
from homeassistant.components import media_source as media_source, ssdp as ssdp
from homeassistant.components.media_player import ATTR_MEDIA_EXTRA as ATTR_MEDIA_EXTRA, BrowseMedia as BrowseMedia, MediaPlayerEntity as MediaPlayerEntity, MediaPlayerEntityFeature as MediaPlayerEntityFeature, MediaPlayerState as MediaPlayerState, MediaType as MediaType, RepeatMode as RepeatMode, async_process_play_media_url as async_process_play_media_url
from homeassistant.const import CONF_DEVICE_ID as CONF_DEVICE_ID, CONF_MAC as CONF_MAC, CONF_TYPE as CONF_TYPE, CONF_URL as CONF_URL
from homeassistant.core import CoreState as CoreState, HomeAssistant as HomeAssistant
from homeassistant.helpers.entity_platform import AddEntitiesCallback as AddEntitiesCallback
from homeassistant.helpers.service_info.ssdp import SsdpServiceInfo as SsdpServiceInfo
from typing import Any, Concatenate

PARALLEL_UPDATES: int
_TRANSPORT_STATE_TO_MEDIA_PLAYER_STATE: Incomplete

def catch_request_errors[_DlnaDmrEntityT: DlnaDmrEntity, **_P, _R](func: Callable[Concatenate[_DlnaDmrEntityT, _P], Awaitable[_R]]) -> Callable[Concatenate[_DlnaDmrEntityT, _P], Coroutine[Any, Any, _R | None]]: ...
async def async_setup_entry(hass: HomeAssistant, entry: config_entries.ConfigEntry, async_add_entities: AddEntitiesCallback) -> None: ...

class DlnaDmrEntity(MediaPlayerEntity):
    udn: str
    device_type: str
    _event_addr: EventListenAddr
    poll_availability: bool
    location: str
    browse_unfiltered: bool
    _device_lock: asyncio.Lock
    _device: DmrDevice | None
    check_available: bool
    _ssdp_connect_failed: bool
    _bootid: int | None
    _attr_should_poll: bool
    _attr_sound_mode: Incomplete
    _attr_name: Incomplete
    mac_address: Incomplete
    _background_setup_task: asyncio.Task[None] | None
    _updated_registry: bool
    _config_entry: Incomplete
    _attr_device_info: Incomplete
    _attr_supported_features: Incomplete
    def __init__(self, udn: str, device_type: str, name: str, event_port: int, event_callback_url: str | None, poll_availability: bool, location: str, mac_address: str | None, browse_unfiltered: bool, config_entry: config_entries.ConfigEntry) -> None: ...
    async def async_added_to_hass(self) -> None: ...
    async def _async_setup(self) -> None: ...
    async def async_will_remove_from_hass(self) -> None: ...
    async def async_ssdp_callback(self, info: SsdpServiceInfo, change: ssdp.SsdpChange) -> None: ...
    async def async_config_update_listener(self, hass: HomeAssistant, entry: config_entries.ConfigEntry) -> None: ...
    def async_write_ha_state(self) -> None: ...
    async def _device_connect(self, location: str) -> None: ...
    def _update_device_registry(self, set_mac: bool = False) -> None: ...
    async def _device_disconnect(self) -> None: ...
    async def async_update(self) -> None: ...
    def _on_event(self, service: UpnpService, state_variables: Sequence[UpnpStateVariable]) -> None: ...
    @property
    def available(self) -> bool: ...
    @property
    def unique_id(self) -> str: ...
    @property
    def usn(self) -> str: ...
    @property
    def state(self) -> MediaPlayerState | None: ...
    def _supported_features(self) -> MediaPlayerEntityFeature: ...
    @property
    def volume_level(self) -> float | None: ...
    @catch_request_errors
    async def async_set_volume_level(self, volume: float) -> None: ...
    @property
    def is_volume_muted(self) -> bool | None: ...
    @catch_request_errors
    async def async_mute_volume(self, mute: bool) -> None: ...
    @catch_request_errors
    async def async_media_pause(self) -> None: ...
    @catch_request_errors
    async def async_media_play(self) -> None: ...
    @catch_request_errors
    async def async_media_stop(self) -> None: ...
    @catch_request_errors
    async def async_media_seek(self, position: float) -> None: ...
    @catch_request_errors
    async def async_play_media(self, media_type: MediaType | str, media_id: str, **kwargs: Any) -> None: ...
    @catch_request_errors
    async def async_media_previous_track(self) -> None: ...
    @catch_request_errors
    async def async_media_next_track(self) -> None: ...
    @property
    def shuffle(self) -> bool | None: ...
    @catch_request_errors
    async def async_set_shuffle(self, shuffle: bool) -> None: ...
    @property
    def repeat(self) -> RepeatMode | None: ...
    @catch_request_errors
    async def async_set_repeat(self, repeat: RepeatMode) -> None: ...
    @property
    def sound_mode_list(self) -> list[str] | None: ...
    @catch_request_errors
    async def async_select_sound_mode(self, sound_mode: str) -> None: ...
    async def async_browse_media(self, media_content_type: MediaType | str | None = None, media_content_id: str | None = None) -> BrowseMedia: ...
    def _get_content_filter(self) -> Callable[[BrowseMedia], bool]: ...
    @property
    def media_title(self) -> str | None: ...
    @property
    def media_image_url(self) -> str | None: ...
    @property
    def media_content_id(self) -> str | None: ...
    @property
    def media_content_type(self) -> MediaType | None: ...
    @property
    def media_duration(self) -> int | None: ...
    @property
    def media_position(self) -> int | None: ...
    @property
    def media_position_updated_at(self) -> datetime | None: ...
    @property
    def media_artist(self) -> str | None: ...
    @property
    def media_album_name(self) -> str | None: ...
    @property
    def media_album_artist(self) -> str | None: ...
    @property
    def media_track(self) -> int | None: ...
    @property
    def media_series_title(self) -> str | None: ...
    @property
    def media_season(self) -> str | None: ...
    @property
    def media_episode(self) -> str | None: ...
    @property
    def media_channel(self) -> str | None: ...
    @property
    def media_playlist(self) -> str | None: ...
