from . import async_wait_for_elk_to_sync as async_wait_for_elk_to_sync, hostname_from_url as hostname_from_url
from .const import CONF_AUTO_CONFIGURE as CONF_AUTO_CONFIGURE, DISCOVER_SCAN_TIMEOUT as DISCOVER_SCAN_TIMEOUT, DOMAIN as DOMAIN, LOGIN_TIMEOUT as LOGIN_TIMEOUT
from .discovery import _short_mac as _short_mac, async_discover_device as async_discover_device, async_discover_devices as async_discover_devices, async_update_entry_from_discovery as async_update_entry_from_discovery
from _typeshed import Incomplete
from elkm1_lib.discovery import ElkSystem
from homeassistant.config_entries import ConfigFlow as ConfigFlow, ConfigFlowResult as ConfigFlowResult
from homeassistant.const import CONF_ADDRESS as CONF_ADDRESS, CONF_HOST as CONF_HOST, CONF_PASSWORD as CONF_PASSWORD, CONF_PREFIX as CONF_PREFIX, CONF_PROTOCOL as CONF_PROTOCOL, CONF_USERNAME as CONF_USERNAME
from homeassistant.exceptions import HomeAssistantError as HomeAssistantError
from homeassistant.helpers.service_info.dhcp import DhcpServiceInfo as DhcpServiceInfo
from homeassistant.helpers.typing import DiscoveryInfoType as DiscoveryInfoType, VolDictType as VolDictType
from homeassistant.util import slugify as slugify
from homeassistant.util.network import is_ip_address as is_ip_address
from typing import Any, Self

CONF_DEVICE: str
NON_SECURE_PORT: int
SECURE_PORT: int
STANDARD_PORTS: Incomplete
_LOGGER: Incomplete
PROTOCOL_MAP: Incomplete
VALIDATE_TIMEOUT: int
BASE_SCHEMA: VolDictType
SECURE_PROTOCOLS: Incomplete
ALL_PROTOCOLS: Incomplete
DEFAULT_SECURE_PROTOCOL: str
DEFAULT_NON_SECURE_PROTOCOL: str
PORT_PROTOCOL_MAP: Incomplete

async def validate_input(data: dict[str, str], mac: str | None) -> dict[str, str]: ...
def _address_from_discovery(device: ElkSystem) -> str: ...
def _make_url_from_data(data: dict[str, str]) -> str: ...
def _placeholders_from_device(device: ElkSystem) -> dict[str, str]: ...

class Elkm1ConfigFlow(ConfigFlow, domain=DOMAIN):
    VERSION: int
    host: str | None
    _discovered_device: ElkSystem | None
    _discovered_devices: dict[str, ElkSystem]
    def __init__(self) -> None: ...
    async def async_step_dhcp(self, discovery_info: DhcpServiceInfo) -> ConfigFlowResult: ...
    async def async_step_integration_discovery(self, discovery_info: DiscoveryInfoType) -> ConfigFlowResult: ...
    async def _async_handle_discovery(self) -> ConfigFlowResult: ...
    def is_matching(self, other_flow: Self) -> bool: ...
    async def async_step_discovery_confirm(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_user(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def _async_create_or_error(self, user_input: dict[str, Any], importing: bool) -> tuple[dict[str, str] | None, ConfigFlowResult | None]: ...
    async def async_step_discovered_connection(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_manual_connection(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_import(self, import_data: dict[str, Any]) -> ConfigFlowResult: ...
    def _url_already_configured(self, url: str) -> bool: ...

class InvalidAuth(HomeAssistantError): ...
