from .coordinator import FritzboxConfigEntry as FritzboxConfigEntry
from .entity import FritzBoxDeviceEntity as FritzBoxDeviceEntity
from .model import FritzEntityDescriptionMixinBase as FritzEntityDescriptionMixinBase
from collections.abc import Callable as Callable
from dataclasses import dataclass
from datetime import datetime
from homeassistant.components.climate import PRESET_COMFORT as PRESET_COMFORT, PRESET_ECO as PRESET_ECO
from homeassistant.components.sensor import SensorDeviceClass as SensorDeviceClass, SensorEntity as SensorEntity, SensorEntityDescription as SensorEntityDescription, SensorStateClass as SensorStateClass
from homeassistant.const import EntityCategory as EntityCategory, PERCENTAGE as PERCENTAGE, UnitOfElectricCurrent as UnitOfElectricCurrent, UnitOfElectricPotential as UnitOfElectricPotential, UnitOfEnergy as UnitOfEnergy, UnitOfPower as UnitOfPower, UnitOfTemperature as UnitOfTemperature
from homeassistant.core import HomeAssistant as HomeAssistant, callback as callback
from homeassistant.helpers.entity_platform import AddEntitiesCallback as AddEntitiesCallback
from homeassistant.helpers.typing import StateType as StateType
from homeassistant.util.dt import utc_from_timestamp as utc_from_timestamp
from pyfritzhome.fritzhomedevice import FritzhomeDevice as FritzhomeDevice
from typing import Final

@dataclass(frozen=True)
class FritzEntityDescriptionMixinSensor(FritzEntityDescriptionMixinBase):
    native_value: Callable[[FritzhomeDevice], StateType | datetime]

@dataclass(frozen=True)
class FritzSensorEntityDescription(SensorEntityDescription, FritzEntityDescriptionMixinSensor):
    entity_category_fn: Callable[[FritzhomeDevice], EntityCategory | None] | None = ...

def suitable_eco_temperature(device: FritzhomeDevice) -> bool: ...
def suitable_comfort_temperature(device: FritzhomeDevice) -> bool: ...
def suitable_nextchange_temperature(device: FritzhomeDevice) -> bool: ...
def suitable_nextchange_time(device: FritzhomeDevice) -> bool: ...
def suitable_temperature(device: FritzhomeDevice) -> bool: ...
def entity_category_temperature(device: FritzhomeDevice) -> EntityCategory | None: ...
def value_nextchange_preset(device: FritzhomeDevice) -> str | None: ...
def value_scheduled_preset(device: FritzhomeDevice) -> str | None: ...
def value_nextchange_temperature(device: FritzhomeDevice) -> float | None: ...
def value_nextchange_time(device: FritzhomeDevice) -> datetime | None: ...

SENSOR_TYPES: Final[tuple[FritzSensorEntityDescription, ...]]

async def async_setup_entry(hass: HomeAssistant, entry: FritzboxConfigEntry, async_add_entities: AddEntitiesCallback) -> None: ...

class FritzBoxSensor(FritzBoxDeviceEntity, SensorEntity):
    entity_description: FritzSensorEntityDescription
    @property
    def native_value(self) -> StateType | datetime: ...
    @property
    def entity_category(self) -> EntityCategory | None: ...
