from . import GooglePhotosConfigEntry as GooglePhotosConfigEntry
from .const import DOMAIN as DOMAIN, READ_SCOPE as READ_SCOPE
from _typeshed import Incomplete
from dataclasses import dataclass
from enum import StrEnum
from google_photos_library_api.model import Album as Album, MediaItem as MediaItem
from homeassistant.components.media_player import MediaClass as MediaClass, MediaType as MediaType
from homeassistant.components.media_source import BrowseError as BrowseError, BrowseMediaSource as BrowseMediaSource, MediaSource as MediaSource, MediaSourceItem as MediaSourceItem, PlayMedia as PlayMedia
from homeassistant.core import HomeAssistant as HomeAssistant
from typing import Self

_LOGGER: Incomplete
MEDIA_ITEMS_PAGE_SIZE: int
ALBUM_PAGE_SIZE: int
THUMBNAIL_SIZE: int
LARGE_IMAGE_SIZE: int

class PhotosIdentifierType(StrEnum):
    PHOTO = 'p'
    ALBUM = 'a'
    @classmethod
    def of(cls, name: str) -> PhotosIdentifierType: ...

@dataclass
class PhotosIdentifier:
    config_entry_id: str
    id_type: PhotosIdentifierType | None = ...
    media_id: str | None = ...
    def as_string(self) -> str: ...
    @classmethod
    def of(cls, identifier: str) -> Self: ...
    @classmethod
    def album(cls, config_entry_id: str, media_id: str) -> Self: ...
    @classmethod
    def photo(cls, config_entry_id: str, media_id: str) -> Self: ...

async def async_get_media_source(hass: HomeAssistant) -> MediaSource: ...

class GooglePhotosMediaSource(MediaSource):
    name: str
    hass: Incomplete
    def __init__(self, hass: HomeAssistant) -> None: ...
    async def async_resolve_media(self, item: MediaSourceItem) -> PlayMedia: ...
    async def async_browse_media(self, item: MediaSourceItem) -> BrowseMediaSource: ...
    def _async_config_entries(self) -> list[GooglePhotosConfigEntry]: ...
    def _async_config_entry(self, config_entry_id: str) -> GooglePhotosConfigEntry: ...

def _build_account(config_entry: GooglePhotosConfigEntry, identifier: PhotosIdentifier) -> BrowseMediaSource: ...
def _build_album(title: str, identifier: PhotosIdentifier, thumbnail_url: str | None = None) -> BrowseMediaSource: ...
def _build_media_item(identifier: PhotosIdentifier, media_item: MediaItem) -> BrowseMediaSource: ...
def _media_url(media_item: MediaItem, max_size: int) -> str: ...
def _video_url(media_item: MediaItem) -> str: ...
def _cover_photo_url(album: Album, max_size: int) -> str: ...
