from .const import CONF_UID as CONF_UID, DOMAIN as DOMAIN, LOGGER as LOGGER
from _typeshed import Incomplete
from homeassistant.config_entries import ConfigFlow as ConfigFlow, ConfigFlowResult as ConfigFlowResult
from homeassistant.const import CONF_IP_ADDRESS as CONF_IP_ADDRESS, CONF_PORT as CONF_PORT
from homeassistant.core import HomeAssistant as HomeAssistant, callback as callback
from homeassistant.helpers.service_info.dhcp import DhcpServiceInfo as DhcpServiceInfo
from homeassistant.helpers.service_info.zeroconf import ZeroconfServiceInfo as ZeroconfServiceInfo
from typing import Any

DEFAULT_PORT: int
DATA_SCHEMA: Incomplete
UNIQUE_ID: str

@callback
def async_get_pin_from_discovery_hostname(hostname: str) -> str: ...
@callback
def async_get_pin_from_uid(uid: str) -> str: ...
async def validate_input(hass: HomeAssistant, data: dict[str, Any]) -> dict[str, Any]: ...

class GuardianConfigFlow(ConfigFlow, domain=DOMAIN):
    VERSION: int
    discovery_info: dict[str, Any]
    def __init__(self) -> None: ...
    async def _async_set_unique_id(self, pin: str) -> None: ...
    async def async_step_user(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_dhcp(self, discovery_info: DhcpServiceInfo) -> ConfigFlowResult: ...
    async def async_step_zeroconf(self, discovery_info: ZeroconfServiceInfo) -> ConfigFlowResult: ...
    async def async_step_discovery_confirm(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
