import abc
from .const import DOMAIN as DOMAIN, FIRMWARE as FIRMWARE, RADIO_DEVICE as RADIO_DEVICE, ZHA_DOMAIN as ZHA_DOMAIN, ZHA_HW_DISCOVERY_DATA as ZHA_HW_DISCOVERY_DATA
from .hardware import BOARD_NAME as BOARD_NAME
from _typeshed import Incomplete
from abc import ABC, abstractmethod
from homeassistant.components.hassio import HassioAPIError as HassioAPIError, async_get_yellow_settings as async_get_yellow_settings, async_set_yellow_settings as async_set_yellow_settings, get_supervisor_client as get_supervisor_client
from homeassistant.components.homeassistant_hardware.firmware_config_flow import BaseFirmwareConfigFlow as BaseFirmwareConfigFlow, BaseFirmwareOptionsFlow as BaseFirmwareOptionsFlow
from homeassistant.components.homeassistant_hardware.silabs_multiprotocol_addon import OptionsFlowHandler as MultiprotocolOptionsFlowHandler, SerialPortSettings as MultiprotocolSerialPortSettings
from homeassistant.components.homeassistant_hardware.util import ApplicationType as ApplicationType
from homeassistant.config_entries import ConfigEntry as ConfigEntry, ConfigFlowResult as ConfigFlowResult, OptionsFlow as OptionsFlow, SOURCE_HARDWARE as SOURCE_HARDWARE
from homeassistant.core import HomeAssistant as HomeAssistant, async_get_hass as async_get_hass, callback as callback
from homeassistant.helpers import discovery_flow as discovery_flow, selector as selector
from typing import Any, final

_LOGGER: Incomplete
STEP_HW_SETTINGS_SCHEMA: Incomplete

class HomeAssistantYellowConfigFlow(BaseFirmwareConfigFlow, domain=DOMAIN):
    VERSION: int
    MINOR_VERSION: int
    _device: Incomplete
    def __init__(self, *args: Any, **kwargs: Any) -> None: ...
    @staticmethod
    @callback
    def async_get_options_flow(config_entry: ConfigEntry) -> OptionsFlow: ...
    async def async_step_system(self, data: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    def _async_flow_finished(self) -> ConfigFlowResult: ...

class BaseHomeAssistantYellowOptionsFlow(OptionsFlow, ABC, metaclass=abc.ABCMeta):
    _hw_settings: dict[str, bool] | None
    _supervisor_client: Incomplete
    def __init__(self, hass: HomeAssistant, *args: Any, **kwargs: Any) -> None: ...
    @abstractmethod
    async def async_step_main_menu(self, _: None = None) -> ConfigFlowResult: ...
    @final
    async def async_step_init(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    @final
    async def async_step_on_supervisor(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_hardware_settings(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_reboot_menu(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_reboot_now(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_reboot_later(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...

class HomeAssistantYellowMultiPanOptionsFlowHandler(BaseHomeAssistantYellowOptionsFlow, MultiprotocolOptionsFlowHandler):
    async def async_step_main_menu(self, _: None = None) -> ConfigFlowResult: ...
    async def async_step_multipan_settings(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def _async_serial_port_settings(self) -> MultiprotocolSerialPortSettings: ...
    async def _async_zha_physical_discovery(self) -> dict[str, Any]: ...
    def _zha_name(self) -> str: ...
    def _hardware_name(self) -> str: ...
    async def async_step_flashing_complete(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...

class HomeAssistantYellowOptionsFlowHandler(BaseHomeAssistantYellowOptionsFlow, BaseFirmwareOptionsFlow):
    _hardware_name: Incomplete
    _device: Incomplete
    def __init__(self, hass: HomeAssistant, *args: Any, **kwargs: Any) -> None: ...
    async def async_step_main_menu(self, _: None = None) -> ConfigFlowResult: ...
    async def async_step_firmware_settings(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    def _async_flow_finished(self) -> ConfigFlowResult: ...
