import abc
from .const import CONF_ALLOW_SINGLE_WORD as CONF_ALLOW_SINGLE_WORD, CONF_ICON as CONF_ICON, CONF_URL_PATH as CONF_URL_PATH, ConfigNotFound as ConfigNotFound, DOMAIN as DOMAIN, EVENT_LOVELACE_UPDATED as EVENT_LOVELACE_UPDATED, LOVELACE_CONFIG_FILE as LOVELACE_CONFIG_FILE, LOVELACE_DATA as LOVELACE_DATA, MODE_STORAGE as MODE_STORAGE, MODE_YAML as MODE_YAML, STORAGE_DASHBOARD_CREATE_FIELDS as STORAGE_DASHBOARD_CREATE_FIELDS, STORAGE_DASHBOARD_UPDATE_FIELDS as STORAGE_DASHBOARD_UPDATE_FIELDS
from _typeshed import Incomplete
from abc import ABC, abstractmethod
from homeassistant.components import websocket_api as websocket_api
from homeassistant.components.frontend import DATA_PANELS as DATA_PANELS
from homeassistant.const import CONF_FILENAME as CONF_FILENAME
from homeassistant.core import HomeAssistant as HomeAssistant, callback as callback
from homeassistant.exceptions import HomeAssistantError as HomeAssistantError
from homeassistant.helpers import collection as collection, storage as storage
from homeassistant.helpers.json import json_bytes as json_bytes, json_fragment as json_fragment
from homeassistant.util.yaml import Secrets as Secrets, load_yaml_dict as load_yaml_dict
from typing import Any

CONFIG_STORAGE_KEY_DEFAULT = DOMAIN
CONFIG_STORAGE_KEY: str
CONFIG_STORAGE_VERSION: int
DASHBOARDS_STORAGE_KEY: Incomplete
DASHBOARDS_STORAGE_VERSION: int
_LOGGER: Incomplete

class LovelaceConfig(ABC, metaclass=abc.ABCMeta):
    hass: Incomplete
    config: dict[str, Any] | None
    def __init__(self, hass: HomeAssistant, url_path: str | None, config: dict[str, Any] | None) -> None: ...
    @property
    def url_path(self) -> str | None: ...
    @property
    @abstractmethod
    def mode(self) -> str: ...
    @abstractmethod
    async def async_get_info(self) -> dict[str, Any]: ...
    @abstractmethod
    async def async_load(self, force: bool) -> dict[str, Any]: ...
    async def async_save(self, config: dict[str, Any]) -> None: ...
    async def async_delete(self) -> None: ...
    @abstractmethod
    async def async_json(self, force: bool) -> json_fragment: ...
    @callback
    def _config_updated(self) -> None: ...

class LovelaceStorage(LovelaceConfig):
    _store: Incomplete
    _data: dict[str, Any] | None
    _json_config: json_fragment | None
    def __init__(self, hass: HomeAssistant, config: dict[str, Any] | None) -> None: ...
    @property
    def mode(self) -> str: ...
    async def async_get_info(self) -> dict[str, Any]: ...
    async def async_load(self, force: bool) -> dict[str, Any]: ...
    async def async_json(self, force: bool) -> json_fragment: ...
    async def async_save(self, config: dict[str, Any]) -> None: ...
    async def async_delete(self) -> None: ...
    async def _load(self) -> dict[str, Any]: ...
    @callback
    def _async_build_json(self) -> json_fragment: ...

class LovelaceYAML(LovelaceConfig):
    path: Incomplete
    _cache: tuple[dict[str, Any], float, json_fragment] | None
    def __init__(self, hass: HomeAssistant, url_path: str | None, config: dict[str, Any] | None) -> None: ...
    @property
    def mode(self) -> str: ...
    async def async_get_info(self) -> dict[str, Any]: ...
    async def async_load(self, force: bool) -> dict[str, Any]: ...
    async def async_json(self, force: bool) -> json_fragment: ...
    async def _async_load_or_cached(self, force: bool) -> tuple[dict[str, Any], json_fragment]: ...
    def _load_config(self, force: bool) -> tuple[bool, dict[str, Any], json_fragment]: ...

def _config_info(mode: str, config: dict[str, Any]) -> dict[str, Any]: ...

class DashboardsCollection(collection.DictStorageCollection):
    CREATE_SCHEMA: Incomplete
    UPDATE_SCHEMA: Incomplete
    def __init__(self, hass: HomeAssistant) -> None: ...
    async def _process_create_data(self, data: dict) -> dict: ...
    @callback
    def _get_suggested_id(self, info: dict) -> str: ...
    async def _update_data(self, item: dict, update_data: dict) -> dict: ...

class DashboardsCollectionWebSocket(collection.DictStorageCollectionWebsocket):
    @callback
    def ws_list_item(self, hass: HomeAssistant, connection: websocket_api.ActiveConnection, msg: dict[str, Any]) -> None: ...
