import asyncio
import voluptuous as vol
from .addon import get_addon_manager as get_addon_manager
from .const import ADDON_SLUG as ADDON_SLUG, CONF_INTEGRATION_CREATED_ADDON as CONF_INTEGRATION_CREATED_ADDON, CONF_USE_ADDON as CONF_USE_ADDON, DOMAIN as DOMAIN, LOGGER as LOGGER
from _typeshed import Incomplete
from homeassistant.components.hassio import AddonError as AddonError, AddonInfo as AddonInfo, AddonManager as AddonManager, AddonState as AddonState
from homeassistant.components.onboarding import async_is_onboarded as async_is_onboarded
from homeassistant.config_entries import ConfigFlow as ConfigFlow, ConfigFlowResult as ConfigFlowResult
from homeassistant.const import CONF_URL as CONF_URL
from homeassistant.core import HomeAssistant as HomeAssistant
from homeassistant.data_entry_flow import AbortFlow as AbortFlow
from homeassistant.exceptions import HomeAssistantError as HomeAssistantError
from homeassistant.helpers import aiohttp_client as aiohttp_client
from homeassistant.helpers.hassio import is_hassio as is_hassio
from homeassistant.helpers.service_info.hassio import HassioServiceInfo as HassioServiceInfo
from homeassistant.helpers.service_info.zeroconf import ZeroconfServiceInfo as ZeroconfServiceInfo
from typing import Any

ADDON_SETUP_TIMEOUT: int
ADDON_SETUP_TIMEOUT_ROUNDS: int
DEFAULT_URL: str
DEFAULT_TITLE: str
ON_SUPERVISOR_SCHEMA: Incomplete

def get_manual_schema(user_input: dict[str, Any]) -> vol.Schema: ...
async def validate_input(hass: HomeAssistant, data: dict[str, Any]) -> None: ...
def build_ws_address(host: str, port: int) -> str: ...

class MatterConfigFlow(ConfigFlow, domain=DOMAIN):
    VERSION: int
    _running_in_background: bool
    ws_address: str | None
    integration_created_addon: bool
    install_task: asyncio.Task | None
    start_task: asyncio.Task | None
    use_addon: bool
    def __init__(self) -> None: ...
    async def async_step_install_addon(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_install_failed(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def _async_install_addon(self) -> None: ...
    async def _async_get_addon_discovery_info(self) -> dict: ...
    async def async_step_start_addon(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_start_failed(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def _async_start_addon(self) -> None: ...
    async def _async_get_addon_info(self) -> AddonInfo: ...
    async def async_step_user(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_manual(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_zeroconf(self, discovery_info: ZeroconfServiceInfo) -> ConfigFlowResult: ...
    async def async_step_hassio(self, discovery_info: HassioServiceInfo) -> ConfigFlowResult: ...
    async def async_step_hassio_confirm(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_on_supervisor(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_finish_addon_setup(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def _async_create_entry_or_abort(self) -> ConfigFlowResult: ...

class FailedConnect(HomeAssistantError): ...
