from _typeshed import Incomplete
from dataclasses import dataclass
from enum import StrEnum
from homeassistant.core import HomeAssistant as HomeAssistant
from mcstatus import BedrockServer, JavaServer
from mcstatus.status_response import BedrockStatusResponse as BedrockStatusResponse, JavaStatusResponse

_LOGGER: Incomplete
LOOKUP_TIMEOUT: float
DATA_UPDATE_TIMEOUT: float
DATA_UPDATE_RETRIES: int

@dataclass
class MinecraftServerData:
    latency: float
    motd: str
    players_max: int
    players_online: int
    protocol_version: int
    version: str
    players_list: list[str] | None = ...
    edition: str | None = ...
    game_mode: str | None = ...
    map_name: str | None = ...

class MinecraftServerType(StrEnum):
    BEDROCK_EDITION = 'Bedrock Edition'
    JAVA_EDITION = 'Java Edition'

class MinecraftServerAddressError(Exception): ...
class MinecraftServerConnectionError(Exception): ...
class MinecraftServerNotInitializedError(Exception): ...

class MinecraftServer:
    _server: BedrockServer | JavaServer | None
    _hass: Incomplete
    _server_type: Incomplete
    _address: Incomplete
    def __init__(self, hass: HomeAssistant, server_type: MinecraftServerType, address: str) -> None: ...
    async def async_initialize(self) -> None: ...
    async def async_is_online(self) -> bool: ...
    async def async_get_data(self) -> MinecraftServerData: ...
    def _extract_java_data(self, status_response: JavaStatusResponse) -> MinecraftServerData: ...
    def _extract_bedrock_data(self, status_response: BedrockStatusResponse) -> MinecraftServerData: ...
    def _get_error_message(self, error: BaseException) -> str: ...
