from .const import DEFAULT_SCAN_INTERVAL as DEFAULT_SCAN_INTERVAL, DOMAIN as DOMAIN, INTEGRATION_SUPPORTED_COMMANDS as INTEGRATION_SUPPORTED_COMMANDS, PLATFORMS as PLATFORMS
from _typeshed import Incomplete
from dataclasses import dataclass
from homeassistant.config_entries import ConfigEntry as ConfigEntry
from homeassistant.const import CONF_ALIAS as CONF_ALIAS, CONF_HOST as CONF_HOST, CONF_PASSWORD as CONF_PASSWORD, CONF_PORT as CONF_PORT, CONF_RESOURCES as CONF_RESOURCES, CONF_SCAN_INTERVAL as CONF_SCAN_INTERVAL, CONF_USERNAME as CONF_USERNAME, EVENT_HOMEASSISTANT_STOP as EVENT_HOMEASSISTANT_STOP
from homeassistant.core import Event as Event, HomeAssistant as HomeAssistant, callback as callback
from homeassistant.exceptions import ConfigEntryAuthFailed as ConfigEntryAuthFailed, HomeAssistantError as HomeAssistantError
from homeassistant.helpers.update_coordinator import DataUpdateCoordinator as DataUpdateCoordinator, UpdateFailed as UpdateFailed

NUT_FAKE_SERIAL: Incomplete
_LOGGER: Incomplete
type NutConfigEntry = ConfigEntry[NutRuntimeData]

@dataclass
class NutRuntimeData:
    coordinator: DataUpdateCoordinator
    data: PyNUTData
    unique_id: str
    user_available_commands: set[str]

async def async_setup_entry(hass: HomeAssistant, entry: NutConfigEntry) -> bool: ...
async def async_unload_entry(hass: HomeAssistant, entry: ConfigEntry) -> bool: ...
async def _async_update_listener(hass: HomeAssistant, entry: ConfigEntry) -> None: ...
def _manufacturer_from_status(status: dict[str, str]) -> str | None: ...
def _model_from_status(status: dict[str, str]) -> str | None: ...
def _firmware_from_status(status: dict[str, str]) -> str | None: ...
def _serial_from_status(status: dict[str, str]) -> str | None: ...
def _unique_id_from_status(status: dict[str, str]) -> str | None: ...

@dataclass
class NUTDeviceInfo:
    manufacturer: str | None = ...
    model: str | None = ...
    model_id: str | None = ...
    firmware: str | None = ...
    serial: str | None = ...
    device_location: str | None = ...

class PyNUTData:
    _host: Incomplete
    _alias: Incomplete
    _client: Incomplete
    ups_list: dict[str, str] | None
    _status: dict[str, str] | None
    _device_info: NUTDeviceInfo | None
    def __init__(self, host: str, port: int, alias: str | None, username: str | None, password: str | None, persistent: bool = True) -> None: ...
    @property
    def status(self) -> dict[str, str] | None: ...
    @property
    def name(self) -> str: ...
    @property
    def device_info(self) -> NUTDeviceInfo: ...
    async def _async_get_alias(self) -> str | None: ...
    def _get_device_info(self) -> NUTDeviceInfo | None: ...
    async def _async_get_status(self) -> dict[str, str]: ...
    async def async_update(self) -> dict[str, str]: ...
    async def async_run_command(self, command_name: str) -> None: ...
    async def async_list_commands(self) -> set[str] | None: ...
    @callback
    def async_shutdown(self, _: Event | None = None) -> None: ...
