from ..coordinator import OverkizDataUpdateCoordinator as OverkizDataUpdateCoordinator
from ..entity import OverkizEntity as OverkizEntity
from _typeshed import Incomplete
from homeassistant.components.water_heater import STATE_ECO as STATE_ECO, STATE_HIGH_DEMAND as STATE_HIGH_DEMAND, STATE_PERFORMANCE as STATE_PERFORMANCE, WaterHeaterEntity as WaterHeaterEntity, WaterHeaterEntityFeature as WaterHeaterEntityFeature
from homeassistant.const import ATTR_TEMPERATURE as ATTR_TEMPERATURE, STATE_OFF as STATE_OFF, STATE_ON as STATE_ON, UnitOfTemperature as UnitOfTemperature
from typing import Any

OVERKIZ_TO_OPERATION_MODE: dict[str, str]
DHWP_AWAY_MODES: Incomplete
DEFAULT_MIN_TEMP: float
DEFAULT_MAX_TEMP: float

class DomesticHotWaterProduction(OverkizEntity, WaterHeaterEntity):
    _attr_temperature_unit: Incomplete
    _attr_supported_features: Incomplete
    operation_mode_to_overkiz: dict[str, str]
    _attr_operation_list: Incomplete
    def __init__(self, device_url: str, coordinator: OverkizDataUpdateCoordinator) -> None: ...
    @property
    def _is_boost_mode_on(self) -> bool: ...
    @property
    def is_away_mode_on(self) -> bool | None: ...
    @property
    def min_temp(self) -> float: ...
    @property
    def max_temp(self) -> float: ...
    @property
    def current_temperature(self) -> float | None: ...
    @property
    def target_temperature(self) -> float | None: ...
    @property
    def target_temperature_high(self) -> float | None: ...
    @property
    def target_temperature_low(self) -> float | None: ...
    async def async_set_temperature(self, **kwargs: Any) -> None: ...
    @property
    def current_operation(self) -> str | None: ...
    async def async_set_operation_mode(self, operation_mode: str) -> None: ...
