from _typeshed import Incomplete
from aiohttp import web
from collections.abc import Callable as Callable
from dataclasses import dataclass
from homeassistant.components.alarm_control_panel import AlarmControlPanelState as AlarmControlPanelState
from homeassistant.components.climate import ATTR_CURRENT_TEMPERATURE as ATTR_CURRENT_TEMPERATURE, ATTR_FAN_MODE as ATTR_FAN_MODE, ATTR_FAN_MODES as ATTR_FAN_MODES, ATTR_HVAC_ACTION as ATTR_HVAC_ACTION, ATTR_HVAC_MODES as ATTR_HVAC_MODES, ATTR_TARGET_TEMP_HIGH as ATTR_TARGET_TEMP_HIGH, ATTR_TARGET_TEMP_LOW as ATTR_TARGET_TEMP_LOW, HVACAction as HVACAction
from homeassistant.components.cover import ATTR_CURRENT_POSITION as ATTR_CURRENT_POSITION, ATTR_CURRENT_TILT_POSITION as ATTR_CURRENT_TILT_POSITION
from homeassistant.components.fan import ATTR_DIRECTION as ATTR_DIRECTION, ATTR_OSCILLATING as ATTR_OSCILLATING, ATTR_PERCENTAGE as ATTR_PERCENTAGE, ATTR_PRESET_MODE as ATTR_PRESET_MODE, ATTR_PRESET_MODES as ATTR_PRESET_MODES, DIRECTION_FORWARD as DIRECTION_FORWARD, DIRECTION_REVERSE as DIRECTION_REVERSE
from homeassistant.components.http import HomeAssistantView as HomeAssistantView, KEY_HASS as KEY_HASS
from homeassistant.components.humidifier import ATTR_AVAILABLE_MODES as ATTR_AVAILABLE_MODES, ATTR_HUMIDITY as ATTR_HUMIDITY
from homeassistant.components.light import ATTR_BRIGHTNESS as ATTR_BRIGHTNESS
from homeassistant.components.sensor import SensorDeviceClass as SensorDeviceClass
from homeassistant.const import ATTR_BATTERY_LEVEL as ATTR_BATTERY_LEVEL, ATTR_DEVICE_CLASS as ATTR_DEVICE_CLASS, ATTR_FRIENDLY_NAME as ATTR_FRIENDLY_NAME, ATTR_MODE as ATTR_MODE, ATTR_TEMPERATURE as ATTR_TEMPERATURE, ATTR_UNIT_OF_MEASUREMENT as ATTR_UNIT_OF_MEASUREMENT, CONTENT_TYPE_TEXT_PLAIN as CONTENT_TYPE_TEXT_PLAIN, EVENT_STATE_CHANGED as EVENT_STATE_CHANGED, PERCENTAGE as PERCENTAGE, STATE_CLOSED as STATE_CLOSED, STATE_CLOSING as STATE_CLOSING, STATE_ON as STATE_ON, STATE_OPEN as STATE_OPEN, STATE_OPENING as STATE_OPENING, STATE_UNAVAILABLE as STATE_UNAVAILABLE, STATE_UNKNOWN as STATE_UNKNOWN, UnitOfTemperature as UnitOfTemperature
from homeassistant.core import Event as Event, EventStateChangedData as EventStateChangedData, HomeAssistant as HomeAssistant, State as State
from homeassistant.helpers import entityfilter as entityfilter
from homeassistant.helpers.entity_registry import EVENT_ENTITY_REGISTRY_UPDATED as EVENT_ENTITY_REGISTRY_UPDATED, EventEntityRegistryUpdatedData as EventEntityRegistryUpdatedData
from homeassistant.helpers.entity_values import EntityValues as EntityValues
from homeassistant.helpers.typing import ConfigType as ConfigType
from homeassistant.util.dt import as_timestamp as as_timestamp
from homeassistant.util.unit_conversion import TemperatureConverter as TemperatureConverter
from prometheus_client.metrics import MetricWrapperBase as MetricWrapperBase
from typing import Any

_LOGGER: Incomplete
API_ENDPOINT: str
IGNORED_STATES: Incomplete
DOMAIN: str
CONF_FILTER: str
CONF_REQUIRES_AUTH: str
CONF_PROM_NAMESPACE: str
CONF_COMPONENT_CONFIG: str
CONF_COMPONENT_CONFIG_GLOB: str
CONF_COMPONENT_CONFIG_DOMAIN: str
CONF_DEFAULT_METRIC: str
CONF_OVERRIDE_METRIC: str
COMPONENT_CONFIG_SCHEMA_ENTRY: Incomplete
ALLOWED_METRIC_CHARS: Incomplete
DEFAULT_NAMESPACE: str
CONFIG_SCHEMA: Incomplete

def setup(hass: HomeAssistant, config: ConfigType) -> bool: ...

@dataclass(frozen=True, slots=True)
class MetricNameWithLabelValues:
    metric_name: str
    label_values: tuple[str, ...]

class PrometheusMetrics:
    _component_config: Incomplete
    _override_metric: Incomplete
    _default_metric: Incomplete
    _filter: Incomplete
    _sensor_metric_handlers: list[Callable[[State, str | None], str | None]]
    metrics_prefix: Incomplete
    _metrics: dict[str, MetricWrapperBase]
    _metrics_by_entity_id: dict[str, set[MetricNameWithLabelValues]]
    _climate_units: Incomplete
    def __init__(self, entity_filter: entityfilter.EntityFilter, namespace: str, climate_units: UnitOfTemperature, component_config: EntityValues, override_metric: str | None, default_metric: str | None) -> None: ...
    def handle_state_changed_event(self, event: Event[EventStateChangedData]) -> None: ...
    def handle_state(self, state: State) -> None: ...
    def handle_entity_registry_updated(self, event: Event[EventEntityRegistryUpdatedData]) -> None: ...
    def _remove_labelsets(self, entity_id: str, ignored_metric_names: set[str] | None = None) -> None: ...
    def _handle_attributes(self, state: State) -> None: ...
    def _metric[_MetricBaseT: MetricWrapperBase](self, metric_name: str, factory: type[_MetricBaseT], documentation: str, labels: dict[str, str]) -> _MetricBaseT: ...
    @staticmethod
    def _sanitize_metric_name(metric: str) -> str: ...
    @staticmethod
    def state_as_number(state: State) -> float | None: ...
    @staticmethod
    def _labels(state: State, extra_labels: dict[str, str] | None = None) -> dict[str, Any]: ...
    def _battery(self, state: State) -> None: ...
    def _handle_binary_sensor(self, state: State) -> None: ...
    def _handle_input_boolean(self, state: State) -> None: ...
    def _numeric_handler(self, state: State, domain: str, title: str) -> None: ...
    def _handle_input_number(self, state: State) -> None: ...
    def _handle_number(self, state: State) -> None: ...
    def _handle_device_tracker(self, state: State) -> None: ...
    def _handle_person(self, state: State) -> None: ...
    def _handle_cover(self, state: State) -> None: ...
    def _handle_light(self, state: State) -> None: ...
    def _handle_lock(self, state: State) -> None: ...
    def _handle_climate_temp(self, state: State, attr: str, metric_name: str, metric_description: str) -> None: ...
    def _handle_climate(self, state: State) -> None: ...
    def _handle_humidifier(self, state: State) -> None: ...
    def _handle_sensor(self, state: State) -> None: ...
    def _sensor_default_metric(self, state: State, unit: str | None) -> str | None: ...
    @staticmethod
    def _sensor_attribute_metric(state: State, unit: str | None) -> str | None: ...
    @staticmethod
    def _sensor_timestamp_metric(state: State, unit: str | None) -> str | None: ...
    def _sensor_override_metric(self, state: State, unit: str | None) -> str | None: ...
    def _sensor_override_component_metric(self, state: State, unit: str | None) -> str | None: ...
    @staticmethod
    def _sensor_fallback_metric(state: State, unit: str | None) -> str | None: ...
    @staticmethod
    def _unit_string(unit: str | None) -> str | None: ...
    def _handle_switch(self, state: State) -> None: ...
    def _handle_fan(self, state: State) -> None: ...
    def _handle_zwave(self, state: State) -> None: ...
    def _handle_automation(self, state: State) -> None: ...
    def _handle_counter(self, state: State) -> None: ...
    def _handle_update(self, state: State) -> None: ...
    def _handle_alarm_control_panel(self, state: State) -> None: ...

class PrometheusView(HomeAssistantView):
    url = API_ENDPOINT
    name: str
    requires_auth: Incomplete
    def __init__(self, requires_auth: bool) -> None: ...
    async def get(self, request: web.Request) -> web.Response: ...
