import threading
from _typeshed import Incomplete
from homeassistant.helpers.frame import ReportBehavior as ReportBehavior, report_usage as report_usage
from homeassistant.util.loop import raise_for_blocking_call as raise_for_blocking_call
from sqlalchemy.pool import ConnectionPoolEntry as ConnectionPoolEntry, NullPool, SingletonThreadPool, StaticPool
from typing import Any

_LOGGER: Incomplete
DEBUG_MUTEX_POOL: bool
DEBUG_MUTEX_POOL_TRACE: bool
POOL_SIZE: int
ADVISE_MSG: str

class RecorderPool(SingletonThreadPool, NullPool):
    recorder_and_worker_thread_ids: Incomplete
    def __init__(self, creator: Any, recorder_and_worker_thread_ids: set[int] | None = None, **kw: Any) -> None: ...
    def recreate(self) -> RecorderPool: ...
    def _do_return_conn(self, record: ConnectionPoolEntry) -> None: ...
    def shutdown(self) -> None: ...
    def dispose(self) -> None: ...
    def _do_get(self) -> ConnectionPoolEntry: ...
    def _do_get_db_connection_protected(self) -> ConnectionPoolEntry: ...

class MutexPool(StaticPool):
    _reference_counter: int
    pool_lock: threading.RLock
    def _do_return_conn(self, record: ConnectionPoolEntry) -> None: ...
    def _do_get(self) -> ConnectionPoolEntry: ...
