from . import BaseLRUTableManager as BaseLRUTableManager
from ..core import Recorder as Recorder
from ..db_schema import StatesMeta as StatesMeta
from ..queries import find_all_states_metadata_ids as find_all_states_metadata_ids, find_states_metadata_ids as find_states_metadata_ids
from ..util import execute_stmt_lambda_element as execute_stmt_lambda_element
from collections.abc import Iterable
from homeassistant.core import Event as Event, EventStateChangedData as EventStateChangedData
from homeassistant.util.collection import chunked_or_all as chunked_or_all
from sqlalchemy.orm.session import Session as Session

CACHE_SIZE: int

class StatesMetaManager(BaseLRUTableManager[StatesMeta]):
    active: bool
    _did_first_load: bool
    def __init__(self, recorder: Recorder) -> None: ...
    def load(self, events: list[Event[EventStateChangedData]], session: Session) -> None: ...
    def get(self, entity_id: str, session: Session, from_recorder: bool) -> int | None: ...
    def get_metadata_id_to_entity_id(self, session: Session) -> dict[int, str]: ...
    def get_many(self, entity_ids: Iterable[str], session: Session, from_recorder: bool) -> dict[str, int | None]: ...
    def add_pending(self, db_states_meta: StatesMeta) -> None: ...
    def post_commit_pending(self) -> None: ...
    def evict_purged(self, entity_ids: Iterable[str]) -> None: ...
    def update_metadata(self, session: Session, entity_id: str, new_entity_id: str) -> bool: ...
