import abc
from .config import ScriptConfig as ScriptConfig, ValidationStatus as ValidationStatus
from .const import ATTR_LAST_ACTION as ATTR_LAST_ACTION, ATTR_LAST_TRIGGERED as ATTR_LAST_TRIGGERED, ATTR_VARIABLES as ATTR_VARIABLES, CONF_FIELDS as CONF_FIELDS, CONF_TRACE as CONF_TRACE, DOMAIN as DOMAIN, ENTITY_ID_FORMAT as ENTITY_ID_FORMAT, EVENT_SCRIPT_STARTED as EVENT_SCRIPT_STARTED, LOGGER as LOGGER
from .helpers import async_get_blueprints as async_get_blueprints
from .trace import trace_script as trace_script
from _typeshed import Incomplete
from abc import ABC, abstractmethod
from dataclasses import dataclass
from homeassistant.components import websocket_api as websocket_api
from homeassistant.components.blueprint import CONF_USE_BLUEPRINT as CONF_USE_BLUEPRINT
from homeassistant.const import ATTR_ENTITY_ID as ATTR_ENTITY_ID, ATTR_MODE as ATTR_MODE, ATTR_NAME as ATTR_NAME, CONF_ALIAS as CONF_ALIAS, CONF_DESCRIPTION as CONF_DESCRIPTION, CONF_ICON as CONF_ICON, CONF_MODE as CONF_MODE, CONF_NAME as CONF_NAME, CONF_PATH as CONF_PATH, CONF_SEQUENCE as CONF_SEQUENCE, CONF_VARIABLES as CONF_VARIABLES, SERVICE_RELOAD as SERVICE_RELOAD, SERVICE_TOGGLE as SERVICE_TOGGLE, SERVICE_TURN_OFF as SERVICE_TURN_OFF, SERVICE_TURN_ON as SERVICE_TURN_ON, STATE_ON as STATE_ON
from homeassistant.core import Context as Context, HomeAssistant as HomeAssistant, ServiceCall as ServiceCall, ServiceResponse as ServiceResponse, SupportsResponse as SupportsResponse, callback as callback
from homeassistant.helpers.config_validation import make_entity_service_schema as make_entity_service_schema
from homeassistant.helpers.entity import ToggleEntity as ToggleEntity
from homeassistant.helpers.entity_component import EntityComponent as EntityComponent
from homeassistant.helpers.issue_registry import IssueSeverity as IssueSeverity, async_create_issue as async_create_issue, async_delete_issue as async_delete_issue
from homeassistant.helpers.restore_state import RestoreEntity as RestoreEntity
from homeassistant.helpers.script import ATTR_CUR as ATTR_CUR, ATTR_MAX as ATTR_MAX, CONF_MAX as CONF_MAX, CONF_MAX_EXCEEDED as CONF_MAX_EXCEEDED, Script as Script, ScriptRunResult as ScriptRunResult, script_stack_cv as script_stack_cv
from homeassistant.helpers.service import async_set_service_schema as async_set_service_schema
from homeassistant.helpers.trace import trace_get as trace_get, trace_path as trace_path
from homeassistant.helpers.typing import ConfigType as ConfigType
from homeassistant.loader import bind_hass as bind_hass
from homeassistant.util.async_ import create_eager_task as create_eager_task
from homeassistant.util.dt import parse_datetime as parse_datetime
from propcache.api import cached_property
from typing import Any

SCRIPT_SERVICE_SCHEMA: Incomplete
SCRIPT_TURN_ONOFF_SCHEMA: Incomplete
RELOAD_SERVICE_SCHEMA: Incomplete

@bind_hass
def is_on(hass: HomeAssistant, entity_id: str) -> bool: ...
def _scripts_with_x(hass: HomeAssistant, referenced_id: str, property_name: str) -> list[str]: ...
def _x_in_script(hass: HomeAssistant, entity_id: str, property_name: str) -> list[str]: ...
@callback
def scripts_with_entity(hass: HomeAssistant, entity_id: str) -> list[str]: ...
@callback
def entities_in_script(hass: HomeAssistant, entity_id: str) -> list[str]: ...
@callback
def scripts_with_device(hass: HomeAssistant, device_id: str) -> list[str]: ...
@callback
def devices_in_script(hass: HomeAssistant, entity_id: str) -> list[str]: ...
@callback
def scripts_with_area(hass: HomeAssistant, area_id: str) -> list[str]: ...
@callback
def areas_in_script(hass: HomeAssistant, entity_id: str) -> list[str]: ...
@callback
def scripts_with_floor(hass: HomeAssistant, floor_id: str) -> list[str]: ...
@callback
def floors_in_script(hass: HomeAssistant, entity_id: str) -> list[str]: ...
@callback
def scripts_with_label(hass: HomeAssistant, label_id: str) -> list[str]: ...
@callback
def labels_in_script(hass: HomeAssistant, entity_id: str) -> list[str]: ...
@callback
def scripts_with_blueprint(hass: HomeAssistant, blueprint_path: str) -> list[str]: ...
@callback
def blueprint_in_script(hass: HomeAssistant, entity_id: str) -> str | None: ...
async def async_setup(hass: HomeAssistant, config: ConfigType) -> bool: ...

@dataclass(slots=True)
class ScriptEntityConfig:
    config_block: ConfigType
    key: str
    raw_blueprint_inputs: ConfigType | None
    raw_config: ConfigType | None
    validation_error: str | None
    validation_status: ValidationStatus

async def _prepare_script_config(hass: HomeAssistant, config: ConfigType) -> list[ScriptEntityConfig]: ...
async def _create_script_entities(hass: HomeAssistant, script_configs: list[ScriptEntityConfig]) -> list[BaseScriptEntity]: ...
async def _async_process_config(hass: HomeAssistant, config: ConfigType, component: EntityComponent[BaseScriptEntity]) -> None: ...

class BaseScriptEntity(ToggleEntity, ABC, metaclass=abc.ABCMeta):
    _entity_component_unrecorded_attributes: Incomplete
    raw_config: ConfigType | None
    @cached_property
    @abstractmethod
    def referenced_labels(self) -> set[str]: ...
    @cached_property
    @abstractmethod
    def referenced_floors(self) -> set[str]: ...
    @cached_property
    @abstractmethod
    def referenced_areas(self) -> set[str]: ...
    @property
    @abstractmethod
    def referenced_blueprint(self) -> str | None: ...
    @cached_property
    @abstractmethod
    def referenced_devices(self) -> set[str]: ...
    @cached_property
    @abstractmethod
    def referenced_entities(self) -> set[str]: ...

class UnavailableScriptEntity(BaseScriptEntity):
    _attr_should_poll: bool
    _attr_available: bool
    _attr_name: Incomplete
    _attr_unique_id: Incomplete
    raw_config: Incomplete
    _validation_error: Incomplete
    _validation_status: Incomplete
    def __init__(self, key: str, raw_config: ConfigType | None, validation_error: str, validation_status: ValidationStatus) -> None: ...
    @cached_property
    def referenced_labels(self) -> set[str]: ...
    @cached_property
    def referenced_floors(self) -> set[str]: ...
    @cached_property
    def referenced_areas(self) -> set[str]: ...
    @property
    def referenced_blueprint(self) -> str | None: ...
    @cached_property
    def referenced_devices(self) -> set[str]: ...
    @cached_property
    def referenced_entities(self) -> set[str]: ...
    async def async_added_to_hass(self) -> None: ...
    async def async_will_remove_from_hass(self) -> None: ...

class ScriptEntity(BaseScriptEntity, RestoreEntity):
    icon: Incomplete
    _attr_should_poll: bool
    _attr_unique_id: str
    description: Incomplete
    fields: Incomplete
    entity_id: Incomplete
    script: Incomplete
    _changed: Incomplete
    raw_config: Incomplete
    _trace_config: Incomplete
    _blueprint_inputs: Incomplete
    _attr_name: Incomplete
    def __init__(self, hass: HomeAssistant, key: str, cfg: ConfigType, raw_config: ConfigType | None, blueprint_inputs: ConfigType | None) -> None: ...
    @property
    def extra_state_attributes(self) -> dict[str, Any]: ...
    @property
    def is_on(self) -> bool: ...
    @cached_property
    def referenced_labels(self) -> set[str]: ...
    @cached_property
    def referenced_floors(self) -> set[str]: ...
    @cached_property
    def referenced_areas(self) -> set[str]: ...
    @property
    def referenced_blueprint(self) -> str | None: ...
    @cached_property
    def referenced_devices(self) -> set[str]: ...
    @cached_property
    def referenced_entities(self) -> set[str]: ...
    @callback
    def async_change_listener(self) -> None: ...
    async def async_turn_on(self, **kwargs: Any) -> None: ...
    async def _async_start_run(self, variables: dict[str, Any] | None, context: Context, wait: bool) -> ServiceResponse: ...
    async def _async_run(self, variables: dict[str, Any] | None, context: Context) -> ScriptRunResult | None: ...
    async def async_turn_off(self, **kwargs: Any) -> None: ...
    async def _service_handler(self, service: ServiceCall) -> ServiceResponse: ...
    async def async_added_to_hass(self) -> None: ...
    async def async_will_remove_from_hass(self) -> None: ...

def websocket_config(hass: HomeAssistant, connection: websocket_api.ActiveConnection, msg: dict[str, Any]) -> None: ...
