from .const import CONF_GATEWAY_ID as CONF_GATEWAY_ID, CONF_IDENTITY as CONF_IDENTITY, CONF_KEY as CONF_KEY, DOMAIN as DOMAIN
from _typeshed import Incomplete
from homeassistant.config_entries import ConfigFlow as ConfigFlow, ConfigFlowResult as ConfigFlowResult
from homeassistant.const import CONF_HOST as CONF_HOST
from homeassistant.core import HomeAssistant as HomeAssistant
from homeassistant.helpers.service_info.zeroconf import ATTR_PROPERTIES_ID as ATTR_PROPERTIES_ID, ZeroconfServiceInfo as ZeroconfServiceInfo
from typing import Any

KEY_SECURITY_CODE: str

class AuthError(Exception):
    code: Incomplete
    def __init__(self, code: str) -> None: ...

class FlowHandler(ConfigFlow, domain=DOMAIN):
    VERSION: int
    _host: str | None
    def __init__(self) -> None: ...
    async def async_step_user(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_auth(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_homekit(self, discovery_info: ZeroconfServiceInfo) -> ConfigFlowResult: ...
    async def _entry_from_data(self, data: dict[str, Any]) -> ConfigFlowResult: ...

async def authenticate(hass: HomeAssistant, host: str, security_code: str) -> dict[str, str | bool]: ...
async def get_gateway_info(hass: HomeAssistant, host: str, identity: str, key: str) -> dict[str, str | bool]: ...
