from .models import USBDevice
from _typeshed import Incomplete
from collections.abc import Callable, Coroutine, Sequence
from homeassistant.components import websocket_api
from homeassistant.core import CALLBACK_TYPE, Event, HomeAssistant, callback as hass_callback
from homeassistant.helpers.debounce import Debouncer
from homeassistant.loader import USBMatcher
from serial.tools.list_ports_common import ListPortInfo
from typing import Any, overload

__all__ = ['USBCallbackMatcher', 'async_is_plugged_in', 'async_register_port_event_callback', 'async_register_scan_request_callback']

PORT_EVENT_CALLBACK_TYPE = Callable[[set[USBDevice], set[USBDevice]], None]

class USBCallbackMatcher(USBMatcher): ...

@hass_callback
def async_register_scan_request_callback(hass: HomeAssistant, callback: CALLBACK_TYPE) -> CALLBACK_TYPE: ...
@hass_callback
def async_register_port_event_callback(hass: HomeAssistant, callback: PORT_EVENT_CALLBACK_TYPE) -> CALLBACK_TYPE: ...
@hass_callback
def async_is_plugged_in(hass: HomeAssistant, matcher: USBCallbackMatcher) -> bool: ...

class USBDiscovery:
    hass: Incomplete
    usb: Incomplete
    seen: set[tuple[str, ...]]
    observer_active: bool
    _request_debouncer: Debouncer[Coroutine[Any, Any, None]] | None
    _add_remove_debouncer: Debouncer[Coroutine[Any, Any, None]] | None
    _request_callbacks: list[CALLBACK_TYPE]
    initial_scan_done: bool
    _initial_scan_callbacks: list[CALLBACK_TYPE]
    _port_event_callbacks: set[PORT_EVENT_CALLBACK_TYPE]
    _last_processed_devices: set[USBDevice]
    _scan_lock: Incomplete
    def __init__(self, hass: HomeAssistant, usb: list[USBMatcher]) -> None: ...
    async def async_setup(self) -> None: ...
    async def async_start(self, event: Event) -> None: ...
    @hass_callback
    def async_stop(self, event: Event) -> None: ...
    @hass_callback
    def _async_supports_monitoring(self) -> bool: ...
    async def _async_start_monitor(self) -> None: ...
    @hass_callback
    def _async_start_monitor_polling(self) -> None: ...
    async def _async_start_aiousbwatcher(self) -> None: ...
    @hass_callback
    def async_register_scan_request_callback(self, _callback: CALLBACK_TYPE) -> CALLBACK_TYPE: ...
    @hass_callback
    def async_register_initial_scan_callback(self, callback: CALLBACK_TYPE) -> CALLBACK_TYPE: ...
    @hass_callback
    def async_register_port_event_callback(self, callback: PORT_EVENT_CALLBACK_TYPE) -> CALLBACK_TYPE: ...
    async def _async_process_discovered_usb_device(self, device: USBDevice) -> None: ...
    async def _async_process_ports(self, ports: Sequence[ListPortInfo]) -> None: ...
    @hass_callback
    def _async_delayed_add_remove_scan(self) -> None: ...
    async def _async_scan_serial(self) -> None: ...
    async def _async_scan(self) -> None: ...
    async def async_request_scan(self) -> None: ...
