from _typeshed import Incomplete
from enum import StrEnum

DOMAIN: str
UPDATE_INTERVAL: int
BIDIRECTIONAL_MODEL_PREFIXES: Incomplete
CODE_KEY: str
CONF_STATION: str
CHARGER_ADDED_DISCHARGED_ENERGY_KEY: str
CHARGER_ADDED_ENERGY_KEY: str
CHARGER_ADDED_RANGE_KEY: str
CHARGER_CHARGING_POWER_KEY: str
CHARGER_CHARGING_SPEED_KEY: str
CHARGER_CHARGING_TIME_KEY: str
CHARGER_COST_KEY: str
CHARGER_CURRENT_MODE_KEY: str
CHARGER_CURRENT_VERSION_KEY: str
CHARGER_CURRENCY_KEY: str
CHARGER_DATA_KEY: str
CHARGER_DEPOT_PRICE_KEY: str
CHARGER_ENERGY_PRICE_KEY: str
CHARGER_FEATURES_KEY: str
CHARGER_SERIAL_NUMBER_KEY: str
CHARGER_PART_NUMBER_KEY: str
CHARGER_PLAN_KEY: str
CHARGER_POWER_BOOST_KEY: str
CHARGER_SOFTWARE_KEY: str
CHARGER_MAX_AVAILABLE_POWER_KEY: str
CHARGER_MAX_CHARGING_CURRENT_KEY: str
CHARGER_MAX_ICP_CURRENT_KEY: str
CHARGER_PAUSE_RESUME_KEY: str
CHARGER_LOCKED_UNLOCKED_KEY: str
CHARGER_NAME_KEY: str
CHARGER_STATE_OF_CHARGE_KEY: str
CHARGER_STATUS_ID_KEY: str
CHARGER_STATUS_DESCRIPTION_KEY: str
CHARGER_CONNECTIONS: str

class ChargerStatus(StrEnum):
    CHARGING = 'Charging'
    DISCHARGING = 'Discharging'
    PAUSED = 'Paused'
    SCHEDULED = 'Scheduled'
    WAITING_FOR_CAR = 'Waiting for car demand'
    WAITING = 'Waiting'
    DISCONNECTED = 'Disconnected'
    ERROR = 'Error'
    READY = 'Ready'
    LOCKED = 'Locked'
    LOCKED_CAR_CONNECTED = 'Locked, car connected'
    UPDATING = 'Updating'
    WAITING_IN_QUEUE_POWER_SHARING = 'Waiting in queue by Power Sharing'
    WAITING_IN_QUEUE_POWER_BOOST = 'Waiting in queue by Power Boost'
    WAITING_MID_FAILED = 'Waiting MID failed'
    WAITING_MID_SAFETY = 'Waiting MID safety margin exceeded'
    WAITING_IN_QUEUE_ECO_SMART = 'Waiting in queue by Eco-Smart'
    UNKNOWN = 'Unknown'
