import asyncio
import voluptuous as vol
from . import data_entry_flow as data_entry_flow, loader as loader
from .components import persistent_notification as persistent_notification
from .components.bluetooth import BluetoothServiceInfoBleak as BluetoothServiceInfoBleak
from .const import CONF_NAME as CONF_NAME, EVENT_HOMEASSISTANT_STARTED as EVENT_HOMEASSISTANT_STARTED, EVENT_HOMEASSISTANT_STOP as EVENT_HOMEASSISTANT_STOP, Platform as Platform
from .core import CALLBACK_TYPE as CALLBACK_TYPE, CoreState as CoreState, Event as Event, HassJob as HassJob, HassJobType as HassJobType, HomeAssistant as HomeAssistant, callback as callback
from .data_entry_flow import FLOW_NOT_COMPLETE_STEPS as FLOW_NOT_COMPLETE_STEPS, FlowContext as FlowContext, FlowResult as FlowResult
from .exceptions import ConfigEntryAuthFailed as ConfigEntryAuthFailed, ConfigEntryError as ConfigEntryError, ConfigEntryNotReady as ConfigEntryNotReady, HomeAssistantError as HomeAssistantError
from .helpers import entity_registry as er, storage as storage
from .helpers.debounce import Debouncer as Debouncer
from .helpers.discovery_flow import DiscoveryKey as DiscoveryKey
from .helpers.dispatcher import SignalType as SignalType, async_dispatcher_send_internal as async_dispatcher_send_internal
from .helpers.event import RANDOM_MICROSECOND_MAX as RANDOM_MICROSECOND_MAX, RANDOM_MICROSECOND_MIN as RANDOM_MICROSECOND_MIN, async_call_later as async_call_later
from .helpers.frame import ReportBehavior as ReportBehavior, report_usage as report_usage
from .helpers.json import json_bytes as json_bytes, json_bytes_sorted as json_bytes_sorted, json_fragment as json_fragment
from .helpers.service_info.dhcp import DhcpServiceInfo as DhcpServiceInfo
from .helpers.service_info.hassio import HassioServiceInfo as HassioServiceInfo
from .helpers.service_info.mqtt import MqttServiceInfo as MqttServiceInfo
from .helpers.service_info.ssdp import SsdpServiceInfo as SsdpServiceInfo
from .helpers.service_info.usb import UsbServiceInfo as UsbServiceInfo
from .helpers.service_info.zeroconf import ZeroconfServiceInfo as ZeroconfServiceInfo
from .helpers.typing import ConfigType as ConfigType, DiscoveryInfoType as DiscoveryInfoType, UNDEFINED as UNDEFINED, UndefinedType as UndefinedType
from .loader import async_suggest_report_issue as async_suggest_report_issue
from .setup import DATA_SETUP_DONE as DATA_SETUP_DONE, SetupPhases as SetupPhases, async_pause_setup as async_pause_setup, async_process_deps_reqs as async_process_deps_reqs, async_setup_component as async_setup_component, async_start_setup as async_start_setup
from .util.async_ import create_eager_task as create_eager_task
from .util.decorator import Registry as Registry
from .util.dt import utc_from_timestamp as utc_from_timestamp, utcnow as utcnow
from .util.enum import try_parse_enum as try_parse_enum
from _typeshed import Incomplete
from collections import UserDict, defaultdict
from collections.abc import Callable, Coroutine, Generator, Iterable, Mapping, ValuesView
from contextvars import ContextVar
from datetime import datetime
from enum import Enum, StrEnum
from functools import cache
from propcache.api import cached_property
from types import MappingProxyType
from typing import Any, Self

_LOGGER: Incomplete
SOURCE_BLUETOOTH: str
SOURCE_DHCP: str
SOURCE_DISCOVERY: str
SOURCE_HARDWARE: str
SOURCE_HASSIO: str
SOURCE_HOMEKIT: str
SOURCE_IMPORT: str
SOURCE_INTEGRATION_DISCOVERY: str
SOURCE_MQTT: str
SOURCE_SSDP: str
SOURCE_SYSTEM: str
SOURCE_USB: str
SOURCE_USER: str
SOURCE_ZEROCONF: str
SOURCE_IGNORE: str
SOURCE_REAUTH: str
SOURCE_RECONFIGURE: str
HANDLERS: Registry[str, type[ConfigFlow]]
STORAGE_KEY: str
STORAGE_VERSION: int
STORAGE_VERSION_MINOR: int
SAVE_DELAY: int
DISCOVERY_COOLDOWN: int
ISSUE_UNIQUE_ID_COLLISION: str
UNIQUE_ID_COLLISION_TITLE_LIMIT: int

class ConfigEntryState(Enum):
    LOADED = ('loaded', True)
    SETUP_ERROR = ('setup_error', True)
    MIGRATION_ERROR = ('migration_error', False)
    SETUP_RETRY = ('setup_retry', True)
    NOT_LOADED = ('not_loaded', True)
    FAILED_UNLOAD = ('failed_unload', False)
    SETUP_IN_PROGRESS = ('setup_in_progress', False)
    _recoverable: bool
    def __new__(cls, value: str, recoverable: bool) -> Self: ...
    @property
    def recoverable(self) -> bool: ...

DEFAULT_DISCOVERY_UNIQUE_ID: str
DISCOVERY_NOTIFICATION_ID: str
DISCOVERY_SOURCES: Incomplete
RECONFIGURE_NOTIFICATION_ID: str
EVENT_FLOW_DISCOVERED: str
SIGNAL_CONFIG_ENTRY_CHANGED: Incomplete

@cache
def signal_discovered_config_entry_removed(discovery_domain: str) -> SignalType[ConfigEntry]: ...

NO_RESET_TRIES_STATES: Incomplete

class ConfigEntryChange(StrEnum):
    ADDED = 'added'
    REMOVED = 'removed'
    UPDATED = 'updated'

class ConfigEntryDisabler(StrEnum):
    USER = 'user'

DISABLED_USER: Incomplete
RELOAD_AFTER_UPDATE_DELAY: int
CONN_CLASS_CLOUD_PUSH: str
CONN_CLASS_CLOUD_POLL: str
CONN_CLASS_LOCAL_PUSH: str
CONN_CLASS_LOCAL_POLL: str
CONN_CLASS_ASSUMED: str
CONN_CLASS_UNKNOWN: str

class ConfigError(HomeAssistantError): ...
class UnknownEntry(ConfigError): ...
class OperationNotAllowed(ConfigError): ...
type UpdateListenerType = Callable[[HomeAssistant, ConfigEntry], Coroutine[Any, Any, None]]

STATE_KEYS: Incomplete
FROZEN_CONFIG_ENTRY_ATTRS: Incomplete
UPDATE_ENTRY_CONFIG_ENTRY_ATTRS: Incomplete

class ConfigFlowContext(FlowContext, total=False):
    alternative_domain: str
    configuration_url: str
    confirm_only: bool
    discovery_key: DiscoveryKey
    entry_id: str
    title_placeholders: Mapping[str, str]
    unique_id: str | None

class ConfigFlowResult(FlowResult[ConfigFlowContext, str], total=False):
    minor_version: int
    options: Mapping[str, Any]
    version: int

def _validate_item(*, disabled_by: ConfigEntryDisabler | Any | None = None) -> None: ...

class ConfigEntry[_DataT = Any]:
    entry_id: str
    domain: str
    title: str
    data: MappingProxyType[str, Any]
    runtime_data: _DataT
    options: MappingProxyType[str, Any]
    unique_id: str | None
    state: ConfigEntryState
    reason: str | None
    error_reason_translation_key: str | None
    error_reason_translation_placeholders: dict[str, Any] | None
    pref_disable_new_entities: bool
    pref_disable_polling: bool
    version: int
    source: str
    minor_version: int
    disabled_by: ConfigEntryDisabler | None
    supports_unload: bool | None
    supports_remove_device: bool | None
    _supports_options: bool | None
    _supports_reconfigure: bool | None
    update_listeners: list[UpdateListenerType]
    _async_cancel_retry_setup: Callable[[], Any] | None
    _on_unload: list[Callable[[], Coroutine[Any, Any, None] | None]] | None
    setup_lock: asyncio.Lock
    _reauth_lock: asyncio.Lock
    _tasks: set[asyncio.Future[Any]]
    _background_tasks: set[asyncio.Future[Any]]
    _integration_for_domain: loader.Integration | None
    _tries: int
    created_at: datetime
    modified_at: datetime
    discovery_keys: MappingProxyType[str, tuple[DiscoveryKey, ...]]
    def __init__(self, *, created_at: datetime | None = None, data: Mapping[str, Any], disabled_by: ConfigEntryDisabler | None = None, discovery_keys: MappingProxyType[str, tuple[DiscoveryKey, ...]], domain: str, entry_id: str | None = None, minor_version: int, modified_at: datetime | None = None, options: Mapping[str, Any] | None, pref_disable_new_entities: bool | None = None, pref_disable_polling: bool | None = None, source: str, state: ConfigEntryState = ..., title: str, unique_id: str | None, version: int) -> None: ...
    def __repr__(self) -> str: ...
    def __setattr__(self, key: str, value: Any) -> None: ...
    @property
    def supports_options(self) -> bool: ...
    @property
    def supports_reconfigure(self) -> bool: ...
    def clear_state_cache(self) -> None: ...
    @cached_property
    def as_json_fragment(self) -> json_fragment: ...
    def clear_storage_cache(self) -> None: ...
    @cached_property
    def as_storage_fragment(self) -> json_fragment: ...
    async def async_setup(self, hass: HomeAssistant, *, integration: loader.Integration | None = None) -> None: ...
    async def __async_setup_with_context(self, hass: HomeAssistant, integration: loader.Integration | None) -> None: ...
    @callback
    def _async_setup_again(self, hass: HomeAssistant, *_: Any) -> None: ...
    async def async_setup_locked(self, hass: HomeAssistant, integration: loader.Integration | None = None) -> None: ...
    @callback
    def async_shutdown(self) -> None: ...
    @callback
    def async_cancel_retry_setup(self) -> None: ...
    async def async_unload(self, hass: HomeAssistant, *, integration: loader.Integration | None = None) -> bool: ...
    async def async_remove(self, hass: HomeAssistant) -> None: ...
    @callback
    def _async_set_state(self, hass: HomeAssistant, state: ConfigEntryState, reason: str | None, error_reason_translation_key: str | None = None, error_reason_translation_placeholders: dict[str, str] | None = None) -> None: ...
    async def async_migrate(self, hass: HomeAssistant) -> bool: ...
    def add_update_listener(self, listener: UpdateListenerType) -> CALLBACK_TYPE: ...
    def as_dict(self) -> dict[str, Any]: ...
    @callback
    def async_on_unload(self, func: Callable[[], Coroutine[Any, Any, None] | None]) -> None: ...
    async def _async_process_on_unload(self, hass: HomeAssistant) -> None: ...
    @callback
    def async_start_reauth(self, hass: HomeAssistant, context: ConfigFlowContext | None = None, data: dict[str, Any] | None = None) -> None: ...
    async def _async_init_reauth(self, hass: HomeAssistant, context: ConfigFlowContext | None = None, data: dict[str, Any] | None = None) -> None: ...
    @callback
    def async_get_active_flows(self, hass: HomeAssistant, sources: set[str]) -> Generator[ConfigFlowResult]: ...
    @callback
    def async_create_task[_R](self, hass: HomeAssistant, target: Coroutine[Any, Any, _R], name: str | None = None, eager_start: bool = True) -> asyncio.Task[_R]: ...
    @callback
    def async_create_background_task[_R](self, hass: HomeAssistant, target: Coroutine[Any, Any, _R], name: str, eager_start: bool = True) -> asyncio.Task[_R]: ...

current_entry: ContextVar[ConfigEntry | None]

class FlowCancelledError(Exception): ...

def _report_non_awaited_platform_forwards(entry: ConfigEntry, what: str) -> None: ...

class ConfigEntriesFlowManager(data_entry_flow.FlowManager[ConfigFlowContext, ConfigFlowResult]):
    _flow_result = ConfigFlowResult
    config_entries: Incomplete
    _hass_config: Incomplete
    _pending_import_flows: defaultdict[str, dict[str, asyncio.Future[None]]]
    _initialize_futures: defaultdict[str, set[asyncio.Future[None]]]
    _discovery_debouncer: Incomplete
    def __init__(self, hass: HomeAssistant, config_entries: ConfigEntries, hass_config: ConfigType) -> None: ...
    async def async_wait_import_flow_initialized(self, handler: str) -> None: ...
    @callback
    def _async_has_other_discovery_flows(self, flow_id: str) -> bool: ...
    async def async_init(self, handler: str, *, context: ConfigFlowContext | None = None, data: Any = None) -> ConfigFlowResult: ...
    async def _async_init(self, flow_id: str, handler: str, context: ConfigFlowContext, data: Any) -> tuple[ConfigFlow, ConfigFlowResult]: ...
    def _set_pending_import_done(self, flow: ConfigFlow) -> None: ...
    @callback
    def async_shutdown(self) -> None: ...
    async def async_finish_flow(self, flow: data_entry_flow.FlowHandler[ConfigFlowContext, ConfigFlowResult], result: ConfigFlowResult) -> ConfigFlowResult: ...
    async def async_create_flow(self, handler_key: str, *, context: ConfigFlowContext | None = None, data: Any = None) -> ConfigFlow: ...
    async def async_post_init(self, flow: data_entry_flow.FlowHandler[ConfigFlowContext, ConfigFlowResult], result: ConfigFlowResult) -> None: ...
    @callback
    def _async_discovery(self) -> None: ...
    @callback
    def async_has_matching_discovery_flow(self, handler: str, match_context: ConfigFlowContext, data: Any) -> bool: ...
    @callback
    def async_has_matching_flow(self, flow: ConfigFlow) -> bool: ...

class ConfigEntryItems(UserDict[str, ConfigEntry]):
    _hass: Incomplete
    _domain_index: dict[str, list[ConfigEntry]]
    _domain_unique_id_index: dict[str, dict[str, list[ConfigEntry]]]
    def __init__(self, hass: HomeAssistant) -> None: ...
    def values(self) -> ValuesView[ConfigEntry]: ...
    def __setitem__(self, entry_id: str, entry: ConfigEntry) -> None: ...
    def check_unique_id(self, entry: ConfigEntry) -> None: ...
    def _index_entry(self, entry: ConfigEntry) -> None: ...
    def _unindex_entry(self, entry_id: str) -> None: ...
    def __delitem__(self, entry_id: str) -> None: ...
    def update_unique_id(self, entry: ConfigEntry, new_unique_id: str | None) -> None: ...
    def get_entries_for_domain(self, domain: str) -> list[ConfigEntry]: ...
    def get_entry_by_domain_and_unique_id(self, domain: str, unique_id: str) -> ConfigEntry | None: ...

class ConfigEntryStore(storage.Store[dict[str, list[dict[str, Any]]]]):
    def __init__(self, hass: HomeAssistant) -> None: ...
    async def _async_migrate_func(self, old_major_version: int, old_minor_version: int, old_data: dict[str, Any]) -> dict[str, Any]: ...

class ConfigEntries:
    hass: Incomplete
    flow: Incomplete
    options: Incomplete
    _hass_config: Incomplete
    _entries: Incomplete
    _store: Incomplete
    def __init__(self, hass: HomeAssistant, hass_config: ConfigType) -> None: ...
    @callback
    def async_domains(self, include_ignore: bool = False, include_disabled: bool = False) -> list[str]: ...
    @callback
    def async_get_entry(self, entry_id: str) -> ConfigEntry | None: ...
    @callback
    def async_get_known_entry(self, entry_id: str) -> ConfigEntry: ...
    @callback
    def async_entry_ids(self) -> list[str]: ...
    @callback
    def async_has_entries(self, domain: str, include_ignore: bool = True, include_disabled: bool = True) -> bool: ...
    @callback
    def async_entries(self, domain: str | None = None, include_ignore: bool = True, include_disabled: bool = True) -> list[ConfigEntry]: ...
    @callback
    def async_loaded_entries(self, domain: str) -> list[ConfigEntry]: ...
    @callback
    def async_entry_for_domain_unique_id(self, domain: str, unique_id: str) -> ConfigEntry | None: ...
    async def async_add(self, entry: ConfigEntry) -> None: ...
    async def async_remove(self, entry_id: str) -> dict[str, Any]: ...
    async def _async_remove(self, entry_id: str) -> tuple[bool, ConfigEntry]: ...
    @callback
    def _async_clean_up(self, entry: ConfigEntry) -> None: ...
    @callback
    def _async_shutdown(self, event: Event) -> None: ...
    async def async_initialize(self) -> None: ...
    async def async_setup(self, entry_id: str, _lock: bool = True) -> bool: ...
    async def async_unload(self, entry_id: str, _lock: bool = True) -> bool: ...
    @callback
    def async_schedule_reload(self, entry_id: str) -> None: ...
    async def async_reload(self, entry_id: str) -> bool: ...
    async def async_set_disabled_by(self, entry_id: str, disabled_by: ConfigEntryDisabler | None) -> bool: ...
    @callback
    def async_update_entry(self, entry: ConfigEntry, *, data: Mapping[str, Any] | UndefinedType = ..., discovery_keys: MappingProxyType[str, tuple[DiscoveryKey, ...]] | UndefinedType = ..., minor_version: int | UndefinedType = ..., options: Mapping[str, Any] | UndefinedType = ..., pref_disable_new_entities: bool | UndefinedType = ..., pref_disable_polling: bool | UndefinedType = ..., title: str | UndefinedType = ..., unique_id: str | None | UndefinedType = ..., version: int | UndefinedType = ...) -> bool: ...
    @callback
    def _async_dispatch(self, change_type: ConfigEntryChange, entry: ConfigEntry) -> None: ...
    async def async_forward_entry_setups(self, entry: ConfigEntry, platforms: Iterable[Platform | str]) -> None: ...
    async def _async_forward_entry_setups_locked(self, entry: ConfigEntry, platforms: Iterable[Platform | str]) -> None: ...
    async def async_forward_entry_setup(self, entry: ConfigEntry, domain: Platform | str) -> bool: ...
    async def _async_forward_entry_setup(self, entry: ConfigEntry, domain: Platform | str, preload_platform: bool) -> bool: ...
    async def async_unload_platforms(self, entry: ConfigEntry, platforms: Iterable[Platform | str]) -> bool: ...
    async def async_forward_entry_unload(self, entry: ConfigEntry, domain: Platform | str) -> bool: ...
    @callback
    def _async_schedule_save(self) -> None: ...
    @callback
    def _data_to_save(self) -> dict[str, list[dict[str, Any]]]: ...
    async def async_wait_component(self, entry: ConfigEntry) -> bool: ...
    @callback
    def async_update_issues(self) -> None: ...

@callback
def _async_abort_entries_match(other_entries: list[ConfigEntry], match_dict: dict[str, Any] | None = None) -> None: ...

class ConfigEntryBaseFlow(data_entry_flow.FlowHandler[ConfigFlowContext, ConfigFlowResult]):
    _flow_result = ConfigFlowResult

class ConfigFlow(ConfigEntryBaseFlow):
    def __init_subclass__(cls, *, domain: str | None = None, **kwargs: Any) -> None: ...
    @property
    def unique_id(self) -> str | None: ...
    @staticmethod
    @callback
    def async_get_options_flow(config_entry: ConfigEntry) -> OptionsFlow: ...
    @classmethod
    @callback
    def async_supports_options_flow(cls, config_entry: ConfigEntry) -> bool: ...
    @callback
    def _async_abort_entries_match(self, match_dict: dict[str, Any] | None = None) -> None: ...
    @callback
    def _abort_if_unique_id_mismatch(self, *, reason: str = 'unique_id_mismatch', description_placeholders: Mapping[str, str] | None = None) -> None: ...
    @callback
    def _abort_if_unique_id_configured(self, updates: dict[str, Any] | None = None, reload_on_update: bool = True, *, error: str = 'already_configured') -> None: ...
    async def async_set_unique_id(self, unique_id: str | None = None, *, raise_on_progress: bool = True) -> ConfigEntry | None: ...
    @callback
    def _set_confirm_only(self) -> None: ...
    @callback
    def _async_current_entries(self, include_ignore: bool | None = None) -> list[ConfigEntry]: ...
    @callback
    def _async_current_ids(self, include_ignore: bool = True) -> set[str | None]: ...
    @callback
    def _async_in_progress(self, include_uninitialized: bool = False, match_context: dict[str, Any] | None = None) -> list[ConfigFlowResult]: ...
    async def async_step_ignore(self, user_input: dict[str, Any]) -> ConfigFlowResult: ...
    async def async_step_user(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def _async_handle_discovery_without_unique_id(self) -> None: ...
    async def _async_step_discovery_without_unique_id(self) -> ConfigFlowResult: ...
    async def async_step_discovery(self, discovery_info: DiscoveryInfoType) -> ConfigFlowResult: ...
    @callback
    def async_abort(self, *, reason: str, description_placeholders: Mapping[str, str] | None = None) -> ConfigFlowResult: ...
    async def async_step_bluetooth(self, discovery_info: BluetoothServiceInfoBleak) -> ConfigFlowResult: ...
    async def async_step_dhcp(self, discovery_info: DhcpServiceInfo) -> ConfigFlowResult: ...
    async def async_step_hassio(self, discovery_info: HassioServiceInfo) -> ConfigFlowResult: ...
    async def async_step_integration_discovery(self, discovery_info: DiscoveryInfoType) -> ConfigFlowResult: ...
    async def async_step_homekit(self, discovery_info: ZeroconfServiceInfo) -> ConfigFlowResult: ...
    async def async_step_mqtt(self, discovery_info: MqttServiceInfo) -> ConfigFlowResult: ...
    async def async_step_ssdp(self, discovery_info: SsdpServiceInfo) -> ConfigFlowResult: ...
    async def async_step_usb(self, discovery_info: UsbServiceInfo) -> ConfigFlowResult: ...
    async def async_step_zeroconf(self, discovery_info: ZeroconfServiceInfo) -> ConfigFlowResult: ...
    @callback
    def async_create_entry(self, *, title: str, data: Mapping[str, Any], description: str | None = None, description_placeholders: Mapping[str, str] | None = None, options: Mapping[str, Any] | None = None) -> ConfigFlowResult: ...
    @callback
    def async_update_reload_and_abort(self, entry: ConfigEntry, *, unique_id: str | None | UndefinedType = ..., title: str | UndefinedType = ..., data: Mapping[str, Any] | UndefinedType = ..., data_updates: Mapping[str, Any] | UndefinedType = ..., options: Mapping[str, Any] | UndefinedType = ..., reason: str | UndefinedType = ..., reload_even_if_entry_is_unchanged: bool = True) -> ConfigFlowResult: ...
    @callback
    def async_show_form(self, *, step_id: str | None = None, data_schema: vol.Schema | None = None, errors: dict[str, str] | None = None, description_placeholders: Mapping[str, str] | None = None, last_step: bool | None = None, preview: str | None = None) -> ConfigFlowResult: ...
    def is_matching(self, other_flow: Self) -> bool: ...
    @property
    def _reauth_entry_id(self) -> str: ...
    @callback
    def _get_reauth_entry(self) -> ConfigEntry: ...
    @property
    def _reconfigure_entry_id(self) -> str: ...
    @callback
    def _get_reconfigure_entry(self) -> ConfigEntry: ...

class OptionsFlowManager(data_entry_flow.FlowManager[ConfigFlowContext, ConfigFlowResult]):
    _flow_result = ConfigFlowResult
    def _async_get_config_entry(self, config_entry_id: str) -> ConfigEntry: ...
    async def async_create_flow(self, handler_key: str, *, context: ConfigFlowContext | None = None, data: dict[str, Any] | None = None) -> OptionsFlow: ...
    async def async_finish_flow(self, flow: data_entry_flow.FlowHandler[ConfigFlowContext, ConfigFlowResult], result: ConfigFlowResult) -> ConfigFlowResult: ...
    async def _async_setup_preview(self, flow: data_entry_flow.FlowHandler[ConfigFlowContext, ConfigFlowResult]) -> None: ...

class OptionsFlow(ConfigEntryBaseFlow):
    handler: str
    _config_entry: ConfigEntry
    @callback
    def _async_abort_entries_match(self, match_dict: dict[str, Any] | None = None) -> None: ...
    @property
    def _config_entry_id(self) -> str: ...
    @property
    def config_entry(self) -> ConfigEntry: ...
    @config_entry.setter
    def config_entry(self, value: ConfigEntry) -> None: ...

class OptionsFlowWithConfigEntry(OptionsFlow):
    _config_entry: Incomplete
    _options: Incomplete
    def __init__(self, config_entry: ConfigEntry) -> None: ...
    @property
    def options(self) -> dict[str, Any]: ...

class EntityRegistryDisabledHandler:
    hass: Incomplete
    registry: er.EntityRegistry | None
    changed: set[str]
    _remove_call_later: Callable[[], None] | None
    def __init__(self, hass: HomeAssistant) -> None: ...
    @callback
    def async_setup(self) -> None: ...
    @callback
    def _handle_entry_updated(self, event: Event[er.EventEntityRegistryUpdatedData]) -> None: ...
    @callback
    def _async_handle_reload(self, _now: Any) -> None: ...

@callback
def _handle_entry_updated_filter(event_data: er.EventEntityRegistryUpdatedData) -> bool: ...
async def support_entry_unload(hass: HomeAssistant, domain: str) -> bool: ...
async def support_remove_from_device(hass: HomeAssistant, domain: str) -> bool: ...
async def _support_single_config_entry_only(hass: HomeAssistant, domain: str) -> bool: ...
async def _load_integration(hass: HomeAssistant, domain: str, hass_config: ConfigType) -> None: ...
async def _async_get_flow_handler(hass: HomeAssistant, domain: str, hass_config: ConfigType) -> type[ConfigFlow]: ...
