import enum
import logging
from _typeshed import Incomplete
from collections.abc import Callable as Callable
from dataclasses import dataclass
from homeassistant.core import HomeAssistant as HomeAssistant, async_get_hass_or_none as async_get_hass_or_none
from homeassistant.exceptions import HomeAssistantError as HomeAssistantError
from homeassistant.loader import Integration as Integration, async_get_issue_integration as async_get_issue_integration, async_suggest_report_issue as async_suggest_report_issue
from propcache.api import cached_property
from types import FrameType

_LOGGER: Incomplete
_REPORTED_INTEGRATIONS: set[str]

@dataclass(kw_only=True)
class IntegrationFrame:
    custom_integration: bool
    integration: str
    module: str | None
    relative_filename: str
    frame: FrameType
    @cached_property
    def line_number(self) -> int: ...
    @cached_property
    def filename(self) -> str: ...
    @cached_property
    def line(self) -> str: ...

def get_integration_logger(fallback_name: str) -> logging.Logger: ...
def get_current_frame(depth: int = 0) -> FrameType: ...
def get_integration_frame(exclude_integrations: set | None = None) -> IntegrationFrame: ...

class MissingIntegrationFrame(HomeAssistantError): ...

def report(what: str, *, exclude_integrations: set[str] | None = None, error_if_core: bool = True, error_if_integration: bool = False, level: int = ..., log_custom_component_only: bool = False) -> None: ...

class ReportBehavior(enum.Enum):
    IGNORE = ...
    LOG = ...
    ERROR = ...

def report_usage(what: str, *, breaks_in_ha_version: str | None = None, core_behavior: ReportBehavior = ..., core_integration_behavior: ReportBehavior = ..., custom_integration_behavior: ReportBehavior = ..., exclude_integrations: set[str] | None = None, integration_domain: str | None = None, level: int = ...) -> None: ...
def _report_integration_domain(hass: HomeAssistant | None, what: str, breaks_in_ha_version: str | None, integration: Integration, core_integration_behavior: ReportBehavior, custom_integration_behavior: ReportBehavior, level: int) -> None: ...
def _report_integration_frame(what: str, breaks_in_ha_version: str | None, integration_frame: IntegrationFrame, level: int = ..., error: bool = False) -> None: ...
def warn_use[_CallableT: Callable](func: _CallableT, what: str) -> _CallableT: ...
def report_non_thread_safe_operation(what: str) -> None: ...
