import asyncio
from _typeshed import Incomplete
from collections.abc import Callable as Callable, Iterable, Mapping, Sequence as Sequence
from homeassistant.const import EVENT_HOMEASSISTANT_FINAL_WRITE as EVENT_HOMEASSISTANT_FINAL_WRITE, EVENT_HOMEASSISTANT_STARTED as EVENT_HOMEASSISTANT_STARTED, EVENT_HOMEASSISTANT_STOP as EVENT_HOMEASSISTANT_STOP
from homeassistant.core import CALLBACK_TYPE as CALLBACK_TYPE, CoreState as CoreState, Event as Event, HomeAssistant as HomeAssistant, callback as callback
from homeassistant.exceptions import HomeAssistantError as HomeAssistantError
from homeassistant.loader import bind_hass as bind_hass
from homeassistant.util import json as json_util
from homeassistant.util.file import WriteError as WriteError
from homeassistant.util.hass_dict import HassKey as HassKey
from json import JSONEncoder
from pathlib import Path
from propcache.api import cached_property
from typing import Any

MAX_LOAD_CONCURRENTLY: int
STORAGE_DIR: str
_LOGGER: Incomplete
STORAGE_SEMAPHORE: HassKey[asyncio.Semaphore]
STORAGE_MANAGER: HassKey[_StoreManager]
MANAGER_CLEANUP_DELAY: int

@bind_hass
async def async_migrator[_T: Mapping[str, Any] | Sequence[Any]](hass: HomeAssistant, old_path: str, store: Store[_T], *, old_conf_load_func: Callable | None = None, old_conf_migrate_func: Callable | None = None) -> _T | None: ...
def get_internal_store_manager(hass: HomeAssistant) -> _StoreManager: ...

class _StoreManager:
    _hass: Incomplete
    _invalidated: set[str]
    _files: set[str] | None
    _data_preload: dict[str, json_util.JsonValueType]
    _storage_path: Path
    _cancel_cleanup: asyncio.TimerHandle | None
    def __init__(self, hass: HomeAssistant) -> None: ...
    async def async_initialize(self) -> None: ...
    @callback
    def async_invalidate(self, key: str) -> None: ...
    @callback
    def async_fetch(self, key: str) -> tuple[bool, json_util.JsonValueType | None] | None: ...
    @callback
    def _async_schedule_cleanup(self, _event: Event) -> None: ...
    @callback
    def _async_cancel_and_cleanup(self, _event: Event) -> None: ...
    @callback
    def _async_cleanup(self) -> None: ...
    async def async_preload(self, keys: Iterable[str]) -> None: ...
    def _preload(self, keys: Iterable[str]) -> None: ...
    def _initialize_files(self) -> None: ...

class Store[_T: Mapping[str, Any] | Sequence[Any]]:
    version: Incomplete
    minor_version: Incomplete
    key: Incomplete
    hass: Incomplete
    _private: Incomplete
    _data: dict[str, Any] | None
    _delay_handle: asyncio.TimerHandle | None
    _unsub_final_write_listener: CALLBACK_TYPE | None
    _write_lock: Incomplete
    _load_future: asyncio.Future[_T | None] | None
    _encoder: Incomplete
    _atomic_writes: Incomplete
    _read_only: Incomplete
    _next_write_time: float
    _manager: Incomplete
    def __init__(self, hass: HomeAssistant, version: int, key: str, private: bool = False, *, atomic_writes: bool = False, encoder: type[JSONEncoder] | None = None, minor_version: int = 1, read_only: bool = False) -> None: ...
    @cached_property
    def path(self): ...
    def make_read_only(self) -> None: ...
    async def async_load(self) -> _T | None: ...
    async def _async_load(self) -> _T | None: ...
    async def _async_load_data(self): ...
    async def async_save(self, data: _T) -> None: ...
    @callback
    def async_delay_save(self, data_func: Callable[[], _T], delay: float = 0) -> None: ...
    @callback
    def _async_reschedule_delayed_write(self, when: float) -> None: ...
    @callback
    def _async_schedule_callback_delayed_write(self) -> None: ...
    @callback
    def _async_ensure_final_write_listener(self) -> None: ...
    @callback
    def _async_cleanup_final_write_listener(self) -> None: ...
    @callback
    def _async_cleanup_delay_listener(self) -> None: ...
    async def _async_callback_delayed_write(self) -> None: ...
    async def _async_callback_final_write(self, _event: Event) -> None: ...
    async def _async_handle_write_data(self, *_args) -> None: ...
    async def _async_write_data(self, path: str, data: dict) -> None: ...
    def _write_data(self, path: str, data: dict) -> None: ...
    async def _async_migrate_func(self, old_major_version, old_minor_version, old_data) -> None: ...
    async def async_remove(self) -> None: ...
