from _typeshed import Incomplete
from homeassistant.exceptions import HomeAssistantError as HomeAssistantError
from os import PathLike
from typing import Any

_SENTINEL: Incomplete
_LOGGER: Incomplete
type JsonValueType = dict[str, JsonValueType] | list[JsonValueType] | str | int | float | bool | None
type JsonArrayType = list[JsonValueType]
type JsonObjectType = dict[str, JsonValueType]
JSON_ENCODE_EXCEPTIONS: Incomplete
JSON_DECODE_EXCEPTIONS: Incomplete

class SerializationError(HomeAssistantError): ...

def json_loads(obj: bytes | bytearray | memoryview | str, /) -> JsonValueType: ...
def json_loads_array(obj: bytes | bytearray | memoryview | str, /) -> JsonArrayType: ...
def json_loads_object(obj: bytes | bytearray | memoryview | str, /) -> JsonObjectType: ...
def load_json(filename: str | PathLike[str], default: JsonValueType = ...) -> JsonValueType: ...
def load_json_array(filename: str | PathLike[str], default: JsonArrayType = ...) -> JsonArrayType: ...
def load_json_object(filename: str | PathLike[str], default: JsonObjectType = ...) -> JsonObjectType: ...
def format_unserializable_data(data: dict[str, Any]) -> str: ...
