import os
import yaml
from .const import SECRET_YAML as SECRET_YAML
from .objects import Input as Input, NodeDictClass as NodeDictClass, NodeListClass as NodeListClass, NodeStrClass as NodeStrClass
from _typeshed import Incomplete
from collections.abc import Callable as Callable, Iterator
from homeassistant.exceptions import HomeAssistantError as HomeAssistantError
from io import StringIO
from pathlib import Path
from propcache.api import cached_property
from typing import Any, TextIO, overload
from yaml import SafeLoader as FastestAvailableSafeLoader

HAS_C_LOADER: bool
JSON_TYPE = list | dict | str
_LOGGER: Incomplete

class YamlTypeError(HomeAssistantError): ...

class Secrets:
    config_dir: Incomplete
    _cache: dict[Path, dict[str, str]]
    def __init__(self, config_dir: Path) -> None: ...
    def get(self, requester_path: str, secret: str) -> str: ...
    def _load_secret_yaml(self, secret_dir: Path) -> dict[str, str]: ...

class _LoaderMixin:
    name: str
    stream: Any
    @cached_property
    def get_name(self) -> str: ...
    @cached_property
    def get_stream_name(self) -> str: ...

class FastSafeLoader(FastestAvailableSafeLoader, _LoaderMixin):
    stream: Incomplete
    name: str
    secrets: Incomplete
    def __init__(self, stream: Any, secrets: Secrets | None = None) -> None: ...

class PythonSafeLoader(yaml.SafeLoader, _LoaderMixin):
    secrets: Incomplete
    def __init__(self, stream: Any, secrets: Secrets | None = None) -> None: ...
type LoaderType = FastSafeLoader | PythonSafeLoader

def load_yaml(fname: str | os.PathLike[str], secrets: Secrets | None = None) -> JSON_TYPE | None: ...
def load_yaml_dict(fname: str | os.PathLike[str], secrets: Secrets | None = None) -> dict: ...
def parse_yaml(content: str | TextIO | StringIO, secrets: Secrets | None = None) -> JSON_TYPE: ...
def _parse_yaml_python(content: str | TextIO | StringIO, secrets: Secrets | None = None) -> JSON_TYPE: ...
def _parse_yaml(loader: type[FastSafeLoader | PythonSafeLoader], content: str | TextIO, secrets: Secrets | None = None) -> JSON_TYPE: ...
@overload
def _add_reference(obj: list | NodeListClass, loader: LoaderType, node: yaml.nodes.Node) -> NodeListClass: ...
@overload
def _add_reference(obj: str | NodeStrClass, loader: LoaderType, node: yaml.nodes.Node) -> NodeStrClass: ...
@overload
def _add_reference(obj: dict | NodeDictClass, loader: LoaderType, node: yaml.nodes.Node) -> NodeDictClass: ...
@overload
def _add_reference_to_node_class(obj: NodeListClass, loader: LoaderType, node: yaml.nodes.Node) -> NodeListClass: ...
@overload
def _add_reference_to_node_class(obj: NodeStrClass, loader: LoaderType, node: yaml.nodes.Node) -> NodeStrClass: ...
@overload
def _add_reference_to_node_class(obj: NodeDictClass, loader: LoaderType, node: yaml.nodes.Node) -> NodeDictClass: ...
def _raise_if_no_value[NodeT: yaml.nodes.Node, _R](func: Callable[[LoaderType, NodeT], _R]) -> Callable[[LoaderType, NodeT], _R]: ...
@_raise_if_no_value
def _include_yaml(loader: LoaderType, node: yaml.nodes.Node) -> JSON_TYPE: ...
def _is_file_valid(name: str) -> bool: ...
def _find_files(directory: str, pattern: str) -> Iterator[str]: ...
@_raise_if_no_value
def _include_dir_named_yaml(loader: LoaderType, node: yaml.nodes.Node) -> NodeDictClass: ...
@_raise_if_no_value
def _include_dir_merge_named_yaml(loader: LoaderType, node: yaml.nodes.Node) -> NodeDictClass: ...
@_raise_if_no_value
def _include_dir_list_yaml(loader: LoaderType, node: yaml.nodes.Node) -> list[JSON_TYPE]: ...
@_raise_if_no_value
def _include_dir_merge_list_yaml(loader: LoaderType, node: yaml.nodes.Node) -> JSON_TYPE: ...
def _handle_mapping_tag(loader: LoaderType, node: yaml.nodes.MappingNode) -> NodeDictClass: ...
def _construct_seq(loader: LoaderType, node: yaml.nodes.Node) -> JSON_TYPE: ...
def _handle_scalar_tag(loader: LoaderType, node: yaml.nodes.ScalarNode) -> str | int | float | None: ...
def _env_var_yaml(loader: LoaderType, node: yaml.nodes.Node) -> str: ...
def secret_yaml(loader: LoaderType, node: yaml.nodes.Node) -> JSON_TYPE: ...
def add_constructor(tag: Any, constructor: Any) -> None: ...
