# Technical Stack

## Programming Languages
- **Primary**: [LANGUAGE] [VERSION]
- **Secondary**: [LANGUAGE] [VERSION]

## Frontend Framework
- **Framework**: [REACT|VUE|ANGULAR] [VERSION]
- **State Management**: [REDUX|CONTEXT|PINIA]
- **CSS Framework**: [TAILWIND|BOOTSTRAP|STYLED] [VERSION]
- **Component Library**: [LIBRARY_NAME]

## Backend Framework
- **Framework**: [EXPRESS|LARAVEL|DJANGO] [VERSION]
- **API Style**: [REST|GRAPHQL|RPC]
- **Authentication**: [JWT|OAUTH|PASSPORT]
- **Validation**: [LIBRARY_NAME]

## Database
- **Primary Database**: [POSTGRESQL|MYSQL|MONGODB] [VERSION]
- **ORM/ODM**: [PRISMA|ELOQUENT|MONGOOSE]
- **Caching**: [REDIS|MEMCACHED] [VERSION]
- **Search**: [ELASTICSEARCH|ALGOLIA] (if applicable)

## Development Tools
- **Package Manager**: [NPM|YARN|PNPM] [VERSION]
- **Build Tool**: [VITE|WEBPACK|ROLLUP]
- **Linting**: [ESLINT|PRETTIER] 
- **Testing**: [JEST|VITEST|CYPRESS]

## Infrastructure
- **Application Hosting**: [VERCEL|HEROKU|AWS]
- **Database Hosting**: [PLANETSCALE|RDS|ATLAS]
- **Asset Storage**: [S3|CLOUDINARY|CDN]
- **Domain & DNS**: [CLOUDFLARE|ROUTE53]

## CI/CD & Deployment
- **Repository**: [GITHUB|GITLAB] 
- **CI/CD**: [GITHUB_ACTIONS|GITLAB_CI]
- **Deployment**: [AUTOMATIC|MANUAL]
- **Environment Management**: [STAGING|PRODUCTION]

## Monitoring & Analytics
- **Error Tracking**: [SENTRY|ROLLBAR]
- **Analytics**: [GOOGLE_ANALYTICS|POSTHOG]
- **Performance**: [NEW_RELIC|DATADOG] (if needed)

## Technology Rationale
### Frontend Decisions
- **Framework Choice**: [SELECTED_FRONTEND]
  - **Reason**: [EXPERT_JUSTIFICATION]
  - **Alternatives Considered**: [REJECTED_OPTIONS]
  - **Trade-offs**: [BENEFITS_VS_COSTS]

### Backend Decisions
- **Framework Choice**: [SELECTED_BACKEND]
  - **Reason**: [EXPERT_JUSTIFICATION] 
  - **Alternatives Considered**: [REJECTED_OPTIONS]
  - **Trade-offs**: [BENEFITS_VS_COSTS]

### Database Decisions
- **Database Choice**: [SELECTED_DATABASE]
  - **Reason**: [EXPERT_JUSTIFICATION]
  - **Alternatives Considered**: [REJECTED_OPTIONS]
  - **Trade-offs**: [BENEFITS_VS_COSTS]

## Security & Compliance
- **SSL/TLS**: Automatic via hosting platform
- **Environment Variables**: Secure storage
- **API Rate Limiting**: [RATE_LIMITER]
- **CORS Configuration**: Appropriate origins