/*
 * Copyright 2007 Project RELIC
 *
 * This file is part of RELIC. RELIC is legal property of its developers,
 * whose names are not listed here. Please refer to the COPYRIGHT file.
 *
 * RELIC is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * RELIC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with RELIC. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @file
 *
 * Implementation of the low-level binary field bit shifting functions.
 *
 * @ingroup bn
 */

#include "relic_fp_low.h"

//.arch atmega128

/*============================================================================*/
/* Public definitions                                                         */
/*============================================================================*/

.text

.global fp_rdci_low

.macro PROLOGUE
	.irp i, 0, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 28, 29, 30, 31
		push 	\i
	.endr
.endm

.macro EPILOGUE
	.irp i, 31, 30, 29, 28, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 0
		pop 	\i
	.endr
	ret
.endm

fp_rdci_low:
	PROLOGUE

	movw r30,r24
	movw r28,r22

	ldi	r26, 9
	ldi	r27, 0xC7
	clr	r2
	clr	r23
	clr	r24
	clr	r25

	ldd	r23, Y+0
	mul	r23, r26
	mov	r3, r0
	mul	r0, r27
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	clr	r23

	ldi	r22, 0x35
	mul r3, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldd	r22, Y+1
	add	r24, r22
	adc	r25, r2
	adc	r23, r2
	mul	r24, r26
	mov	r4, r0
	mul	r0, r27
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	clr	r24

	ldi	r22, 0xA0
	mul r3, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0x35
	mul r4, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldd	r22, Y+2
	add	r25, r22
	adc	r23, r2
	adc	r24, r2
	mul	r25, r26
	mov	r5, r0
	mul	r0, r27
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	clr	r25

	ldi	r22, 0x0C
	mul r3, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0xA0
	mul r4, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0x35
	mul r5, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldd	r22, Y+3
	add	r23, r22
	adc	r24, r2
	adc	r25, r2
	mul	r23, r26
	mov	r6, r0
	mul	r0, r27
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	clr	r23

	ldi	r22, 0x80
	mul r3, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0x0C
	mul r4, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0xA0
	mul r5, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0x35
	mul r6, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldd	r22, Y+4
	add	r24, r22
	adc	r25, r2
	adc	r23, r2
	mul	r24, r26
	mov	r7, r0
	mul	r0, r27
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	clr	r24

	ldi	r22, 0xEC
	mul r3, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0x80
	mul r4, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0x0C
	mul r5, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0xA0
	mul r6, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0x35
	mul r7, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldd	r22, Y+5
	add	r25, r22
	adc	r23, r2
	adc	r24, r2
	mul	r25, r26
	mov	r8, r0
	mul	r0, r27
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	clr	r25

	ldi	r22, 0x9F
	mul r3, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0xEC
	mul r4, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0x80
	mul r5, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0x0C
	mul r6, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0xA0
	mul r7, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0x35
	mul r8, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldd	r22, Y+6
	add	r23, r22
	adc	r24, r2
	adc	r25, r2
	mul	r23, r26
	mov	r9, r0
	mul	r0, r27
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	clr	r23

	ldi	r22, 0x41
	mul r3, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0x9F
	mul r4, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0xEC
	mul r5, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0x80
	mul r6, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0x0C
	mul r7, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0xA0
	mul r8, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0x35
	mul r9, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldd	r22, Y+7
	add	r24, r22
	adc	r25, r2
	adc	r23, r2
	mul	r24, r26
	mov	r10, r0
	mul	r0, r27
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	clr	r24

	ldi	r22, 0x41
	mul r4, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0x9F
	mul r5, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0xEC
	mul r6, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0x80
	mul r7, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0x0C
	mul r8, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0xA0
	mul r9, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0x35
	mul r10, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldd	r22, Y+8
	add	r25, r22
	adc	r23, r2
	adc	r24, r2
	mul	r25, r26
	mov	r11, r0
	mul	r0, r27
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	clr	r25

	ldi	r22, 0xC0
	mul r3, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0x41
	mul r5, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0x9F
	mul r6, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0xEC
	mul r7, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0x80
	mul r8, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0x0C
	mul r9, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0xA0
	mul r10, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0x35
	mul r11, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldd	r22, Y+9
	add	r23, r22
	adc	r24, r2
	adc	r25, r2
	mul	r23, r26
	mov	r12, r0
	mul	r0, r27
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	clr	r23

	ldi	r22, 0xE9
	mul r3, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0xC0
	mul r4, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0x41
	mul r6, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0x9F
	mul r7, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0xEC
	mul r8, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0x80
	mul r9, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0x0C
	mul r10, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0xA0
	mul r11, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0x35
	mul r12, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldd	r22, Y+10
	add	r24, r22
	adc	r25, r2
	adc	r23, r2
	mul	r24, r26
	mov	r13, r0
	mul	r0, r27
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	clr	r24

	ldi	r22, 0x7F
	mul r3, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0xE9
	mul r4, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0xC0
	mul r5, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0x41
	mul r7, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0x9F
	mul r8, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0xEC
	mul r9, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0x80
	mul r10, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0x0C
	mul r11, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0xA0
	mul r12, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0x35
	mul r13, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldd	r22, Y+11
	add	r25, r22
	adc	r23, r2
	adc	r24, r2
	mul	r25, r26
	mov	r14, r0
	mul	r0, r27
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	clr	r25

	ldi	r22, 0x7F
	mul r4, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0xE9
	mul r5, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0xC0
	mul r6, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0x41
	mul r8, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0x9F
	mul r9, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0xEC
	mul r10, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0x80
	mul r11, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0x0C
	mul r12, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0xA0
	mul r13, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0x35
	mul r14, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldd	r22, Y+12
	add	r23, r22
	adc	r24, r2
	adc	r25, r2
	mul	r23, r26
	mov	r15, r0
	mul	r0, r27
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	clr	r23

	ldi	r22, 0x7F
	mul r5, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0xE9
	mul r6, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0xC0
	mul r7, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0x41
	mul r9, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0x9F
	mul r10, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0xEC
	mul r11, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0x80
	mul r12, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0x0C
	mul r13, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0xA0
	mul r14, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0x35
	mul r15, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldd	r22, Y+13
	add	r24, r22
	adc	r25, r2
	adc	r23, r2
	mul	r24, r26
	mov	r16, r0
	mul	r0, r27
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	clr	r24

	ldi	r22, 0xD0
	mul r3, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0x7F
	mul r6, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0xE9
	mul r7, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0xC0
	mul r8, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0x41
	mul r10, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0x9F
	mul r11, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0xEC
	mul r12, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0x80
	mul r13, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0x0C
	mul r14, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0xA0
	mul r15, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0x35
	mul r16, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldd	r22, Y+14
	add	r25, r22
	adc	r23, r2
	adc	r24, r2
	mul	r25, r26
	mov	r17, r0
	mul	r0, r27
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	clr	r25

	ldi	r22, 0x6E
	mul r3, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0xD0
	mul r4, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0x7F
	mul r7, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0xE9
	mul r8, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0xC0
	mul r9, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0x41
	mul r11, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0x9F
	mul r12, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0xEC
	mul r13, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0x80
	mul r14, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0x0C
	mul r15, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0xA0
	mul r16, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0x35
	mul r17, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldd	r22, Y+15
	add	r23, r22
	adc	r24, r2
	adc	r25, r2
	mul	r23, r26
	mov	r18, r0
	mul	r0, r27
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	clr	r23

	ldi	r22, 0x6E
	mul r4, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0xD0
	mul r5, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0x7F
	mul r8, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0xE9
	mul r9, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0xC0
	mul r10, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0x41
	mul r12, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0x9F
	mul r13, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0xEC
	mul r14, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0x80
	mul r15, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0x0C
	mul r16, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0xA0
	mul r17, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0x35
	mul r18, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldd	r22, Y+16
	add	r24, r22
	adc	r25, r2
	adc	r23, r2
	mul	r24, r26
	mov	r19, r0
	mul	r0, r27
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	clr	r24

	ldi	r22, 0x6E
	mul r5, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0xD0
	mul r6, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0x7F
	mul r9, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0xE9
	mul r10, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0xC0
	mul r11, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0x41
	mul r13, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0x9F
	mul r14, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0xEC
	mul r15, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0x80
	mul r16, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0x0C
	mul r17, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0xA0
	mul r18, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0x35
	mul r19, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldd	r22, Y+17
	add	r25, r22
	adc	r23, r2
	adc	r24, r2
	mul	r25, r26
	mov	r20, r0
	mul	r0, r27
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	clr	r25

	ldi	r22, 0x6E
	mul r6, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0xD0
	mul r7, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0x7F
	mul r10, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0xE9
	mul r11, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0xC0
	mul r12, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0x41
	mul r14, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0x9F
	mul r15, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0xEC
	mul r16, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0x80
	mul r17, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0x0C
	mul r18, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0xA0
	mul r19, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0x35
	mul r20, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldd	r22, Y+18
	add	r23, r22
	adc	r24, r2
	adc	r25, r2
	mul	r23, r26
	mov	r21, r0
	mul	r0, r27
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	clr	r23

	ldi	r22, 0x24
	mul r3, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0x6E
	mul r7, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0xD0
	mul r8, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0x7F
	mul r11, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0xE9
	mul r12, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0xC0
	mul r13, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0x41
	mul r15, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0x9F
	mul r16, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0xEC
	mul r17, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0x80
	mul r18, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0x0C
	mul r19, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0xA0
	mul r20, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0x35
	mul r21, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldd	r22, Y+19
	add	r24, r22
	adc	r25, r2
	adc	r23, r2
	mul	r24, r26
	mov	r3, r0
	mul	r0, r27
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	clr	r24

	ldi	r22, 0x24
	mul r4, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0x6E
	mul r8, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0xD0
	mul r9, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0x7F
	mul r12, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0xE9
	mul r13, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0xC0
	mul r14, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0x41
	mul r16, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0x9F
	mul r17, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0xEC
	mul r18, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0x80
	mul r19, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0x0C
	mul r20, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0xA0
	mul r21, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0x35
	mul r3, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldd	r22, Y+20
	add	r25, r22
	adc	r23, r2
	adc	r24, r2
	std Z+0,r25
	clr	r25

	ldi	r22, 0x24
	mul r5, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0x6E
	mul r9, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0xD0
	mul r10, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0x7F
	mul r13, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0xE9
	mul r14, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0xC0
	mul r15, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0x41
	mul r17, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0x9F
	mul r18, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0xEC
	mul r19, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0x80
	mul r20, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0x0C
	mul r21, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0xA0
	mul r3, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldd	r22, Y+21
	add	r23, r22
	adc	r24, r2
	adc	r25, r2
	std Z+1,r23
	clr	r23

	ldi	r22, 0x24
	mul r6, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0x6E
	mul r10, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0xD0
	mul r11, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0x7F
	mul r14, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0xE9
	mul r15, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0xC0
	mul r16, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0x41
	mul r18, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0x9F
	mul r19, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0xEC
	mul r20, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0x80
	mul r21, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0x0C
	mul r3, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldd	r22, Y+22
	add	r24, r22
	adc	r25, r2
	adc	r23, r2
	std Z+2,r24
	clr	r24

	ldi	r22, 0x24
	mul r7, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0x6E
	mul r11, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0xD0
	mul r12, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0x7F
	mul r15, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0xE9
	mul r16, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0xC0
	mul r17, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0x41
	mul r19, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0x9F
	mul r20, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0xEC
	mul r21, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0x80
	mul r3, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldd	r22, Y+23
	add	r25, r22
	adc	r23, r2
	adc	r24, r2
	std Z+3,r25
	clr	r25

	ldi	r22, 0x24
	mul r8, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0x6E
	mul r12, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0xD0
	mul r13, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0x7F
	mul r16, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0xE9
	mul r17, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0xC0
	mul r18, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0x41
	mul r20, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0x9F
	mul r21, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0xEC
	mul r3, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldd	r22, Y+24
	add	r23, r22
	adc	r24, r2
	adc	r25, r2
	std Z+4,r23
	clr	r23

	ldi	r22, 0x24
	mul r9, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0x6E
	mul r13, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0xD0
	mul r14, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0x7F
	mul r17, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0xE9
	mul r18, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0xC0
	mul r19, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0x41
	mul r21, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0x9F
	mul r3, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldd	r22, Y+25
	add	r24, r22
	adc	r25, r2
	adc	r23, r2
	std Z+5,r24
	clr	r24

	ldi	r22, 0x24
	mul r10, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0x6E
	mul r14, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0xD0
	mul r15, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0x7F
	mul r18, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0xE9
	mul r19, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0xC0
	mul r20, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0x41
	mul r3, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldd	r22, Y+26
	add	r25, r22
	adc	r23, r2
	adc	r24, r2
	std Z+6,r25
	clr	r25

	ldi	r22, 0x24
	mul r11, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0x6E
	mul r15, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0xD0
	mul r16, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0x7F
	mul r19, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0xE9
	mul r20, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0xC0
	mul r21, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldd	r22, Y+27
	add	r23, r22
	adc	r24, r2
	adc	r25, r2
	std Z+7,r23
	clr	r23

	ldi	r22, 0x24
	mul r12, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0x6E
	mul r16, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0xD0
	mul r17, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0x7F
	mul r20, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0xE9
	mul r21, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0xC0
	mul r3, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldd	r22, Y+28
	add	r24, r22
	adc	r25, r2
	adc	r23, r2
	std Z+8,r24
	clr	r24

	ldi	r22, 0x24
	mul r13, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0x6E
	mul r17, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0xD0
	mul r18, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0x7F
	mul r21, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0xE9
	mul r3, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldd	r22, Y+29
	add	r25, r22
	adc	r23, r2
	adc	r24, r2
	std Z+9,r25
	clr	r25

	ldi	r22, 0x24
	mul r14, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0x6E
	mul r18, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0xD0
	mul r19, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0x7F
	mul r3, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldd	r22, Y+30
	add	r23, r22
	adc	r24, r2
	adc	r25, r2
	std Z+10,r23
	clr	r23

	ldi	r22, 0x24
	mul r15, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0x6E
	mul r19, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0xD0
	mul r20, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldd	r22, Y+31
	add	r24, r22
	adc	r25, r2
	adc	r23, r2
	std Z+11,r24
	clr	r24

	ldi	r22, 0x24
	mul r16, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0x6E
	mul r20, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldi	r22, 0xD0
	mul r21, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldd	r22, Y+32
	add	r25, r22
	adc	r23, r2
	adc	r24, r2
	std Z+12,r25
	clr	r25

	ldi	r22, 0x24
	mul r17, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0x6E
	mul r21, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldi	r22, 0xD0
	mul r3, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldd	r22, Y+33
	add	r23, r22
	adc	r24, r2
	adc	r25, r2
	std Z+13,r23
	clr	r23

	ldi	r22, 0x24
	mul r18, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldi	r22, 0x6E
	mul r3, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldd	r22, Y+34
	add	r24, r22
	adc	r25, r2
	adc	r23, r2
	std Z+14,r24
	clr	r24

	ldi	r22, 0x24
	mul r19, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldd	r22, Y+35
	add	r25, r22
	adc	r23, r2
	adc	r24, r2
	std Z+15,r25
	clr	r25

	ldi	r22, 0x24
	mul r20, r22
	add	r23, r0
	adc	r24, r1
	adc	r25, r2
	ldd	r22, Y+36
	add	r23, r22
	adc	r24, r2
	adc	r25, r2
	std Z+16,r23
	clr	r23

	ldi	r22, 0x24
	mul r21, r22
	add	r24, r0
	adc	r25, r1
	adc	r23, r2
	ldd	r22, Y+37
	add	r24, r22
	adc	r25, r2
	adc	r23, r2
	std Z+17,r24
	clr	r24

	ldi	r22, 0x24
	mul r3, r22
	add	r25, r0
	adc	r23, r1
	adc	r24, r2
	ldd	r22, Y+38
	add	r25, r22
	adc	r23, r2
	adc	r24, r2
	std Z+18,r25
	clr	r25

	ldd	r22, Y+39
	add	r23, r22
	adc	r24, r2
	adc	r25, r2
	std Z+19,r23
	clr	r23

	clr r1
	EPILOGUE
	ret

