"""
iztro-py  /:

U:U(
 +po
"""

import sys
import os
sys.path.insert(0, os.path.abspath(os.path.join(os.path.dirname(__file__), '../src')))

from iztro_py import astro
from iztro_py.i18n import set_language

# ============================================================
# : 1ؤ-
# ============================================================
print("=" * 60)
print(": 1ؤ-")
print("=" * 60)

chart_zh = astro.by_solar('2000-8-16', 6, '7', language='zh-CN')
soul_palace = chart_zh.get_soul_palace()

print(f"M
: {soul_palace.translate_name()}")
print(f")r0/: {soul_palace.translate_heavenly_stem()} {soul_palace.translate_earthly_branch()}")

if soul_palace.major_stars:
    print(f";:")
    for star in soul_palace.major_stars:
        brightness = star.translate_brightness() or ''
        mutagen = star.mutagen or ''
        print(f"  {star.translate_name()} - :{brightness} :{mutagen}")
print()


# ============================================================
# : 2
# ============================================================
print("=" * 60)
print(": 2 (Example 2: English Output)")
print("=" * 60)

chart_en = astro.by_solar('2000-8-16', 6, '7', language='en-US')
soul_palace_en = chart_en.get_soul_palace()

print(f"Palace Name: {soul_palace_en.translate_name('en-US')}")
print(f"Stem & Branch: {soul_palace_en.translate_heavenly_stem('en-US')} {soul_palace_en.translate_earthly_branch('en-US')}")

if soul_palace_en.major_stars:
    print(f"Major Stars:")
    for star in soul_palace_en.major_stars:
        brightness = star.translate_brightness('en-US') or 'None'
        mutagen = star.mutagen or 'None'
        print(f"  {star.translate_name('en-US')} - Brightness:{brightness} Mutagen:{mutagen}")
print()


# ============================================================
# : 3釓
# ============================================================
print("=" * 60)
print("@ 3: \m % (Example 3: Korean Output)")
print("=" * 60)

chart_ko = astro.by_solar('2000-8-16', 6, '', language='ko-KR')
soul_palace_ko = chart_ko.get_soul_palace()

print(f" t: {soul_palace_ko.translate_name('ko-KR')}")
print(f": {soul_palace_ko.translate_heavenly_stem('ko-KR')} {soul_palace_ko.translate_earthly_branch('ko-KR')}")

if soul_palace_ko.major_stars:
    print(f"1:")
    for star in soul_palace_ko.major_stars:
        brightness = star.translate_brightness('ko-KR') or '4'
        mutagen = star.mutagen or '4'
        print(f"  {star.translate_name('ko-KR')} - 0:{brightness} T:{mutagen}")
print()


# ============================================================
# : 4b 
# ============================================================
print("=" * 60)
print(": 4b ")
print("=" * 60)

chart = astro.by_solar('2000-8-16', 6, '7', language='zh-CN')

# +
ziwei = chart.star('ziweiMaj')
if ziwei:
    print(f"-: {ziwei.translate_name('zh-CN')}")
    print(f"English: {ziwei.translate_name('en-US')}")
    print(f"\m: {ziwei.translate_name('ko-KR')}")
print()


# ============================================================
# : 5yѫM
# ============================================================
print("=" * 60)
print(": 5y@	M")
print("=" * 60)

print("\n- (Chinese):")
for i in range(12):
    palace = chart.palace(i)
    if palace:
        print(f"{i:2d}. {palace.translate_name('zh-CN')}")

print("\nEnglish:")
for i in range(12):
    palace = chart.palace(i)
    if palace:
        print(f"{i:2d}. {palace.translate_name('en-US')}")

print("\n\m (Korean):")
for i in range(12):
    palace = chart.palace(i)
    if palace:
        print(f"{i:2d}. {palace.translate_name('ko-KR')}")

print()
print("=" * 60)
print(" :")
print("=" * 60)
