"""
Data module: Core data definitions including types, constants, and reference data.
"""

from iztro_py.data import types, constants, heavenly_stems, earthly_branches

from iztro_py.data.types import (
    Language,
    YinYang,
    FiveElements,
    GenderName,
    Mutagen,
    Brightness,
    Scope,
    StarType,
    ChineseTime,
    HeavenlyStemName,
    EarthlyBranchName,
    PalaceName,
    StarName,
    MajorStarName,
    MinorStarName,
    AdjectiveStarName,
    FiveElementsClass,
    Star,
    Decadal,
    Palace,
    SoulAndBody,
    LunarDate,
    HeavenlyStemAndEarthlyBranchDate,
    Astrolabe,
    SurroundedPalaces,
    HoroscopeItem,
    Horoscope,
    Config,
    AstrolabeOptions,
)

from iztro_py.data.constants import (
    CHINESE_TIME,
    TIME_RANGE,
    HEAVENLY_STEMS,
    EARTHLY_BRANCHES,
    PALACES,
    MAJOR_STARS,
    MINOR_STARS,
    MUTAGEN,
    ZIWEI_GROUP,
    TIANFU_GROUP,
    TIGER_RULE,
    RAT_RULE,
    FIVE_ELEMENTS_CLASS_LOOKUP,
    ZIWEI_START_POSITIONS,
    fix_index,
    get_opposite_index,
    get_surrounded_indices,
)

from iztro_py.data.heavenly_stems import (
    HEAVENLY_STEMS_CONFIG,
    get_mutagen,
    get_mutagen_type,
)

from iztro_py.data.earthly_branches import (
    EARTHLY_BRANCHES_CONFIG,
    get_soul_star,
    get_body_star,
)

__all__ = [
    # Submodules
    'types',
    'constants',
    'heavenly_stems',
    'earthly_branches',
    # Type exports
    'Language',
    'YinYang',
    'FiveElements',
    'GenderName',
    'Mutagen',
    'Brightness',
    'Scope',
    'StarType',
    'ChineseTime',
    'HeavenlyStemName',
    'EarthlyBranchName',
    'PalaceName',
    'StarName',
    'MajorStarName',
    'MinorStarName',
    'AdjectiveStarName',
    'FiveElementsClass',
    'Star',
    'Decadal',
    'Palace',
    'SoulAndBody',
    'LunarDate',
    'HeavenlyStemAndEarthlyBranchDate',
    'Astrolabe',
    'SurroundedPalaces',
    'HoroscopeItem',
    'Horoscope',
    'Config',
    'AstrolabeOptions',
    # Constants
    'CHINESE_TIME',
    'TIME_RANGE',
    'HEAVENLY_STEMS',
    'EARTHLY_BRANCHES',
    'PALACES',
    'MAJOR_STARS',
    'MINOR_STARS',
    'MUTAGEN',
    'ZIWEI_GROUP',
    'TIANFU_GROUP',
    'TIGER_RULE',
    'RAT_RULE',
    'FIVE_ELEMENTS_CLASS_LOOKUP',
    'ZIWEI_START_POSITIONS',
    'fix_index',
    'get_opposite_index',
    'get_surrounded_indices',
    # Heavenly Stems
    'HEAVENLY_STEMS_CONFIG',
    'get_mutagen',
    'get_mutagen_type',
    # Earthly Branches
    'EARTHLY_BRANCHES_CONFIG',
    'get_soul_star',
    'get_body_star',
]
