# Generated by Django 4.2.11 on 2024-10-21 21:42

# Django
import django.core.validators
import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("eveonline", "0017_alliance_and_corp_names_are_not_unique"),
        ("eveuniverse", "0010_alter_eveindustryactivityduration_eve_type_and_more"),
    ]

    operations = [
        migrations.CreateModel(
            name="General",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
            ],
            options={
                "permissions": (
                    ("basic_access", "Can access this app, Skillfarm."),
                    ("corp_access", "Has access to all characters in the corporation."),
                    ("admin_access", "Has access to all characters."),
                ),
                "managed": False,
                "default_permissions": (),
            },
        ),
        migrations.CreateModel(
            name="SkillFarmAudit",
            fields=[
                ("id", models.AutoField(primary_key=True, serialize=False)),
                ("active", models.BooleanField(default=True)),
                ("notification", models.BooleanField(default=False)),
                (
                    "last_update_skills",
                    models.DateTimeField(blank=True, default=None, null=True),
                ),
                (
                    "last_update_skillqueue",
                    models.DateTimeField(blank=True, default=None, null=True),
                ),
                (
                    "character",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="skillfarm_character",
                        to="eveonline.evecharacter",
                    ),
                ),
            ],
            options={
                "default_permissions": (),
            },
        ),
        migrations.CreateModel(
            name="SkillFarmSetup",
            fields=[
                ("id", models.AutoField(primary_key=True, serialize=False)),
                ("skillset", models.JSONField(blank=True, default=dict, null=True)),
                (
                    "character",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="skillfarm_setup",
                        to="skillfarm.skillfarmaudit",
                    ),
                ),
            ],
            options={
                "default_permissions": (),
            },
        ),
        migrations.CreateModel(
            name="SkillFarmNotification",
            fields=[
                ("id", models.AutoField(primary_key=True, serialize=False)),
                ("message", models.TextField()),
                ("timestamp", models.DateTimeField(auto_now_add=True)),
                (
                    "character",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="skillfarm_notification",
                        to="skillfarm.skillfarmaudit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Skillfarm Notification",
                "verbose_name_plural": "Skillfarm Notifications",
                "ordering": ["-timestamp"],
                "default_permissions": (),
            },
        ),
        migrations.CreateModel(
            name="CharacterSkillqueueEntry",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("queue_position", models.PositiveIntegerField(db_index=True)),
                ("finish_date", models.DateTimeField(default=None, null=True)),
                (
                    "finished_level",
                    models.PositiveIntegerField(
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(5),
                        ]
                    ),
                ),
                ("level_end_sp", models.PositiveIntegerField(default=None, null=True)),
                (
                    "level_start_sp",
                    models.PositiveIntegerField(default=None, null=True),
                ),
                ("start_date", models.DateTimeField(default=None, null=True)),
                (
                    "training_start_sp",
                    models.PositiveIntegerField(default=None, null=True),
                ),
                (
                    "character",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="skillqueue",
                        to="skillfarm.skillfarmaudit",
                    ),
                ),
                (
                    "eve_type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="eveuniverse.evetype",
                    ),
                ),
            ],
            options={
                "default_permissions": (),
            },
        ),
        migrations.CreateModel(
            name="CharacterSkill",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "active_skill_level",
                    models.PositiveIntegerField(
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(5),
                        ]
                    ),
                ),
                ("skillpoints_in_skill", models.PositiveBigIntegerField()),
                (
                    "trained_skill_level",
                    models.PositiveBigIntegerField(
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(5),
                        ]
                    ),
                ),
                (
                    "character",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="character_skills",
                        to="skillfarm.skillfarmaudit",
                    ),
                ),
                (
                    "eve_type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="eveuniverse.evetype",
                    ),
                ),
            ],
            options={
                "default_permissions": (),
            },
        ),
    ]
