# Generated by Django 4.2.20 on 2025-05-04 21:51

# Django
import django.db.models.deletion
from django.db import migrations, models


def create_update_status(apps, schema_editor):
    CharacterUpdateStatus = apps.get_model("skillfarm", "CharacterUpdateStatus")
    SkillFarmAudit = apps.get_model("skillfarm", "SkillFarmAudit")

    for character in SkillFarmAudit.objects.all():
        sections = ["skills", "skillqueue"]
        for section in sections:
            update_status = CharacterUpdateStatus.objects.get_or_create(
                character=character,
                section=section,
            )[0]
            update_status.is_success = None
            update_status.error_message = ""
            update_status.has_token_error = False
            update_status.last_run_at = None
            update_status.last_run_finished_at = None
            update_status.save()


class Migration(migrations.Migration):

    dependencies = [
        ("skillfarm", "0005_alter_characterskill_character_and_more"),
    ]

    operations = [
        migrations.RunPython(create_update_status),
    ]
