# Generated by Django 5.0.10 on 2025-01-08 15:09

from django.db import migrations, models


def set_endpoint_type(apps, schema_editor):
    SearchModelConfig = apps.get_model("database", "SearchModelConfig")
    SearchModelConfig.objects.filter(embeddings_inference_endpoint__isnull=False).exclude(
        embeddings_inference_endpoint=""
    ).update(embeddings_inference_endpoint_type="huggingface")


class Migration(migrations.Migration):
    dependencies = [
        ("database", "0078_khojuser_email_verification_code_expiry"),
    ]

    operations = [
        migrations.AddField(
            model_name="searchmodelconfig",
            name="embeddings_inference_endpoint_type",
            field=models.CharField(
                choices=[("huggingface", "Huggingface"), ("openai", "Openai"), ("local", "Local")],
                default="local",
                max_length=200,
            ),
        ),
        migrations.RunPython(set_endpoint_type, reverse_code=migrations.RunPython.noop),
    ]
