# Generated by Django 5.1.10 on 2025-06-28 06:50

from django.db import migrations, models


def initialize_friendly_names(apps, schema_editor):
    """Initialize friendly_name fields with values from the name/model_name fields"""
    ChatModel = apps.get_model("database", "ChatModel")
    SpeechToTextModelOptions = apps.get_model("database", "SpeechToTextModelOptions")
    TextToImageModelConfig = apps.get_model("database", "TextToImageModelConfig")

    # Initialize ChatModel friendly_name with name field
    ChatModel.objects.update(friendly_name=models.F("name"))

    # Initialize SpeechToTextModelOptions friendly_name with model_name field
    SpeechToTextModelOptions.objects.update(friendly_name=models.F("model_name"))

    # Initialize TextToImageModelConfig friendly_name with model_name field
    TextToImageModelConfig.objects.update(friendly_name=models.F("model_name"))


class Migration(migrations.Migration):
    dependencies = [
        ("database", "0090_alter_khojuser_uuid"),
    ]

    operations = [
        migrations.AddField(
            model_name="chatmodel",
            name="friendly_name",
            field=models.CharField(blank=True, default=None, max_length=200, null=True),
        ),
        migrations.AddField(
            model_name="speechtotextmodeloptions",
            name="friendly_name",
            field=models.CharField(blank=True, default=None, max_length=200, null=True),
        ),
        migrations.AddField(
            model_name="texttoimagemodelconfig",
            name="friendly_name",
            field=models.CharField(blank=True, default=None, max_length=200, null=True),
        ),
        migrations.RunPython(initialize_friendly_names, reverse_code=migrations.RunPython.noop),
    ]
