# This file was auto-generated by Fern from our API Definition.

import os
import typing

import httpx
from .chat.client import AsyncChatClient, ChatClient
from .core.api_error import ApiError
from .core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .environment import SarvamAIEnvironment
from .speech_to_text.client import AsyncSpeechToTextClient, SpeechToTextClient
from .speech_to_text_job.client import AsyncSpeechToTextJobClient, SpeechToTextJobClient
from .speech_to_text_streaming.client import AsyncSpeechToTextStreamingClient, SpeechToTextStreamingClient
from .speech_to_text_translate_job.client import AsyncSpeechToTextTranslateJobClient, SpeechToTextTranslateJobClient
from .speech_to_text_translate_streaming.client import (
    AsyncSpeechToTextTranslateStreamingClient,
    SpeechToTextTranslateStreamingClient,
)
from .text.client import AsyncTextClient, TextClient
from .text_to_speech.client import AsyncTextToSpeechClient, TextToSpeechClient
from .text_to_speech_streaming.client import AsyncTextToSpeechStreamingClient, TextToSpeechStreamingClient


class SarvamAI:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    environment : SarvamAIEnvironment
        The environment to use for requests from the client. from .environment import SarvamAIEnvironment



        Defaults to SarvamAIEnvironment.PRODUCTION



    api_subscription_key : typing.Optional[str]
    headers : typing.Optional[typing.Dict[str, str]]
        Additional headers to send with every request.

    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.Client]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from sarvamai import SarvamAI

    client = SarvamAI(
        api_subscription_key="YOUR_API_SUBSCRIPTION_KEY",
    )
    """

    def __init__(
        self,
        *,
        environment: SarvamAIEnvironment = SarvamAIEnvironment.PRODUCTION,
        api_subscription_key: typing.Optional[str] = os.getenv("SARVAM_API_KEY"),
        headers: typing.Optional[typing.Dict[str, str]] = None,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.Client] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        if api_subscription_key is None:
            raise ApiError(
                body="The client must be instantiated be either passing in api_subscription_key or setting SARVAM_API_KEY"
            )
        self._client_wrapper = SyncClientWrapper(
            environment=environment,
            api_subscription_key=api_subscription_key,
            headers=headers,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.Client(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.Client(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self.text = TextClient(client_wrapper=self._client_wrapper)
        self.speech_to_text = SpeechToTextClient(client_wrapper=self._client_wrapper)
        self.text_to_speech = TextToSpeechClient(client_wrapper=self._client_wrapper)
        self.chat = ChatClient(client_wrapper=self._client_wrapper)
        self.speech_to_text_job = SpeechToTextJobClient(client_wrapper=self._client_wrapper)
        self.speech_to_text_translate_job = SpeechToTextTranslateJobClient(client_wrapper=self._client_wrapper)
        self.speech_to_text_streaming = SpeechToTextStreamingClient(client_wrapper=self._client_wrapper)
        self.speech_to_text_translate_streaming = SpeechToTextTranslateStreamingClient(
            client_wrapper=self._client_wrapper
        )
        self.text_to_speech_streaming = TextToSpeechStreamingClient(client_wrapper=self._client_wrapper)


class AsyncSarvamAI:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    environment : SarvamAIEnvironment
        The environment to use for requests from the client. from .environment import SarvamAIEnvironment



        Defaults to SarvamAIEnvironment.PRODUCTION



    api_subscription_key : typing.Optional[str]
    headers : typing.Optional[typing.Dict[str, str]]
        Additional headers to send with every request.

    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.AsyncClient]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from sarvamai import AsyncSarvamAI

    client = AsyncSarvamAI(
        api_subscription_key="YOUR_API_SUBSCRIPTION_KEY",
    )
    """

    def __init__(
        self,
        *,
        environment: SarvamAIEnvironment = SarvamAIEnvironment.PRODUCTION,
        api_subscription_key: typing.Optional[str] = os.getenv("SARVAM_API_KEY"),
        headers: typing.Optional[typing.Dict[str, str]] = None,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.AsyncClient] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        if api_subscription_key is None:
            raise ApiError(
                body="The client must be instantiated be either passing in api_subscription_key or setting SARVAM_API_KEY"
            )
        self._client_wrapper = AsyncClientWrapper(
            environment=environment,
            api_subscription_key=api_subscription_key,
            headers=headers,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self.text = AsyncTextClient(client_wrapper=self._client_wrapper)
        self.speech_to_text = AsyncSpeechToTextClient(client_wrapper=self._client_wrapper)
        self.text_to_speech = AsyncTextToSpeechClient(client_wrapper=self._client_wrapper)
        self.chat = AsyncChatClient(client_wrapper=self._client_wrapper)
        self.speech_to_text_job = AsyncSpeechToTextJobClient(client_wrapper=self._client_wrapper)
        self.speech_to_text_translate_job = AsyncSpeechToTextTranslateJobClient(client_wrapper=self._client_wrapper)
        self.speech_to_text_streaming = AsyncSpeechToTextStreamingClient(client_wrapper=self._client_wrapper)
        self.speech_to_text_translate_streaming = AsyncSpeechToTextTranslateStreamingClient(
            client_wrapper=self._client_wrapper
        )
        self.text_to_speech_streaming = AsyncTextToSpeechStreamingClient(client_wrapper=self._client_wrapper)
