# This file was auto-generated by Fern from our API Definition.

import typing
from contextlib import asynccontextmanager, contextmanager

import httpx
import websockets.exceptions
import websockets.sync.client as websockets_sync_client
from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .raw_client import AsyncRawSpeechToTextStreamingClient, RawSpeechToTextStreamingClient
from .socket_client import AsyncSpeechToTextStreamingSocketClient, SpeechToTextStreamingSocketClient
from .types.speech_to_text_streaming_high_vad_sensitivity import SpeechToTextStreamingHighVadSensitivity
from .types.speech_to_text_streaming_language_code import SpeechToTextStreamingLanguageCode
from .types.speech_to_text_streaming_model import SpeechToTextStreamingModel
from .types.speech_to_text_streaming_vad_signals import SpeechToTextStreamingVadSignals

try:
    from websockets.legacy.client import connect as websockets_client_connect  # type: ignore
except ImportError:
    from websockets import connect as websockets_client_connect  # type: ignore


class SpeechToTextStreamingClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawSpeechToTextStreamingClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawSpeechToTextStreamingClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawSpeechToTextStreamingClient
        """
        return self._raw_client

    @contextmanager
    def connect(
        self,
        *,
        language_code: SpeechToTextStreamingLanguageCode,
        model: typing.Optional[SpeechToTextStreamingModel] = None,
        high_vad_sensitivity: typing.Optional[SpeechToTextStreamingHighVadSensitivity] = None,
        vad_signals: typing.Optional[SpeechToTextStreamingVadSignals] = None,
        api_subscription_key: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Iterator[SpeechToTextStreamingSocketClient]:
        """
        WebSocket channel for real-time speech to text streaming

        Parameters
        ----------
        language_code : SpeechToTextStreamingLanguageCode
            Language code for speech recognition

        model : typing.Optional[SpeechToTextStreamingModel]
            Speech to text model to use

        high_vad_sensitivity : typing.Optional[SpeechToTextStreamingHighVadSensitivity]
            Enable high VAD (Voice Activity Detection) sensitivity

        vad_signals : typing.Optional[SpeechToTextStreamingVadSignals]
            Enable VAD signals in response

        api_subscription_key : typing.Optional[str]
            API subscription key for authentication

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SpeechToTextStreamingSocketClient
        """
        ws_url = self._raw_client._client_wrapper.get_environment().production + "/speech-to-text/ws"
        query_params = httpx.QueryParams()
        if language_code is not None:
            query_params = query_params.add("language-code", language_code)
        if model is not None:
            query_params = query_params.add("model", model)
        if high_vad_sensitivity is not None:
            query_params = query_params.add("high_vad_sensitivity", high_vad_sensitivity)
        if vad_signals is not None:
            query_params = query_params.add("vad_signals", vad_signals)
        ws_url = ws_url + f"?{query_params}"
        headers = self._raw_client._client_wrapper.get_headers()
        if api_subscription_key is not None:
            headers["Api-Subscription-Key"] = str(api_subscription_key)
        if request_options and "additional_headers" in request_options:
            headers.update(request_options["additional_headers"])
        try:
            with websockets_sync_client.connect(ws_url, additional_headers=headers) as protocol:
                yield SpeechToTextStreamingSocketClient(websocket=protocol)
        except websockets.exceptions.InvalidStatusCode as exc:
            status_code: int = exc.status_code
            if status_code == 401:
                raise ApiError(
                    status_code=status_code,
                    headers=dict(headers),
                    body="Websocket initialized with invalid credentials.",
                )
            raise ApiError(
                status_code=status_code,
                headers=dict(headers),
                body="Unexpected error when initializing websocket connection.",
            )


class AsyncSpeechToTextStreamingClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawSpeechToTextStreamingClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawSpeechToTextStreamingClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawSpeechToTextStreamingClient
        """
        return self._raw_client

    @asynccontextmanager
    async def connect(
        self,
        *,
        language_code: SpeechToTextStreamingLanguageCode,
        model: typing.Optional[SpeechToTextStreamingModel] = None,
        high_vad_sensitivity: typing.Optional[SpeechToTextStreamingHighVadSensitivity] = None,
        vad_signals: typing.Optional[SpeechToTextStreamingVadSignals] = None,
        api_subscription_key: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.AsyncIterator[AsyncSpeechToTextStreamingSocketClient]:
        """
        WebSocket channel for real-time speech to text streaming

        Parameters
        ----------
        language_code : SpeechToTextStreamingLanguageCode
            Language code for speech recognition

        model : typing.Optional[SpeechToTextStreamingModel]
            Speech to text model to use

        high_vad_sensitivity : typing.Optional[SpeechToTextStreamingHighVadSensitivity]
            Enable high VAD (Voice Activity Detection) sensitivity

        vad_signals : typing.Optional[SpeechToTextStreamingVadSignals]
            Enable VAD signals in response

        api_subscription_key : typing.Optional[str]
            API subscription key for authentication

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncSpeechToTextStreamingSocketClient
        """
        ws_url = self._raw_client._client_wrapper.get_environment().production + "/speech-to-text/ws"
        query_params = httpx.QueryParams()
        if language_code is not None:
            query_params = query_params.add("language-code", language_code)
        if model is not None:
            query_params = query_params.add("model", model)
        if high_vad_sensitivity is not None:
            query_params = query_params.add("high_vad_sensitivity", high_vad_sensitivity)
        if vad_signals is not None:
            query_params = query_params.add("vad_signals", vad_signals)
        ws_url = ws_url + f"?{query_params}"
        headers = self._raw_client._client_wrapper.get_headers()
        if api_subscription_key is not None:
            headers["Api-Subscription-Key"] = str(api_subscription_key)
        if request_options and "additional_headers" in request_options:
            headers.update(request_options["additional_headers"])
        try:
            async with websockets_client_connect(ws_url, extra_headers=headers) as protocol:
                yield AsyncSpeechToTextStreamingSocketClient(websocket=protocol)
        except websockets.exceptions.InvalidStatusCode as exc:
            status_code: int = exc.status_code
            if status_code == 401:
                raise ApiError(
                    status_code=status_code,
                    headers=dict(headers),
                    body="Websocket initialized with invalid credentials.",
                )
            raise ApiError(
                status_code=status_code,
                headers=dict(headers),
                body="Unexpected error when initializing websocket connection.",
            )
